/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.spatialvisual;

import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.widgets.OTButtonGroup;
import alma.obsprep.ot.editors.spatialvisual.RestFrequencyDialog;
import alma.obsprep.ot.editors.spatialvisual.RestFrequencyModel;
import alma.obsprep.ot.editors.spatialvisual.RestFrequencyParameters;
import alma.obsprep.ot.editors.valuetypes.ValueUnitPairEditor;
import alma.obsprep.services.experts.spectralline.DialogSpectralLineChooser;
import alma.obsprep.services.experts.spectralline.SpectralLinePublisher;
import alma.valuetypes.Velocity;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;

class RestFrequencyEditor
extends Editor {
    private JButton catalogButton;

    public RestFrequencyEditor(Model model) {
        this.setModel(model);
        this.build();
        model.publish();
    }

    @Override
    public void build() {
        RestFrequencyModel restFrequencyModel = (RestFrequencyModel)this.getModel();
        ValueUnitPairEditor valueUnitPairEditor = new ValueUnitPairEditor(restFrequencyModel.getFrequencyModel());
        this.catalogButton = new JButton("Catalog");
        this.catalogButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RestFrequencyEditor.this.catalogButton.setEnabled(false);
                SpectralLinePublisher spectralLinePublisher = DialogSpectralLineChooser.getInstance().createPublisher(RestFrequencyEditor.this, RestFrequencyDialog.FID_CATALOGBUTTON, RestFrequencyEditor.this.catalogButton);
                Velocity velocity = Velocity.createVelocity();
                DialogSpectralLineChooser.getInstance().chooseSingleLine(spectralLinePublisher, velocity);
            }
        });
        JLabel jLabel = new JLabel("SpectralType");
        OTButtonGroup oTButtonGroup = new OTButtonGroup(RestFrequencyParameters.getKnownTypeList());
        this.initEvents(oTButtonGroup, RestFrequencyDialog.FID_SPECTRALTYPE);
        this.addLabeledWidget(jLabel, oTButtonGroup);
        jLabel = new JLabel("RestFrequency");
        Box box = Box.createHorizontalBox();
        box.add(valueUnitPairEditor);
        box.add(this.catalogButton);
        this.addLabeledWidget(jLabel, box);
        this.layoutLabeledWidgets();
    }

    @Override
    public void update(FieldID fieldID, Object object) {
        if (fieldID.equals(RestFrequencyDialog.FID_SPECTRALTYPE)) {
            this.catalogButtonEnable((String)object);
        }
        super.update(fieldID, object);
    }

    private void catalogButtonEnable(String string) {
        this.catalogButton.setEnabled(RestFrequencyParameters.TYPE_LINE.equals(string));
    }
}

