/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.gui.toplevel;

import alma.obsprep.ot.gui.preferences.AdvancedPanel;
import alma.obsprep.ot.gui.preferences.AppearancePanel;
import alma.obsprep.ot.gui.preferences.ColorPanel;
import alma.obsprep.ot.gui.preferences.ConnectionPanel;
import alma.obsprep.ot.gui.preferences.DialogsPanel;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.ot.gui.toplevel.ObservingToolController;
import alma.obsprep.ot.gui.toplevel.ObservingToolGui;
import alma.obsprep.ot.gui.toplevel.PreferencesReadWrite;
import alma.obsprep.ot.gui.toplevel.UserAuthenticator;
import alma.obsprep.services.network.roledirectory.RoleDirectoryService;
import alma.obsprep.util.GUIUtilities;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;

public class PreferencesDialog
extends JDialog
implements Iterable<PreferencesReadWrite>,
RoleDirectoryService.UserAuthenticatesListener {
    public static final String TAB_APPEARANCE = "Appearance";
    public static final String TAB_CONNECTION = "Connection";
    public static final String TAB_ADVANCED = "Advanced";
    public static final String TAB_COLORS = "Colours";
    public static final String TAB_DIALOGS = "Dialogs";
    public static final String TAB_TELESCOPE = "Telescope";
    public static final String TAB_NOCHANGE = "NoChange";
    protected final ObservingToolController controller;
    private final AppearancePanel appearance;
    private final ColorPanel color;
    private final DialogsPanel dialog;
    private final AdvancedPanel advanced;
    private final ConnectionPanel connection;
    JTabbedPane tabPreferences = new JTabbedPane();
    JPanel pnlContainerPrefDialog = new JPanel();
    JPanel pnlButtonsPrefDialog = new JPanel();
    JButton btnOKPrefDialog;
    JButton btnCancelPrefDialog;
    JButton btnApplyPrefDialog;

    public static void main(String[] stringArray) {
        InitServices.initModelSupportClasses();
        ObservingToolController observingToolController = new ObservingToolController();
        UserAuthenticator userAuthenticator = new UserAuthenticator();
        observingToolController.heap().setUserAuthenticator(userAuthenticator);
        ObservingToolGui observingToolGui = new ObservingToolGui(observingToolController);
        PreferencesDialog preferencesDialog = new PreferencesDialog(observingToolController, observingToolGui);
        preferencesDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        preferencesDialog.setVisible(true);
    }

    @Override
    public Iterator<PreferencesReadWrite> iterator() {
        return new Iterator<PreferencesReadWrite>(){
            int idx = 0;

            @Override
            public boolean hasNext() {
                return this.idx < PreferencesDialog.this.tabPreferences.getTabCount();
            }

            @Override
            public PreferencesReadWrite next() {
                return (PreferencesReadWrite)((Object)PreferencesDialog.this.tabPreferences.getComponentAt(this.idx++));
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public void writePreferences(String string) {
        if (string.equals("")) {
            for (PreferencesReadWrite preferencesReadWrite : this) {
                preferencesReadWrite.writePreferences(this.controller.getPreferences());
            }
        } else {
            int n = this.tabPreferences.getTabCount();
            for (int i = 0; i < n; ++i) {
                if (!string.equals(this.tabPreferences.getTitleAt(i))) continue;
                PreferencesReadWrite preferencesReadWrite = (PreferencesReadWrite)((Object)this.tabPreferences.getComponentAt(i));
                preferencesReadWrite.writePreferences(this.controller.getPreferences());
            }
        }
    }

    PreferencesDialog(ObservingToolController observingToolController, ObservingToolGui observingToolGui) {
        super(observingToolGui.frame);
        this.setName("PrefDialog");
        this.tabPreferences.setName("PrefDialog.tabs");
        this.controller = observingToolController;
        this.setTitle("Preferences");
        this.setModal(true);
        this.appearance = new AppearancePanel(observingToolGui);
        this.color = new ColorPanel(observingToolGui);
        this.dialog = new DialogsPanel();
        this.advanced = new AdvancedPanel(observingToolController, observingToolGui, this);
        this.connection = new ConnectionPanel(observingToolController);
        this.tabPreferences.addTab(TAB_APPEARANCE, this.appearance);
        this.tabPreferences.addTab(TAB_COLORS, this.color);
        this.tabPreferences.addTab(TAB_DIALOGS, this.dialog);
        this.tabPreferences.addTab(TAB_CONNECTION, this.connection);
        this.tabPreferences.addTab(TAB_ADVANCED, this.advanced);
        this.pnlContainerPrefDialog.setLayout(new BoxLayout(this.pnlContainerPrefDialog, 1));
        this.pnlContainerPrefDialog.add(this.tabPreferences);
        this.pnlContainerPrefDialog.add(this.pnlButtonsPrefDialog);
        CancelAction cancelAction = new CancelAction("Cancel", 67);
        this.btnCancelPrefDialog = new JButton(cancelAction);
        this.btnCancelPrefDialog.setName("PrefDialog.btnCancel");
        this.btnCancelPrefDialog.setFocusable(false);
        this.pnlButtonsPrefDialog.add(this.btnCancelPrefDialog);
        ApplyAction applyAction = new ApplyAction("Apply", 65);
        this.btnApplyPrefDialog = new JButton(applyAction);
        this.btnApplyPrefDialog.setName("PrefDialog.btnApply");
        this.btnApplyPrefDialog.setFocusable(false);
        this.pnlButtonsPrefDialog.add(this.btnApplyPrefDialog);
        OKAction oKAction = new OKAction("OK", 79);
        this.btnOKPrefDialog = new JButton(oKAction);
        this.btnOKPrefDialog.setName("PrefDialog.btnOK");
        this.btnOKPrefDialog.setFocusable(false);
        this.pnlButtonsPrefDialog.add(this.btnOKPrefDialog);
        this.getRootPane().setDefaultButton(this.btnOKPrefDialog);
        this.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), cancelAction.getValue("Name"));
        this.getRootPane().getActionMap().put(cancelAction.getValue("Name"), cancelAction);
        this.getContentPane().add(this.pnlContainerPrefDialog);
        this.pack();
    }

    void show(String string) {
        int n;
        for (PreferencesReadWrite preferencesReadWrite : this) {
            preferencesReadWrite.readPreferences(this.controller.getPreferences());
        }
        if (!string.equals(TAB_NOCHANGE) && (n = this.tabPreferences.indexOfTab(string)) >= 0) {
            this.tabPreferences.setSelectedIndex(n);
        }
        if (this.getX() == 0 && this.getY() == 0) {
            this.setLocationRelativeTo(this.getParent());
            this.pack();
        }
        super.setVisible(true);
    }

    public void advancedOptionQuickApply() {
        try {
            ObservingToolController.AdvancedOptions advancedOptions = this.controller.advancedOptionsAssess();
            this.connection.readAdvancedOptions(advancedOptions);
            this.advanced.readAdvancedOptions(advancedOptions);
            boolean bl = this.controller.getPreferences().getAdvancedUser();
            boolean bl2 = advancedOptions.isShowStaffActions();
            if (bl & !bl2) {
                GUIUtilities.info(null, "You do not have permission to enable privileged operations.");
            }
        }
        catch (IOException iOException) {
            GUIUtilities.error(null, "Failed to contact the permission server. Cannot enable privileged operations.");
        }
    }

    @Override
    public void userHasAuthenticated() {
        this.advancedOptionQuickApply();
        this.controller.firePreferencesChanged();
    }

    private class CancelAction
    extends AbstractAction {
        CancelAction(String string, int n) {
            super(string);
            this.putValue("MnemonicKey", n);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PreferencesDialog.this.setVisible(false);
        }
    }

    private class ApplyAction
    extends AbstractAction {
        ApplyAction(String string, int n) {
            super(string);
            this.putValue("MnemonicKey", n);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            for (PreferencesReadWrite preferencesReadWrite : PreferencesDialog.this) {
                preferencesReadWrite.writePreferences(PreferencesDialog.this.controller.getPreferences());
            }
            PreferencesDialog.this.controller.firePreferencesChanged();
        }
    }

    private class OKAction
    extends ApplyAction {
        OKAction(String string, int n) {
            super(string, n);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            super.actionPerformed(actionEvent);
            PreferencesDialog.this.setVisible(false);
        }
    }
}

