/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.valdef.obsproject;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.bo.IBusinessObject;
import alma.hla.runtime.obsprep.util.Log;
import alma.observatorycharacteristics.policies.AlmaPolicies;
import alma.obsprep.bo.enumerations.Array;
import alma.obsprep.bo.obsproject.Rectangle;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.ot.valdef.AbstractValidator;
import alma.obsprep.ot.valdef.ProblemListModel;
import alma.obsprep.problems.DefaultProblem;
import alma.obsprep.problems.Problem;
import alma.valuetypes.Angle;

public class RectangleValidator
extends AbstractValidator {
    public RectangleValidator() {
        this.setValidatorThreadSafe(true);
    }

    @Override
    protected void localValidate(BusinessObject businessObject, ProblemListModel problemListModel) {
        Problem problem;
        Rectangle rectangle = (Rectangle)businessObject;
        if (!rectangle.getLong().hasContent()) {
            problem = DefaultProblem.createError("There is no value for the rectangle p length", "Select the Field Setup in the Science Goal and enter a valid value", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        } else if (rectangle.getLong().getContentInUnits(Angle.UNIT_ARCSEC) <= 0.0) {
            problem = DefaultProblem.createError("Desired rectangle p length is too small", "Select the Field Setup in the Science Goal and enter a valid value", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
        if (!rectangle.getShort().hasContent()) {
            problem = DefaultProblem.createError("There is no value for the rectangle q length", "Select the Field Setup in the Science Goal and enter a valid value", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        } else if (rectangle.getLong().getContentInUnits(Angle.UNIT_ARCSEC) <= 0.0) {
            problem = DefaultProblem.createError("Desired rectangle q length is too small", "Select the Field Setup in the Science Goal and enter a valid value", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
        if (!rectangle.getPALong().hasContent()) {
            problem = DefaultProblem.createError("There is no value for the rectangle position angle", "Select the Field Setup in the Science Goal and enter a valid value", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
        if (!rectangle.getSpacing().hasContent()) {
            problem = DefaultProblem.createError("There is no value for the rectangle spacing", "Select the Field Setup in the Science Goal and enter a valid value", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        } else if (rectangle.getSpacing().getContentInUnits(Angle.UNIT_ARCSEC) <= 0.0) {
            problem = DefaultProblem.createError("Desired rectangle spacing is too small", "Select the Field Setup in the Science Goal and enter a valid value", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
        int n = AlmaPolicies.getInstance().getMaxNumberPointings();
        Array array = Array.ARRAY_12M;
        try {
            if (rectangle.getTargetParameters().getScienceGoal().getScienceGoalMode().equals((Object)ScienceGoal.ScienceGoalMode.STANDALONEACA)) {
                array = Array.ARRAY_7M;
            }
        }
        catch (Exception exception) {
            Log.logger(RectangleValidator.class).info("Unable to determine if standalone ACA  : " + exception.getMessage());
        }
        int n2 = rectangle.getNumberOfPointings(array);
        if (n2 > n) {
            problem = DefaultProblem.createError("Map definition will create too many pointings (" + n2 + ") for a pointed mosaic (limit is " + n + ")", "Select the Field Setup in the Science Goal and try reducing map size or increasing spacing", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
    }
}

