/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.etc.editor;

import alma.common.sensitivitycalculatorcore.calc.ExposureTimeCalculator;
import alma.common.sensitivitycalculatorcore.exceptions.SourceNeverVisibleException;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.InvalidCoordException;
import alma.obsprep.guiutil.mvc.OutOfRangeException;
import alma.obsprep.guiutil.mvc.verifiers.DecVerifier;
import alma.obsprep.util.Convert;
import alma.valuetypes.Latitude;
import javax.swing.JTextField;

class SourceVisibleDecVerifier
extends DecVerifier {
    private double observatoryLatitude = -23.02271113;

    SourceVisibleDecVerifier(Editor editor, JTextField jTextField) {
        super(editor, jTextField);
    }

    private boolean isValidObservatoryLatitude() {
        return this.observatoryLatitude <= 90.0 && this.observatoryLatitude >= -90.0;
    }

    public void setObservatoryLaitude(Latitude latitude) {
        this.observatoryLatitude = latitude.getContentInUnits(Latitude.UNIT_DEG);
    }

    public void setObservatoryLatitude(double d) {
        this.observatoryLatitude = d;
    }

    @Override
    public Object validate(JTextField jTextField) throws OutOfRangeException, InvalidCoordException, NumberFormatException {
        String string = (String)super.validate(jTextField);
        if (this.isValidObservatoryLatitude()) {
            double d = Convert.DDMMSSToDeg(string);
            try {
                ExposureTimeCalculator.checkSourceVisible((double)d, (double)this.observatoryLatitude);
            }
            catch (SourceNeverVisibleException sourceNeverVisibleException) {
                throw new OutOfRangeException(sourceNeverVisibleException.getMessage());
            }
        }
        return string;
    }
}

