/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.experts.spectralline;

import alma.obsprep.services.experts.spectralline.SpectralLine;
import alma.valuetypes.Frequency;
import java.util.EnumSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SpectralLineCsvEntry {
    private Integer line_id;
    private Integer species_id;
    private String s_name_noparens;
    private String chemical_name;
    private Double orderedfreq;
    private String resolved_QNs;
    private Double sijmu2;
    private Double E_up_K;
    private String lovas_int;
    private Integer top20;
    private boolean planet = false;
    private boolean ism_hotcore = false;
    private boolean ism_diffusecloud = false;
    private boolean comet = false;
    private boolean ism_darkcloud = false;
    private boolean extragalactic = false;
    private boolean agb_ppn_pn = false;
    private final Pattern number = Pattern.compile("-?(?:0|[1-9]\\d*)(?:\\.\\d*)?(?:[eE][+\\-]?\\d+)?");

    public SpectralLine toSpectralLine() {
        SpectralLine spectralLine = new SpectralLine();
        spectralLine.setType(SpectralLine.Type.OFFLINE);
        spectralLine.setLineId(this.line_id);
        spectralLine.setSpecies(this.s_name_noparens);
        spectralLine.setDescription(this.chemical_name);
        spectralLine.setFrequency(Frequency.createFrequencyMHZ(this.orderedfreq));
        spectralLine.setTransition(this.resolved_QNs);
        spectralLine.setObservedIntensity(this.getNumericObsIntensity());
        spectralLine.setSmu(this.sijmu2);
        spectralLine.setUpperStateEnergy(this.E_up_K);
        spectralLine.setFlags(this.getFlags());
        spectralLine.setProvenance("Offline");
        return spectralLine;
    }

    private Double getNumericObsIntensity() {
        Matcher matcher = this.number.matcher(this.lovas_int);
        while (matcher.find()) {
            String string = this.lovas_int.substring(matcher.start(), matcher.end());
            Double d = Double.parseDouble(string);
            if (d == 0.0) continue;
            return d;
        }
        return null;
    }

    private EnumSet<SpectralLine.Flag> getFlags() {
        EnumSet<SpectralLine.Flag> enumSet = EnumSet.noneOf(SpectralLine.Flag.class);
        if (this.planet) {
            enumSet.add(SpectralLine.Flag.PLANET);
        }
        if (this.ism_hotcore) {
            enumSet.add(SpectralLine.Flag.ISM_HOTCORE);
        }
        if (this.ism_diffusecloud) {
            enumSet.add(SpectralLine.Flag.ISM_DIFFUSECLOUD);
        }
        if (this.comet) {
            enumSet.add(SpectralLine.Flag.COMET);
        }
        if (this.ism_darkcloud) {
            enumSet.add(SpectralLine.Flag.ISM_DARK_CLOUD);
        }
        if (this.extragalactic) {
            enumSet.add(SpectralLine.Flag.EXTRAGALACTIC);
        }
        if (this.agb_ppn_pn) {
            enumSet.add(SpectralLine.Flag.AGB_PPN_PN);
        }
        if (this.top20 > 0) {
            enumSet.add(SpectralLine.Flag.COMMON);
        }
        return enumSet;
    }

    public Integer getLine_id() {
        return this.line_id;
    }

    public void setLine_id(Integer n) {
        this.line_id = n;
    }

    public Integer getSpecies_id() {
        return this.species_id;
    }

    public void setSpecies_id(Integer n) {
        this.species_id = n;
    }

    public String getS_name_noparens() {
        return this.s_name_noparens;
    }

    public void setS_name_noparens(String string) {
        this.s_name_noparens = string;
    }

    public String getChemical_name() {
        return this.chemical_name;
    }

    public void setChemical_name(String string) {
        this.chemical_name = string;
    }

    public Double getOrderedfreq() {
        return this.orderedfreq;
    }

    public void setOrderedfreq(Double d) {
        this.orderedfreq = d;
    }

    public String getResolved_QNs() {
        return this.resolved_QNs;
    }

    public void setResolved_QNs(String string) {
        this.resolved_QNs = string;
    }

    public Double getSijmu2() {
        return this.sijmu2;
    }

    public void setSijmu2(Double d) {
        if (d >= 0.0) {
            this.sijmu2 = d;
        }
    }

    public Double getE_up_K() {
        return this.E_up_K;
    }

    public void setE_up_K(Double d) {
        if (d >= 0.0) {
            this.E_up_K = d;
        }
    }

    public String getLovas_int() {
        return this.lovas_int;
    }

    public void setLovas_int(String string) {
        this.lovas_int = string;
    }

    public Integer getTop20() {
        return this.top20;
    }

    public void setTop20(Integer n) {
        this.top20 = n;
    }

    public boolean isPlanet() {
        return this.planet;
    }

    public void setPlanet(boolean bl) {
        this.planet = bl;
    }

    public boolean isIsm_hotcore() {
        return this.ism_hotcore;
    }

    public void setIsm_hotcore(boolean bl) {
        this.ism_hotcore = bl;
    }

    public boolean isIsm_diffusecloud() {
        return this.ism_diffusecloud;
    }

    public void setIsm_diffusecloud(boolean bl) {
        this.ism_diffusecloud = bl;
    }

    public boolean isComet() {
        return this.comet;
    }

    public void setComet(boolean bl) {
        this.comet = bl;
    }

    public boolean isIsm_darkcloud() {
        return this.ism_darkcloud;
    }

    public void setIsm_darkcloud(boolean bl) {
        this.ism_darkcloud = bl;
    }

    public boolean isExtragalactic() {
        return this.extragalactic;
    }

    public void setExtragalactic(boolean bl) {
        this.extragalactic = bl;
    }

    public boolean isAgb_ppn_pn() {
        return this.agb_ppn_pn;
    }

    public void setAgb_ppn_pn(boolean bl) {
        this.agb_ppn_pn = bl;
    }

    public Pattern getNumber() {
        return this.number;
    }
}

