/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored.spectralspec;

import alma.hla.runtime.obsprep.bo.ValueUnitPair;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.enumerations.Antenna;
import alma.obsprep.bo.obsproject.Rectangle;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.obsproject.TargetWithIntent;
import alma.obsprep.bo.schedblock.ACACorrelatorConfiguration;
import alma.obsprep.bo.schedblock.ACAPhaseSwitchingConfiguration;
import alma.obsprep.bo.schedblock.ACASpectrometerCorrelatorConfiguration;
import alma.obsprep.bo.schedblock.AbstractBaseBandConfig;
import alma.obsprep.bo.schedblock.AbstractCorrelatorConfiguration;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.services.experts.CorrelatorExpert;
import alma.obsprep.services.experts.MinBoundingBoxExpert;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.services.generator.refactored.ObsType;
import alma.obsprep.services.generator.refactored.SchedBlockWorker;
import alma.obsprep.services.generator.refactored.spectralspec.SpectralSpecFactory;
import alma.valuetypes.Angle;
import alma.valuetypes.Frequency;
import alma.valuetypes.Time;
import alma.valuetypes.UserAngle;
import java.util.Optional;
import lombok.NonNull;

public class TotalPowerSpectralSpecFactory {
    private void configureTPDelayAndFocusSpectralSpec(SpectralSpec spectralSpec, @NonNull AbstractCorrelatorConfiguration abstractCorrelatorConfiguration) {
        if (abstractCorrelatorConfiguration == null) {
            throw new NullPointerException("abstractCorrelatorConfiguration is marked non-null but is null");
        }
        abstractCorrelatorConfiguration.setChannelAverageDuration(Time.createTime((double)1.008, (String)Time.UNIT_S));
        abstractCorrelatorConfiguration.setIntegrationDuration(Time.createTime((double)10.08, (String)Time.UNIT_S));
        this.setDataProduct(spectralSpec, AbstractBaseBandConfig.DATAPRODUCTS_CROSS_AND_AUTO);
        abstractCorrelatorConfiguration.setCAM(AbstractCorrelatorConfiguration.CAM_NORMAL);
        abstractCorrelatorConfiguration.setLOOffsettingMode(AbstractCorrelatorConfiguration.LOOFFSETTINGMODE_TWO_LOS);
        abstractCorrelatorConfiguration.setEnable180DegreeWalshFunction(false);
        abstractCorrelatorConfiguration.setEnable90DegreeWalshFunction(false);
        if (abstractCorrelatorConfiguration instanceof ACACorrelatorConfiguration) {
            ACACorrelatorConfiguration aCACorrelatorConfiguration = (ACACorrelatorConfiguration)((Object)abstractCorrelatorConfiguration);
            ACAPhaseSwitchingConfiguration aCAPhaseSwitchingConfiguration = ACAPhaseSwitchingConfiguration.createACAPhaseSwitchingConfiguration();
            aCAPhaseSwitchingConfiguration.setDoD180demodulation(false);
            aCAPhaseSwitchingConfiguration.setDoD180modulation(false);
            aCACorrelatorConfiguration.setACAPhaseSwitchingConfiguration(aCAPhaseSwitchingConfiguration);
        } else if (abstractCorrelatorConfiguration instanceof ACASpectrometerCorrelatorConfiguration) {
            ACASpectrometerCorrelatorConfiguration aCASpectrometerCorrelatorConfiguration = (ACASpectrometerCorrelatorConfiguration)((Object)abstractCorrelatorConfiguration);
            ACAPhaseSwitchingConfiguration aCAPhaseSwitchingConfiguration = ACAPhaseSwitchingConfiguration.createACAPhaseSwitchingConfiguration();
            aCAPhaseSwitchingConfiguration.setDoD180demodulation(false);
            aCAPhaseSwitchingConfiguration.setDoD180modulation(false);
            aCASpectrometerCorrelatorConfiguration.setACAPhaseSwitchingConfiguration(aCAPhaseSwitchingConfiguration);
        }
    }

    private void configureTPScienceAndAmplitudeSpectralSpecs(@NonNull SpectralSpec spectralSpec, @NonNull AbstractCorrelatorConfiguration abstractCorrelatorConfiguration, ObsType obsType, SpectralSetupParameters spectralSetupParameters) {
        if (spectralSpec == null) {
            throw new NullPointerException("ss is marked non-null but is null");
        }
        if (abstractCorrelatorConfiguration == null) {
            throw new NullPointerException("abstractCorrelatorConfiguration is marked non-null but is null");
        }
        abstractCorrelatorConfiguration.setLOOffsettingMode(AbstractCorrelatorConfiguration.LOOFFSETTINGMODE_TWO_LOS);
        abstractCorrelatorConfiguration.setEnable180DegreeWalshFunction(false);
        abstractCorrelatorConfiguration.setEnable90DegreeWalshFunction(false);
        abstractCorrelatorConfiguration.setCAM(AbstractCorrelatorConfiguration.CAM_FAST);
        if (abstractCorrelatorConfiguration instanceof ACACorrelatorConfiguration) {
            ACACorrelatorConfiguration aCACorrelatorConfiguration = (ACACorrelatorConfiguration)((Object)abstractCorrelatorConfiguration);
            ACAPhaseSwitchingConfiguration aCAPhaseSwitchingConfiguration = ACAPhaseSwitchingConfiguration.createACAPhaseSwitchingConfiguration();
            aCAPhaseSwitchingConfiguration.setDoD180demodulation(false);
            aCAPhaseSwitchingConfiguration.setDoD180modulation(false);
            aCACorrelatorConfiguration.setACAPhaseSwitchingConfiguration(aCAPhaseSwitchingConfiguration);
        } else if (abstractCorrelatorConfiguration instanceof ACASpectrometerCorrelatorConfiguration) {
            ACASpectrometerCorrelatorConfiguration aCASpectrometerCorrelatorConfiguration = (ACASpectrometerCorrelatorConfiguration)((Object)abstractCorrelatorConfiguration);
            ACAPhaseSwitchingConfiguration aCAPhaseSwitchingConfiguration = ACAPhaseSwitchingConfiguration.createACAPhaseSwitchingConfiguration();
            aCAPhaseSwitchingConfiguration.setDoD180demodulation(false);
            aCAPhaseSwitchingConfiguration.setDoD180modulation(false);
            aCASpectrometerCorrelatorConfiguration.setACAPhaseSwitchingConfiguration(aCAPhaseSwitchingConfiguration);
        }
        this.setDataProduct(spectralSpec, AbstractBaseBandConfig.DATAPRODUCTS_AUTO_ONLY);
        if (ObsType.SCIENCE.equals((Object)obsType)) {
            this.configureTPScienceSBScienceSpectralSpec(spectralSpec, obsType, spectralSetupParameters, abstractCorrelatorConfiguration);
        } else if (ObsType.AMPLITUDE.equals((Object)obsType)) {
            abstractCorrelatorConfiguration.setIntegrationDuration(Time.createTime((double)144.0, (String)Time.UNIT_MS));
            abstractCorrelatorConfiguration.setChannelAverageDuration(Time.createTime((double)144.0, (String)Time.UNIT_MS));
        }
    }

    private void configureTPScienceSBScienceSpectralSpec(SpectralSpec spectralSpec, ObsType obsType, SpectralSetupParameters spectralSetupParameters, AbstractCorrelatorConfiguration abstractCorrelatorConfiguration) {
        Frequency frequency;
        try {
            frequency = spectralSpec.getFilteredSpectralWindow(SpectralSpec.FilteringCriteria.HIGHESTFREQUENCY);
        }
        catch (SpectralSpec.IncompleteCorrelatorSetupFoundException incompleteCorrelatorSetupFoundException) {
            throw new WizardSBGenerationException(incompleteCorrelatorSetupFoundException);
        }
        TargetParameters targetParameters = spectralSetupParameters.getScienceGoal().getTargetParameters()[0];
        assert (targetParameters != null);
        Rectangle rectangle = null;
        if (targetParameters.isRectanglePattern()) {
            rectangle = targetParameters.getSingleRectangle().getTPArrayRectangle(spectralSpec);
        } else if (targetParameters.isPointingPattern()) {
            rectangle = this.getRectangleFromPointingPattern(spectralSpec, targetParameters);
        } else {
            throw new RuntimeException("Unknown pattern detected ");
        }
        ValueUnitPair<Angle> valueUnitPair = TotalPowerSpectralSpecFactory.getL(rectangle, spectralSpec, obsType);
        Integer n = spectralSpec.getReceiverBand().getNumber();
        double d = CorrelatorExpert.TPCorrelatorConfiguratorHelper.calcIntegrationDurationInSecs(valueUnitPair, n, frequency, obsType);
        double d2 = CorrelatorExpert.TPCorrelatorConfiguratorHelper.calculateChannelAverageDurationInMsecs(valueUnitPair, n, frequency, obsType);
        abstractCorrelatorConfiguration.setIntegrationDuration(Time.createTime((double)d, (String)Time.UNIT_S));
        abstractCorrelatorConfiguration.setChannelAverageDuration(Time.createTime((double)d2, (String)Time.UNIT_MS));
    }

    void configureTPSpectralSpec(SpectralSpec spectralSpec, ObsType obsType, SpectralSetupParameters spectralSetupParameters, Optional<TargetWithIntent> optional) {
        ScienceGoal scienceGoal = null;
        if (spectralSetupParameters.getParent() instanceof ScienceGoal) {
            scienceGoal = (ScienceGoal)spectralSetupParameters.getParent();
        }
        if (scienceGoal == null) {
            throw new WizardSBGenerationException("Science goal is null when configuring the TP spectral spec");
        }
        AbstractCorrelatorConfiguration abstractCorrelatorConfiguration = spectralSpec.getAbstractCorrelatorConfiguration();
        switch (obsType) {
            case FOCUS: 
            case DELAY: {
                this.configureTPDelayAndFocusSpectralSpec(spectralSpec, abstractCorrelatorConfiguration);
                break;
            }
            case AMPLITUDE: 
            case SCIENCE: {
                this.configureTPScienceAndAmplitudeSpectralSpecs(spectralSpec, abstractCorrelatorConfiguration, obsType, spectralSetupParameters);
                break;
            }
            default: {
                return;
            }
        }
    }

    public static ValueUnitPair<Angle> getL(Rectangle rectangle, @NonNull SpectralSpec spectralSpec, @NonNull ObsType obsType) {
        Frequency frequency;
        if (spectralSpec == null) {
            throw new NullPointerException("ss is marked non-null but is null");
        }
        if (obsType == null) {
            throw new NullPointerException("obsType is marked non-null but is null");
        }
        UserAngle userAngle = null;
        try {
            frequency = spectralSpec.getFilteredSpectralWindow(SpectralSpec.FilteringCriteria.LOWESTFREQUENCY);
        }
        catch (SpectralSpec.IncompleteCorrelatorSetupFoundException incompleteCorrelatorSetupFoundException) {
            throw new WizardSBGenerationException(incompleteCorrelatorSetupFoundException);
        }
        assert (frequency != null);
        if (ObsType.AMPLITUDE.equals((Object)obsType)) {
            UserAngle userAngle2 = UserAngle.createUserAngle(6.0, UserAngle.USERUNIT_FRACTION_OF_MAIN_BEAM, frequency);
            userAngle2.setAntenna(Antenna.ANTENNA_12M);
            userAngle = userAngle2;
        } else if (ObsType.SCIENCE.equals((Object)obsType)) {
            if (rectangle == null) {
                throw new NullPointerException("Illegal argument. The argument cannot be null: rectangle");
            }
            userAngle = rectangle.getLongitudeLength().isGreaterThan(rectangle.getLatitudeLength()) ? rectangle.getLongitudeLength() : rectangle.getLatitudeLength();
        } else {
            throw new IllegalArgumentException("Cannot calculate L for this type of obstype " + String.valueOf((Object)obsType));
        }
        assert (userAngle != null);
        return userAngle;
    }

    private void setDataProduct(SpectralSpec spectralSpec, String string) {
        for (int i = 0; i < spectralSpec.getBaseBandConfigCount(); ++i) {
            AbstractBaseBandConfig abstractBaseBandConfig = spectralSpec.getBaseBandConfig(i);
            abstractBaseBandConfig.setDataProducts(string);
        }
    }

    private Rectangle getRectangleFromPointingPattern(@NonNull SpectralSpec spectralSpec, @NonNull TargetParameters targetParameters) {
        if (spectralSpec == null) {
            throw new NullPointerException("ss is marked non-null but is null");
        }
        if (targetParameters == null) {
            throw new NullPointerException("targetParameters is marked non-null but is null");
        }
        if (!targetParameters.isMosaic() && targetParameters.getPointingPattern().getPhaseCenterCoordinates().length > 1) {
            String string = "Multiple pointings that require Total Power must go into separate Field Sources (" + targetParameters.getSourceName() + ") if not mosaic";
            Log.logger(SpectralSpecFactory.class).warning(string);
            throw new WizardSBGenerationException(string);
        }
        if (targetParameters.getPointingPattern().getPhaseCenterCoordinates().length < 1) {
            Log.logger(SpectralSpecFactory.class).warning("At least one pointing should be specified - " + targetParameters.getSourceName());
            throw new WizardSBGenerationException("At least one pointing should be specified - " + targetParameters.getSourceName());
        }
        boolean bl = false;
        try {
            bl = SchedBlockWorker.isMosaicPointingsOverlapping(targetParameters);
        }
        catch (SchedBlockWorker.InfiniteBandwithException infiniteBandwithException) {
            String string = "The bandwidth cannot be calculated - unable to do mosaic spacing checks for target " + targetParameters.getSourceName();
            Log.logger(SpectralSpecFactory.class).warning(string);
            throw new WizardSBGenerationException(string);
        }
        catch (SchedBlockWorker.NotAMosaicException notAMosaicException) {
            throw new RuntimeException("Logic error in determining if target parameters " + targetParameters.getSourceName() + " is a mosaic");
        }
        if (!bl) {
            throw new WizardSBGenerationException("Pointings in mosaic for target " + targetParameters.getSourceName() + " do not overlap");
        }
        Rectangle rectangle = null;
        try {
            rectangle = MinBoundingBoxExpert.getBoundingRectangle(targetParameters).getTPArrayRectangle(spectralSpec);
            Log.logger(SpectralSpecFactory.class).fine("TP bounding rectangle dimensions (arcsec) are : " + rectangle.getLongitudeLength().getContentInUnits(Angle.UNIT_ARCSEC) + " " + rectangle.getLatitudeLength().getContentInUnits(Angle.UNIT_ARCSEC));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Log.logger(SpectralSpecFactory.class).warning("Unable to determine minimum bounding box around pointings: " + illegalArgumentException.getMessage());
            throw new WizardSBGenerationException(illegalArgumentException);
        }
        return rectangle;
    }
}

