/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.acs.maci;

import java.util.StringTokenizer;

public class ComponentSpec {
    public static final String COMPSPEC_ANY = "*";
    private String name;
    private String type;
    private String code;
    private String container;

    public ComponentSpec(String name, String type, String code, String container) {
        this.name = name;
        this.type = type;
        this.code = code;
        this.container = container;
    }

    public ComponentSpec(String componentSpec) throws IllegalArgumentException {
        this.parseComponentSpec(componentSpec);
    }

    private void parseComponentSpec(String componentSpec) throws IllegalArgumentException {
        if (componentSpec == null) {
            throw new IllegalArgumentException("Non-'null' string expected.");
        }
        StringTokenizer tokenizer = new StringTokenizer(componentSpec, "|");
        String ERROR_STRING = " element expected.";
        if (!tokenizer.hasMoreTokens()) {
            throw new IllegalArgumentException("'name' element expected.");
        }
        this.name = tokenizer.nextToken();
        if (!tokenizer.hasMoreTokens()) {
            throw new IllegalArgumentException("'type' element expected.");
        }
        this.type = tokenizer.nextToken();
        if (!tokenizer.hasMoreTokens()) {
            throw new IllegalArgumentException("'code' element expected.");
        }
        this.code = tokenizer.nextToken();
        if (!tokenizer.hasMoreTokens()) {
            throw new IllegalArgumentException("'containerName' element expected.");
        }
        this.container = tokenizer.nextToken();
    }

    public String getContainer() {
        return this.container;
    }

    public String getCode() {
        return this.code;
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public void setContainer(String container) {
        this.container = container;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        StringBuffer sbuff = new StringBuffer();
        sbuff.append("ComponentSpec = { ");
        sbuff.append("name = '");
        sbuff.append(this.name);
        sbuff.append("', type = '");
        sbuff.append(this.type);
        sbuff.append("', code = '");
        sbuff.append(this.code);
        sbuff.append("', container = '");
        sbuff.append(this.container);
        sbuff.append("' }");
        return new String(sbuff);
    }
}

