/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.formats;

import java.io.IOException;
import java.io.OutputStream;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableWriter;
import uk.ac.starlink.table.StreamStarTableWriter;
import uk.ac.starlink.table.Tables;

public class HTMLTableWriter
extends StreamStarTableWriter {
    private boolean standalone;

    public HTMLTableWriter() {
        this(true);
    }

    public HTMLTableWriter(boolean standalone) {
        this.setStandalone(standalone);
    }

    public void setStandalone(boolean standalone) {
        this.standalone = standalone;
    }

    public boolean isStandalone() {
        return this.standalone;
    }

    public String getFormatName() {
        return this.standalone ? "HTML" : "HTML-element";
    }

    public String getMimeType() {
        return "text/html";
    }

    public boolean looksLikeFile(String location) {
        return location.endsWith(".html") || location.endsWith(".htm");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeStarTable(StarTable table, OutputStream ostrm) throws IOException {
        RowSequence rseq = table.getRowSequence();
        try {
            String unit;
            if (this.standalone) {
                this.printHeader(ostrm, table);
            }
            this.printLine(ostrm, "<TABLE BORDER='1'>");
            String tname = table.getName();
            if (tname != null) {
                this.printLine(ostrm, "<CAPTION><STRONG>" + tname + "</STRONG></CAPTION>");
            }
            int ncol = table.getColumnCount();
            ColumnInfo[] colinfos = Tables.getColumnInfos(table);
            String[] names = new String[ncol];
            String[] units = new String[ncol];
            boolean hasUnits = false;
            for (int icol = 0; icol < ncol; ++icol) {
                ColumnInfo colinfo = colinfos[icol];
                String name = colinfo.getName();
                unit = colinfo.getUnitString();
                if (unit != null) {
                    hasUnits = true;
                    unit = "(" + unit + ")";
                }
                names[icol] = name;
                units[icol] = unit;
            }
            String[] headings = new String[ncol];
            for (int icol = 0; icol < ncol; ++icol) {
                String heading = names[icol];
                unit = units[icol];
                if (hasUnits) {
                    heading = heading + "<br>";
                    if (unit != null) {
                        heading = heading + "(" + unit + ")";
                    }
                }
                headings[icol] = heading;
            }
            this.outputRow(ostrm, "TH", null, names);
            if (hasUnits) {
                this.outputRow(ostrm, "TH", null, units);
            }
            this.printLine(ostrm, "<TR><TD colspan='" + ncol + "'></TD></TR>");
            while (rseq.next()) {
                Object[] row = rseq.getRow();
                String[] cells = new String[ncol];
                for (int icol = 0; icol < ncol; ++icol) {
                    cells[icol] = this.escape(colinfos[icol].formatValue(row[icol], 200));
                    if (cells[icol].length() != 0) continue;
                    cells[icol] = "&nbsp;";
                }
                this.outputRow(ostrm, "TD", null, cells);
            }
            this.printLine(ostrm, "</TABLE>");
            if (this.standalone) {
                this.printFooter(ostrm);
            }
        }
        finally {
            rseq.close();
        }
    }

    public static StarTableWriter[] getStarTableWriters() {
        return new StarTableWriter[]{new HTMLTableWriter(true), new HTMLTableWriter(false)};
    }

    private void outputRow(OutputStream ostrm, String tagname, String attlist, String[] values) throws IOException {
        int ncol = values.length;
        this.printLine(ostrm, "<TR>");
        StringBuffer sbuf = new StringBuffer();
        for (int icol = 0; icol < ncol; ++icol) {
            sbuf.append(' ').append('<').append(tagname);
            if (attlist != null) {
                sbuf.append(" " + attlist);
            }
            sbuf.append('>');
            if (values[icol] != null) {
                sbuf.append(values[icol]);
            }
            sbuf.append("</").append(tagname).append(">");
        }
        this.printLine(ostrm, sbuf.toString());
        this.printLine(ostrm, "</TR>");
    }

    private void printLine(OutputStream ostrm, String str) throws IOException {
        ostrm.write(str.getBytes());
        ostrm.write(10);
    }

    protected void printHeader(OutputStream ostrm, StarTable table) throws IOException {
        this.printLine(ostrm, "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2//EN\">");
        this.printLine(ostrm, "<html>");
        String tname = table.getName();
        if (tname != null) {
            this.printLine(ostrm, "<head><title>Table " + this.escape(tname) + "</title></head>");
        }
        this.printLine(ostrm, "<body>");
    }

    protected void printFooter(OutputStream ostrm) throws IOException {
        this.printLine(ostrm, "</body>");
        this.printLine(ostrm, "</html>");
    }

    private String escape(String line) {
        StringBuffer sbuf = new StringBuffer();
        block7: for (int i = 0; i < line.length(); ++i) {
            char chr = line.charAt(i);
            switch (chr) {
                case '&': {
                    sbuf.append("&amp;");
                    continue block7;
                }
                case '<': {
                    sbuf.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sbuf.append("&gt;");
                    continue block7;
                }
                case '\"': {
                    sbuf.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    sbuf.append("&apos;");
                    continue block7;
                }
                default: {
                    sbuf.append(chr > '\u0000' && chr < '\u00fe' ? chr : (char)'?');
                }
            }
        }
        return sbuf.toString();
    }
}

