/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.monitoring;

import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

public class GCJMXClient {
    private static final String LOCAL_CONNECTOR_ADDRESS = "com.sun.management.jmxremote.localConnectorAddress";
    private VirtualMachine _vm;
    private MBeanServerConnection _remote;

    public GCJMXClient(String className) {
        int pid = 0;
        try {
            pid = this.getPID(className);
        }
        catch (IOException e) {
            System.err.println("Error while getting remote PID!: " + e.getMessage());
            System.exit(1);
        }
        if (pid == 0) {
            System.err.println("Couldn't find process for class " + className);
            System.exit(1);
        } else {
            try {
                this._vm = this.getVM(pid);
            }
            catch (IOException e) {
                System.err.println("Can't connect to remote VM: " + e.getMessage());
                System.exit(1);
            }
            catch (AttachNotSupportedException e) {
                System.err.println("Can't attach to the remote JVM: " + e.getMessage());
                System.exit(1);
            }
        }
    }

    public void connect() throws Exception {
        String connectorAddress = this._vm.getAgentProperties().getProperty(LOCAL_CONNECTOR_ADDRESS);
        if (connectorAddress == null) {
            String agent = this._vm.getSystemProperties().getProperty("java.home") + File.separator + "lib" + File.separator + "management-agent.jar";
            this._vm.loadAgent(agent);
            connectorAddress = this._vm.getAgentProperties().getProperty(LOCAL_CONNECTOR_ADDRESS);
            if (connectorAddress == null) {
                System.err.println("Cannot connect :(");
                System.exit(1);
            }
        }
        JMXServiceURL remoteURL = new JMXServiceURL(connectorAddress);
        JMXConnector connector = null;
        try {
            connector = JMXConnectorFactory.connect(remoteURL);
        }
        catch (IOException e) {
            System.err.println("Can't connect to the remote URL");
            System.exit(-1);
        }
        try {
            this._remote = connector.getMBeanServerConnection();
        }
        catch (IOException e) {
            System.err.println("Can't get a connection to the remote MBeanServer");
            System.exit(-1);
        }
    }

    public MBeanServerConnection getRemote() {
        return this._remote;
    }

    private VirtualMachine getVM(int pid) throws AttachNotSupportedException, IOException {
        if (this._vm == null) {
            VirtualMachine vm;
            this._vm = vm = VirtualMachine.attach(String.valueOf(pid));
        }
        return this._vm;
    }

    private int getPID(String className) throws IOException {
        String s;
        Integer remotePID = null;
        Process p = Runtime.getRuntime().exec("jps -lm");
        BufferedReader stdInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
        while ((s = stdInput.readLine()) != null) {
            String[] ss = s.split("[\t ]+");
            if (ss.length <= 1 || !ss[1].equals(className)) continue;
            remotePID = Integer.valueOf(ss[0]);
            break;
        }
        stdInput.close();
        if (remotePID == null) {
            return 0;
        }
        return remotePID;
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.err.println("Must provide 2 arguments: <classname> <interval-in-ms>");
        }
        final GCJMXClient client = new GCJMXClient(args[0]);
        try {
            client.connect();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
        ObjectName objName = null;
        try {
            objName = new ObjectName("java.lang:type=Memory");
        }
        catch (MalformedObjectNameException e1) {
            System.err.println("bad name?");
            System.exit(1);
        }
        final ObjectName objNameF = objName;
        Timer timer = new Timer();
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                MBeanServerConnection con = client.getRemote();
                try {
                    con.invoke(objNameF, "gc", null, null);
                    System.out.println("Called gc() on remote VM");
                }
                catch (Exception e) {
                    System.err.println("Couldn't call gc() on remote VM");
                }
            }
        };
        timer.scheduleAtFixedRate(task, new Date(), (long)Integer.parseInt(args[1]));
    }
}

