/*
 * Decompiled with CFR 0.152.
 */
package diva.util.java2d;

import diva.util.java2d.AbstractPaintedGraphic;
import diva.util.java2d.ShapeUtilities;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;

public class PaintedPath
extends AbstractPaintedGraphic {
    public PaintedPath(Shape s) {
        this(s, 1.0f);
    }

    public PaintedPath(Shape s, float lineWidth) {
        this(s, 1.0f, Color.black);
    }

    public PaintedPath(Shape s, float lineWidth, Paint paint) {
        this.shape = s;
        this.stroke = PaintedPath.getStroke(lineWidth);
        this.strokePaint = paint;
    }

    public float[] getDashArray() {
        if (this.stroke instanceof BasicStroke) {
            return ((BasicStroke)this.stroke).getDashArray();
        }
        return null;
    }

    public float getLineWidth() {
        if (this.stroke instanceof BasicStroke) {
            return ((BasicStroke)this.stroke).getLineWidth();
        }
        return 1.0f;
    }

    public boolean hit(Rectangle2D r) {
        return this.intersects(r);
    }

    public boolean intersects(Rectangle2D r) {
        return ShapeUtilities.intersectsOutline(r, this.shape);
    }

    public void paint(Graphics2D g) {
        g.setStroke(this.stroke);
        g.setPaint(this.strokePaint);
        g.draw(this.shape);
    }

    public void setDashArray(float[] dashArray) {
        this.stroke = this.stroke instanceof BasicStroke ? new BasicStroke(((BasicStroke)this.stroke).getLineWidth(), ((BasicStroke)this.stroke).getEndCap(), ((BasicStroke)this.stroke).getLineJoin(), ((BasicStroke)this.stroke).getMiterLimit(), dashArray, 0.0f) : new BasicStroke(1.0f, 2, 0, 10.0f, dashArray, 0.0f);
    }

    public void setLineWidth(float lineWidth) {
        if (this.stroke instanceof BasicStroke) {
            this.stroke = new BasicStroke(lineWidth, ((BasicStroke)this.stroke).getEndCap(), ((BasicStroke)this.stroke).getLineJoin(), ((BasicStroke)this.stroke).getMiterLimit(), ((BasicStroke)this.stroke).getDashArray(), 0.0f);
        } else {
            new BasicStroke(lineWidth, 2, 0, 10.0f, null, 0.0f);
        }
    }

    public void setStroke(Stroke s) {
        this.stroke = s;
    }
}

