/*
 * Decompiled with CFR 0.152.
 */
package jsky.app.jskycat;

import com.jgoodies.looks.plastic.Plastic3DLookAndFeel;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.media.jai.JAI;
import javax.media.jai.TileCache;
import javax.swing.JFileChooser;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.ColorUIResource;
import jsky.app.jskycat.JSkyCatRemoteControl;
import jsky.image.gui.MainImageDisplay;
import jsky.interop.JSkyServer;
import jsky.interop.PlasticHelper;
import jsky.interop.SampHelper;
import jsky.navigator.NavigatorFrame;
import jsky.navigator.NavigatorImageDisplay;
import jsky.navigator.NavigatorImageDisplayFrame;
import jsky.util.I18N;
import jsky.util.gui.DialogUtil;
import jsky.util.gui.ExampleFileFilter;
import jsky.util.gui.SwingUtil;
import org.astrogrid.samp.Metadata;

public class JSkyCat {
    private static final I18N _I18N = I18N.getInstance(JSkyCat.class);
    protected NavigatorImageDisplayFrame _imageFrame;

    public JSkyCat(String imageFileOrUrl, boolean showNavigator, boolean useSamp, boolean usePlastic, int portNum) {
        this.makeFrameLayout(showNavigator, imageFileOrUrl);
        if (useSamp || usePlastic) {
            Metadata meta = this.createApplicationMetadata();
            if (useSamp) {
                this.initSamp(meta);
            }
            if (usePlastic) {
                this.initPlastic(meta);
            }
        }
        if (portNum > 0) {
            try {
                new JSkyCatRemoteControl(portNum, this).start();
            }
            catch (IOException e) {
                DialogUtil.error(e);
            }
        }
    }

    protected Metadata createApplicationMetadata() {
        Metadata meta = new Metadata();
        meta.setName("JSkyCat");
        meta.setDescriptionText("JSkyCat - Astronomical Image and Catalog Browser");
        meta.put("author.name", "Allan Brighton");
        meta.put("author.mail", "Allan.Brighton@t-online.de");
        String defUrl = "http://java.sun.com/developer/techDocs/hi/repository/graphicsRepository/toolbarButtonGraphics/development/WebComponent24.gif";
        try {
            JSkyServer server = JSkyServer.getInstance();
            URL packageUrl = server.getJSkyPackageUrl();
            URL logoUrl = new URL(packageUrl, "images/ImageDisplay24.gif");
            meta.setIconUrl(server.isFound(logoUrl) ? logoUrl.toString() : defUrl);
        }
        catch (IOException e) {
            e.printStackTrace();
            meta.setIconUrl(defUrl);
        }
        return meta;
    }

    public JSkyCat(String imageFileOrUrl, boolean showNavigator) {
        this(imageFileOrUrl, showNavigator, true, false, 0);
    }

    public JSkyCat(String imageFileOrUrl) {
        this(imageFileOrUrl, false, true, false, 0);
    }

    protected void makeFrameLayout(boolean showNavigator, String imageFileOrUrl) {
        this._imageFrame = this.makeNavigatorImageDisplayFrame(imageFileOrUrl);
        if (showNavigator) {
            NavigatorImageDisplay imageDisplay = (NavigatorImageDisplay)this._imageFrame.getImageDisplayControl().getImageDisplay();
            imageDisplay.openCatalogWindow();
        }
    }

    protected String getAppName() {
        return "JSkyCat";
    }

    protected String getAppVersion() {
        return "jsky-3.0".substring(5);
    }

    protected NavigatorImageDisplayFrame makeNavigatorImageDisplayFrame(String imageFileOrUrl) {
        NavigatorImageDisplayFrame f = new NavigatorImageDisplayFrame(imageFileOrUrl);
        f.getImageDisplayControl().getImageDisplay().setTitle(this.getAppName() + " - version " + this.getAppVersion());
        f.setVisible(true);
        return f;
    }

    protected NavigatorFrame makeNavigatorFrame(MainImageDisplay imageDisplay) {
        return new NavigatorFrame(imageDisplay);
    }

    public JFileChooser makeFileChooser() {
        JFileChooser fileChooser = new JFileChooser(new File("."));
        ExampleFileFilter configFileFilter = new ExampleFileFilter(new String[]{"cfg"}, _I18N.getString("catalogConfigFilesSkycat"));
        fileChooser.addChoosableFileFilter(configFileFilter);
        ExampleFileFilter skycatLocalCatalogFilter = new ExampleFileFilter(new String[]{"table", "tbl", "cat"}, _I18N.getString("localCatalogFilesSkycat"));
        fileChooser.addChoosableFileFilter(skycatLocalCatalogFilter);
        ExampleFileFilter fitsFilter = new ExampleFileFilter(new String[]{"fit", "fits", "fts"}, _I18N.getString("fitsFileWithTableExt"));
        fileChooser.addChoosableFileFilter(fitsFilter);
        fileChooser.setFileFilter(fitsFilter);
        return fileChooser;
    }

    public void exit() {
        System.exit(0);
    }

    protected MainImageDisplay getImageDisplay() {
        return this._imageFrame.getImageDisplayControl().getImageDisplay();
    }

    public void setImageFrameVisible(boolean visible) {
        if (this._imageFrame != null) {
            this._imageFrame.setVisible(visible);
            if (visible) {
                SwingUtil.showFrame(this._imageFrame);
            }
        }
    }

    protected void initSamp(Metadata meta) {
        SampHelper.init(meta, this._imageFrame);
    }

    protected void initPlastic(Metadata meta) {
        PlasticHelper.init(meta, this._imageFrame);
    }

    public String toString() {
        return "JSkyCat";
    }

    protected static void _usage() {
        System.out.println("Usage: jskycat [-plastic] [-noplastic] [-samp] [-nosamp] [-setlookandfeel] [-nosetlookandfeel] [-shownavigator] [imageFileOrUrl]\n\nIf -plastic is specified, the PLASTIC package for interprocess communication is used\ninstead of the default SAMP (use -plastic -samp to use both at once).\n\nIf -setlookandfeel is given, a custom (JGoodies Plastic3D) look and feel is set (default, except on Mac OS X).\n\nIf -shownavigator is specified, the catalog navigator window is displayed on startup.\n\nThe imageFileOrUrl argument may be an image file or URL to load.");
    }

    public static void main(String[] args) {
        String imageFileOrUrl = null;
        boolean showNavigator = false;
        Boolean useSamp = null;
        Boolean usePlastic = null;
        int portNum = 0;
        boolean ok = true;
        int tilecache = 64;
        boolean setLookAndFeel = !"Mac OS X".equals(UIManager.getLookAndFeel().getName());
        for (int i = 0; i < args.length; ++i) {
            if (args[i].charAt(0) == '-') {
                String opt = args[i];
                if (opt.equals("-help")) {
                    JSkyCat._usage();
                    System.exit(0);
                    continue;
                }
                if (opt.equals("-setlookandfeel")) {
                    setLookAndFeel = true;
                    continue;
                }
                if (opt.equals("-nosetlookandfeel")) {
                    setLookAndFeel = false;
                    continue;
                }
                if (opt.equals("-shownavigator")) {
                    showNavigator = true;
                    continue;
                }
                if (opt.equals("-plastic")) {
                    usePlastic = true;
                    continue;
                }
                if (opt.equals("-noplastic")) {
                    usePlastic = false;
                    continue;
                }
                if (opt.equals("-samp")) {
                    useSamp = true;
                    continue;
                }
                if (opt.equals("-nosamp")) {
                    useSamp = false;
                    continue;
                }
                if (opt.equals("-port")) {
                    String arg = args[++i];
                    portNum = Integer.parseInt(arg);
                    continue;
                }
                if (opt.equals("-tilecache")) {
                    try {
                        tilecache = Integer.parseInt(args[++i]);
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Warning: bad value for -tilecache option: " + args[i]);
                    }
                    continue;
                }
                System.out.println(_I18N.getString("unknownOption") + ": " + opt);
                ok = false;
                break;
            }
            if (imageFileOrUrl != null) {
                System.out.println(_I18N.getString("specifyOneImageOrURL") + ": " + imageFileOrUrl);
                ok = false;
                break;
            }
            imageFileOrUrl = args[i];
        }
        if (useSamp == null && usePlastic == null) {
            useSamp = true;
            usePlastic = false;
        } else if (useSamp == null) {
            useSamp = false;
        } else if (usePlastic == null) {
            usePlastic = false;
        }
        if (!ok) {
            JSkyCat._usage();
            System.exit(1);
        }
        JSkyCat._startJSkyCat(imageFileOrUrl, tilecache, setLookAndFeel, showNavigator, useSamp, usePlastic, portNum);
    }

    private static void _startJSkyCat(final String imageFileOrUrl, int tilecache, boolean setLookAndFeel, final boolean showNavigator, final boolean useSamp, final boolean usePlastic, final int portNum) {
        TileCache cache = JAI.getDefaultInstance().getTileCache();
        cache.setMemoryCapacity(tilecache * 1024 * 1024);
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        if (setLookAndFeel) {
            try {
                UIManager.setLookAndFeel((LookAndFeel)new Plastic3DLookAndFeel());
            }
            catch (UnsupportedLookAndFeelException e) {
                DialogUtil.error(e);
            }
        }
        UIManager.put("ToolTip.background", new ColorUIResource(245, 245, 220));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                new JSkyCat(imageFileOrUrl, showNavigator, useSamp, usePlastic, portNum);
            }
        });
    }
}

