/*
 * Decompiled with CFR 0.152.
 */
package jsky.util.gui;

import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class NumberEntry
extends JTextField {
    public NumberEntry(int cols) {
        super(cols);
    }

    @Override
    protected Document createDefaultModel() {
        return new NumericDocument();
    }

    static class NumericDocument
    extends PlainDocument {
        NumericDocument() {
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (str == null) {
                return;
            }
            if (offs != 0 && str.equals(".")) {
                super.insertString(offs, str, a);
                return;
            }
            try {
                double value = Double.parseDouble(str);
                super.insertString(offs, str, a);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

