/*
 * Decompiled with CFR 0.152.
 */
package diva.canvas.connector;

import diva.canvas.connector.ConnectorEnd;
import diva.util.java2d.Polygon2D;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class Arrowhead
implements ConnectorEnd {
    private boolean _filled = true;
    private double _length = 12.0;
    private double _originX = 0.0;
    private double _originY = 0.0;
    private double _normal = 0.0;
    private Polygon2D _polygon = null;
    private boolean _polygonValid = false;
    private boolean _flipped = false;
    private Stroke _stroke = new BasicStroke(3.0f);

    public Arrowhead() {
        this(0.0, 0.0, 0.0);
    }

    public Arrowhead(double x, double y, double normal) {
        this._originX = x;
        this._originY = y;
        this._normal = normal;
        this.reshape();
    }

    public Rectangle2D getBounds() {
        if (this._filled) {
            return this._polygon.getBounds2D();
        }
        Shape s = this._stroke.createStrokedShape(this._polygon);
        return s.getBounds2D();
    }

    public void getConnection(Point2D p) {
        if (!this._polygonValid) {
            this.reshape();
        }
        p.setLocation(this._originX + this._length, this._originY);
        AffineTransform at = new AffineTransform();
        at.setToRotation(this._normal, this._originX, this._originY);
        at.transform(p, p);
    }

    public boolean getFlipped() {
        return this._flipped;
    }

    public void getOrigin(Point2D p) {
        p.setLocation(this._originX, this._originY);
    }

    public double getLength() {
        return this._length;
    }

    public boolean isFilled() {
        return this._filled;
    }

    public void paint(Graphics2D g) {
        if (!this._polygonValid) {
            this.reshape();
        }
        if (this._filled) {
            Paint oldPaint = g.getPaint();
            g.fill(this._polygon);
            g.setPaint(oldPaint);
        } else {
            g.draw(this._polygon);
        }
    }

    public void reshape() {
        AffineTransform at = new AffineTransform();
        at.setToRotation(this._normal, this._originX, this._originY);
        double l1 = this._length * 1.0;
        double l2 = this._length * 1.3;
        double w = this._length * 0.4;
        if (this._flipped) {
            l1 = -l1;
            l2 = -l2;
            at.translate(this._length, 0.0);
        }
        this._polygon = new Polygon2D.Double();
        this._polygon.moveTo(this._originX, this._originY);
        this._polygon.lineTo(this._originX + l2, this._originY + w);
        this._polygon.lineTo(this._originX + l1, this._originY);
        this._polygon.lineTo(this._originX + l2, this._originY - w);
        this._polygon.closePath();
        this._polygon.transform(at);
    }

    public void setNormal(double angle) {
        this._normal = angle;
        this._polygonValid = false;
    }

    public void setFilled(boolean flag) {
        this._filled = flag;
    }

    public void setFlipped(boolean flag) {
        this._flipped = flag;
        this._polygonValid = false;
    }

    public void setOrigin(double x, double y) {
        this.translate(x - this._originX, y - this._originY);
    }

    public void setLength(double l) {
        this._length = l;
        this._polygonValid = false;
    }

    public void translate(double x, double y) {
        this._originX += x;
        this._originY += y;
        if (this._polygonValid) {
            this._polygon.translate(x, y);
        }
    }
}

