/*
 * Decompiled with CFR 0.152.
 */
package diva.canvas.connector;

import diva.canvas.CanvasComponent;
import diva.canvas.CanvasPane;
import diva.canvas.Figure;
import diva.canvas.FigureContainer;
import diva.canvas.Site;
import diva.canvas.TransformContext;
import diva.canvas.connector.AutonomousSite;
import diva.canvas.connector.Connector;
import diva.canvas.connector.ConnectorEvent;
import diva.canvas.connector.ConnectorListener;
import diva.canvas.connector.ConnectorManipulator;
import diva.canvas.event.LayerEvent;
import diva.canvas.interactor.DragInteractor;
import diva.canvas.interactor.GrabHandle;
import diva.canvas.interactor.Manipulator;
import diva.util.Filter;
import diva.util.java2d.ShapeUtilities;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

public class ConnectorInteractor
extends DragInteractor {
    private Connector _connector = null;
    private GrabHandle _handle = null;
    private ConnectorManipulator _manipulator;
    private Figure _target = null;
    private ArrayList _connectorListeners = new ArrayList();

    public ConnectorInteractor(ConnectorManipulator m) {
        this._manipulator = m;
    }

    public void addConnectorListener(ConnectorListener l) {
        this._connectorListeners.add(l);
    }

    private void attach(Site site) {
        if (this._handle.getSite() == this._connector.getHeadSite()) {
            this._connector.setHeadSite(site);
        } else {
            this._connector.setTailSite(site);
        }
        this._handle.setSite(site);
        this._handle.repaint();
    }

    private void detach(double x, double y) {
        AutonomousSite newSite = new AutonomousSite(this._connector.getTransformContext(), x, y);
        if (this._handle.getSite() == this._connector.getHeadSite()) {
            this._connector.setHeadSite(newSite);
        } else {
            this._connector.setTailSite(newSite);
        }
        this._handle.setSite(newSite);
        this._handle.repaint();
    }

    private Site findSite(Figure f, double x, double y) {
        Site ret = null;
        ret = this._handle.getSite() == this._connector.getHeadSite() ? this._manipulator._connectorTarget.getHeadSite(this._connector, f, x, y) : this._manipulator._connectorTarget.getTailSite(this._connector, f, x, y);
        return ret;
    }

    private Site findSite(Site s, double x, double y) {
        if (this._handle.getSite() == this._connector.getHeadSite()) {
            return this._manipulator._connectorTarget.getHeadSite(this._connector, s, x, y);
        }
        return this._manipulator._connectorTarget.getTailSite(this._connector, s, x, y);
    }

    protected void fireConnectorEvent(int id) {
        int end = this._handle.getSite() == this._connector.getHeadSite() ? 21 : 22;
        ConnectorEvent event = new ConnectorEvent(id, this._connector.getLayer(), this._target, this._connector, end);
        this._notifyConnectorListeners(event, id);
    }

    public Connector getConnector() {
        return this._connector;
    }

    public GrabHandle getHandle() {
        return this._handle;
    }

    public Figure getTarget() {
        return this._target;
    }

    public void mouseReleased(LayerEvent event) {
        super.mouseReleased(event);
        this.fireConnectorEvent(13);
    }

    public void removeConnectorListener(ConnectorListener l) {
        this._connectorListeners.remove(l);
    }

    public void setup(LayerEvent e) {
        this._handle = (GrabHandle)e.getFigureSource();
        this._target = this._handle.getSite().getFigure();
        this._connector = (Connector)((Manipulator)this._handle.getParent()).getChild();
    }

    public void snapToSite(final FigureContainer container, final Rectangle2D hitRect) {
        Site snap;
        Figure figure = container.pick(hitRect, new Filter(){

            public boolean accept(Object o) {
                AffineTransform transform;
                if (!(o instanceof Figure)) {
                    return false;
                }
                if (o instanceof ConnectorManipulator) {
                    return false;
                }
                Figure f = (Figure)o;
                if (f.getInteractor() == null) {
                    return false;
                }
                TransformContext figureContext = f.getParent().getTransformContext();
                TransformContext containerContext = container.getTransformContext();
                try {
                    transform = figureContext.getTransform(containerContext).createInverse();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    return false;
                }
                Rectangle2D bounds = ShapeUtilities.transformBounds(hitRect, transform);
                return ConnectorInteractor.this.findSite(f, bounds.getCenterX(), bounds.getCenterY()) != null;
            }
        });
        if (figure != null && (snap = this.findSite(figure, hitRect.getCenterX(), hitRect.getCenterY())) != null) {
            this._target = figure;
            this.attach(snap);
            this.fireConnectorEvent(14);
        }
    }

    public void translate(LayerEvent e, double dx, double dy) {
        double x = e.getLayerX();
        double y = e.getLayerY();
        double h = this._manipulator.getSnapHalo();
        Rectangle2D.Double mouseRect = new Rectangle2D.Double(x - h, y - h, 2.0 * h, 2.0 * h);
        if (this._target != null) {
            TransformContext manipulatorContext = e.getLayerSource().getTransformContext();
            TransformContext targetContext = this._target.getParent().getTransformContext();
            AffineTransform transform = targetContext.getTransform(manipulatorContext);
            Rectangle2D bounds = this._target.getBounds();
            if ((bounds = ShapeUtilities.transformBounds(bounds, transform)).intersects(x - h, y - h, 2.0 * h, 2.0 * h)) {
                Site current = this._handle.getSite();
                Site snap = this.findSite(current, bounds.getCenterX(), bounds.getCenterY());
                if (snap != null && snap != current) {
                    this.attach(snap);
                    this.fireConnectorEvent(14);
                }
            } else {
                this.detach(x, y);
                this.fireConnectorEvent(15);
                this._target = null;
            }
        } else {
            CanvasComponent component = this._connector.getTransformContext().getComponent();
            FigureContainer container = component instanceof CanvasPane ? (FigureContainer)((Object)this._connector.getLayer()) : (FigureContainer)component;
            this.snapToSite(container, mouseRect);
        }
        if (this._target == null) {
            this._handle.getSite().translate(dx, dy);
            this._connector.reroute();
            this.fireConnectorEvent(12);
        }
    }

    protected void _notifyConnectorListeners(ConnectorEvent event, int id) {
        for (ConnectorListener l : this._connectorListeners) {
            switch (id) {
                case 12: {
                    l.connectorDragged(event);
                    break;
                }
                case 13: {
                    l.connectorDropped(event);
                    break;
                }
                case 14: {
                    l.connectorSnapped(event);
                    break;
                }
                case 15: {
                    l.connectorUnsnapped(event);
                }
            }
        }
    }
}

