/*
 * Decompiled with CFR 0.152.
 */
package diva.canvas.connector;

import diva.canvas.AbstractFigure;
import diva.canvas.AbstractSite;
import diva.canvas.Figure;
import diva.canvas.Site;
import diva.canvas.connector.ConnectorEnd;
import diva.canvas.connector.NullSite;
import diva.canvas.connector.Terminal;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class StraightTerminal
extends AbstractFigure
implements Terminal {
    private ConnectorEnd _end;
    private Site _attachSite;
    private Site _connectSite;
    private double _length = 20.0;
    private Line2D _line;
    private Stroke _stroke;
    private Paint _paint;

    public StraightTerminal() {
        this(new NullSite(), new BasicStroke(), Color.black);
    }

    public StraightTerminal(Site attachSite) {
        this(attachSite, new BasicStroke(), Color.black);
    }

    public StraightTerminal(Site attachSite, Stroke stroke, Paint paint) {
        this._attachSite = attachSite;
        this._paint = paint;
        this._stroke = stroke;
        this._connectSite = new ConnectSite();
        this._line = new Line2D.Double();
        if (!(this._attachSite instanceof NullSite)) {
            this.recompute();
        }
    }

    public Site getAttachSite() {
        return this._attachSite;
    }

    public Rectangle2D getBounds() {
        Rectangle2D bounds = this._stroke.createStrokedShape(this._line).getBounds2D();
        if (this._end != null) {
            Rectangle2D.union(bounds, this._end.getBounds(), bounds);
        }
        return bounds;
    }

    public Site getConnectSite() {
        return this._connectSite;
    }

    public ConnectorEnd getEnd() {
        return this._end;
    }

    public Paint getPaint() {
        return this._paint;
    }

    public Shape getShape() {
        return this._line;
    }

    public Stroke getStroke() {
        return this._stroke;
    }

    public boolean hit(Rectangle2D r) {
        if (!this.isVisible()) {
            return false;
        }
        boolean hit = this.intersects(r);
        if (this._end != null) {
            hit = hit || r.intersects(this._end.getBounds());
        }
        return hit;
    }

    public void paint(Graphics2D g) {
        g.setStroke(this._stroke);
        g.setPaint(this._paint);
        g.draw(this._line);
        if (this._end != null) {
            this._end.paint(g);
        }
    }

    private void recompute() {
        double x1 = this._attachSite.getX();
        double y1 = this._attachSite.getY();
        double normal = this._attachSite.getNormal();
        double x2 = x1 + this._length * Math.cos(normal);
        double y2 = y1 + this._length * Math.sin(normal);
        this._line.setLine(x1, y1, x2, y2);
        if (this._end != null) {
            this._end.setOrigin(x2, y2);
            this._end.setNormal(normal);
        }
    }

    public void relocate() {
        this.translate(this._attachSite.getX() - this._line.getX1(), this._attachSite.getY() - this._line.getY1());
    }

    public void setAttachSite(Site s) {
        this._attachSite = s;
        this.recompute();
        this.repaint();
    }

    public void setEnd(ConnectorEnd e) {
        this.repaint();
        this._end = e;
        this._end.setOrigin(this._connectSite.getX(), this._connectSite.getY());
        this._end.setNormal(this._connectSite.getNormal());
        this.repaint();
    }

    public void setStroke(Stroke s) {
        this.repaint();
        this._stroke = s;
        this.repaint();
    }

    public void setPaint(Paint p) {
        this._paint = p;
        this.repaint();
    }

    public void transform(AffineTransform at) {
    }

    public void translate(double x, double y) {
        this._line.setLine(this._line.getX1() + x, this._line.getY1() + y, this._line.getX2() + x, this._line.getY2() + y);
        if (this._end != null) {
            this._end.translate(x, y);
        }
    }

    private class ConnectSite
    extends AbstractSite {
        private ConnectSite() {
        }

        public int getID() {
            return 0;
        }

        public Figure getFigure() {
            return StraightTerminal.this;
        }

        public double getNormal() {
            return StraightTerminal.this._attachSite.getNormal();
        }

        public double getX() {
            return StraightTerminal.this._line.getX2();
        }

        public double getY() {
            return StraightTerminal.this._line.getY2();
        }

        public boolean hasNormal() {
            return StraightTerminal.this._attachSite.hasNormal();
        }

        public boolean isNormal(int direction) {
            return StraightTerminal.this._attachSite.isNormal(direction);
        }

        public void setPoint(Point2D point) {
            throw new UnsupportedOperationException("Terminal connection points cannot be moved");
        }

        public void translate(double x, double y) {
            throw new UnsupportedOperationException("Terminal connection points cannot be moved");
        }
    }
}

