/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder.factory;

import java.util.Enumeration;
import org.exolab.castor.builder.AnnotationBuilder;
import org.exolab.castor.builder.BuilderConfiguration;
import org.exolab.castor.builder.FactoryState;
import org.exolab.castor.builder.GroupNaming;
import org.exolab.castor.builder.SGTypes;
import org.exolab.castor.builder.SourceGenerator;
import org.exolab.castor.builder.TypeConversion;
import org.exolab.castor.builder.binding.ExtendedBinding;
import org.exolab.castor.builder.binding.XMLBindingComponent;
import org.exolab.castor.builder.binding.xml.EnumBindingType;
import org.exolab.castor.builder.binding.xml.EnumMember;
import org.exolab.castor.builder.factory.BaseFactory;
import org.exolab.castor.builder.types.XSString;
import org.exolab.castor.builder.types.XSType;
import org.exolab.castor.xml.schema.Facet;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.javasource.JAnnotationType;
import org.exolab.javasource.JArrayType;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JConstructor;
import org.exolab.javasource.JDocComment;
import org.exolab.javasource.JEnum;
import org.exolab.javasource.JEnumConstant;
import org.exolab.javasource.JField;
import org.exolab.javasource.JMethod;
import org.exolab.javasource.JModifiers;
import org.exolab.javasource.JParameter;
import org.exolab.javasource.JSourceCode;
import org.exolab.javasource.JType;

public final class EnumerationFactory
extends BaseFactory {
    private TypeConversion _typeConversion = new TypeConversion(this.getConfig());
    private boolean _caseInsensitive = false;
    private int _maxSuffix = 0;
    private int _maxEnumerationsPerClass;

    public EnumerationFactory(BuilderConfiguration config, GroupNaming groupNaming, SourceGenerator sourceGenerator) {
        super(config, null, groupNaming, sourceGenerator);
        this._maxEnumerationsPerClass = config.getMaximumNumberOfConstants();
    }

    void processEnumerationAsNewObject(ExtendedBinding binding, SimpleType simpleType, FactoryState state) {
        this._maxSuffix = 0;
        boolean generateConstantDefinitions = true;
        int numberOfEnumerationFacets = simpleType.getNumberOfFacets("enumeration");
        if (numberOfEnumerationFacets > this._maxEnumerationsPerClass) {
            generateConstantDefinitions = false;
        }
        Enumeration<Facet> enumeration = simpleType.getFacets("enumeration");
        XMLBindingComponent component = new XMLBindingComponent(this.getConfig(), this.getGroupNaming());
        if (binding != null) {
            component.setBinding(binding);
            component.setView(simpleType);
        }
        boolean useValuesAsName = true;
        useValuesAsName = this.selectNamingScheme(component, enumeration, useValuesAsName);
        enumeration = simpleType.getFacets("enumeration");
        JClass jClass = state.getJClass();
        String className = jClass.getLocalName();
        if (component.getJavaClassName() != null) {
            className = component.getJavaClassName();
        }
        if (state.getJClass() instanceof JEnum) {
            this.createJava5Enum(simpleType, state, component, useValuesAsName, enumeration);
            return;
        }
        JField field = null;
        JField fHash = new JField(SGTypes.createHashtable(this.getConfig().useJava50()), "_memberTable");
        fHash.setInitString("init()");
        fHash.getModifiers().setStatic(true);
        JSourceCode jsc = null;
        JConstructor constructor = jClass.getConstructor(0);
        constructor.getModifiers().makePrivate();
        constructor.addParameter(new JParameter(JType.INT, "type"));
        constructor.addParameter(new JParameter(SGTypes.STRING, "value"));
        jsc = constructor.getSourceCode();
        jsc.add("this.type = type;");
        jsc.add("this.stringValue = value;");
        this.createValueOfMethod(jClass, className);
        this.createEnumerateMethod(jClass, className);
        this.createToStringMethod(jClass, className);
        this.createInitMethod(jClass);
        this.createReadResolveMethod(jClass);
        int count = 0;
        while (enumeration.hasMoreElements()) {
            Facet facet = enumeration.nextElement();
            String value = facet.getValue();
            String typeName = null;
            Object objName = null;
            objName = useValuesAsName ? this.translateEnumValueToIdentifier(component.getEnumBinding(), facet) : "VALUE_" + count;
            typeName = (String)objName + "_TYPE";
            boolean addInitializerCode = true;
            if (jClass.getField((String)objName) != null) {
                jClass.removeField((String)objName);
                jClass.removeField(typeName);
                addInitializerCode = false;
            }
            if (generateConstantDefinitions) {
                field = new JField(JType.INT, typeName);
                field.setComment("The " + value + " type");
                JModifiers modifiers = field.getModifiers();
                modifiers.setFinal(true);
                modifiers.setStatic(true);
                modifiers.makePublic();
                field.setInitString(Integer.toString(count));
                jClass.addField(field);
                field = new JField(jClass, (String)objName);
                field.setComment("The instance of the " + value + " type");
                modifiers = field.getModifiers();
                modifiers.setFinal(true);
                modifiers.setStatic(true);
                modifiers.makePublic();
                StringBuilder init = new StringBuilder(32);
                init.append("new ");
                init.append(className);
                init.append("(");
                init.append(typeName);
                init.append(", \"");
                init.append(EnumerationFactory.escapeValue(value));
                init.append("\")");
                field.setInitString(init.toString());
                jClass.addField(field);
            }
            if (addInitializerCode) {
                jsc = this.getSourceCodeForInitMethod(jClass);
                jsc.add("members.put(\"");
                jsc.append(EnumerationFactory.escapeValue(value));
                if (this._caseInsensitive) {
                    jsc.append("\".toLowerCase(), ");
                } else {
                    jsc.append("\", ");
                }
                if (generateConstantDefinitions) {
                    jsc.append((String)objName);
                } else {
                    String init = new StringBuilder(32).append("new ").append(className).append('(').append(count).append(", \"").append(EnumerationFactory.escapeValue(value)).append("\")").toString();
                    jsc.append(init);
                }
                jsc.append(");");
            }
            ++count;
        }
        JMethod method = jClass.getMethod(this.getInitMethodName(this._maxSuffix), 0);
        method.getSourceCode().add("return members;");
        jClass.addField(fHash);
        field = new JField(JType.INT, "type");
        field.getModifiers().setFinal(true);
        jClass.addField(field);
        field = new JField(SGTypes.STRING, "stringValue");
        field.setInitString("null");
        jClass.addField(field);
        this.createGetTypeMethod(jClass, className);
    }

    private void createJava5Enum(SimpleType simpleType, FactoryState state, XMLBindingComponent component, boolean useValuesAsName, Enumeration<Facet> enumeration) {
        AnnotationBuilder[] annotationBuilders = state.getSGStateInfo().getSourceGenerator().getAnnotationBuilders();
        JEnum jEnum = (JEnum)state.getJClass();
        jEnum.removeInterface("java.io.Serializable");
        jEnum.removeAnnotation(new JAnnotationType("SuppressWarnings"));
        JField valueField = new JField(new JClass("java.lang.String"), "value");
        JModifiers modifiers = new JModifiers();
        modifiers.setFinal(true);
        modifiers.makePrivate();
        valueField.setModifiers(modifiers);
        jEnum.addField(valueField);
        JField enumConstantsField = new JField(new JClass("java.util.Map<java.lang.String, " + jEnum.getLocalName() + ">"), "enumConstants");
        modifiers = new JModifiers();
        modifiers.setFinal(true);
        modifiers.makePrivate();
        modifiers.setStatic(true);
        enumConstantsField.setModifiers(modifiers);
        enumConstantsField.setInitString("new java.util.HashMap<java.lang.String, " + jEnum.getLocalName() + ">()");
        jEnum.addField(enumConstantsField);
        JSourceCode sourceCode = jEnum.getStaticInitializationCode();
        sourceCode.add("for (" + jEnum.getLocalName() + " c: " + jEnum.getLocalName() + ".values()) {");
        sourceCode.indent();
        sourceCode.indent();
        sourceCode.add(jEnum.getLocalName() + "." + enumConstantsField.getName() + ".put(c." + valueField.getName() + ", c);");
        sourceCode.unindent();
        sourceCode.add("}");
        this.addValueMethod(jEnum);
        this.addFromValueMethod(jEnum, enumConstantsField);
        this.addSetValueMethod(jEnum);
        this.addToStringMethod(jEnum);
        JConstructor constructor = jEnum.createConstructor();
        constructor.addParameter(new JParameter(new JClass("java.lang.String"), "value"));
        constructor.setSourceCode("this.value = value;");
        modifiers = new JModifiers();
        modifiers.makePrivate();
        constructor.setModifiers(modifiers);
        jEnum.addConstructor(constructor);
        int enumCount = 0;
        while (enumeration.hasMoreElements()) {
            Facet facet = enumeration.nextElement();
            JEnumConstant enumConstant = useValuesAsName ? new JEnumConstant(this.translateEnumValueToIdentifier(component.getEnumBinding(), facet), new String[]{"\"" + facet.getValue() + "\""}) : new JEnumConstant("VALUE_" + enumCount, new String[]{"\"" + facet.getValue() + "\""});
            for (AnnotationBuilder annotationBuilder : annotationBuilders) {
                annotationBuilder.addEnumConstantAnnotations(facet, enumConstant);
            }
            jEnum.addEnumConstant(enumConstant);
            ++enumCount;
        }
        for (AnnotationBuilder annotationBuilder : annotationBuilders) {
            annotationBuilder.addEnumAnnotations(simpleType, jEnum);
        }
    }

    private void addValueMethod(JEnum jEnum) {
        JMethod valueMethod = new JMethod("value", new JClass("java.lang.String"), "the value of this constant");
        valueMethod.setSourceCode("return this.value;");
        jEnum.addMethod(valueMethod, false);
    }

    private void addToStringMethod(JEnum jEnum) {
        JMethod toStringMethod = new JMethod("toString", new JClass("java.lang.String"), "the value of this constant");
        toStringMethod.setSourceCode("return this.value;");
        jEnum.addMethod(toStringMethod, false);
    }

    private void addSetValueMethod(JEnum jEnum) {
        JMethod setValueMethod = new JMethod("setValue");
        setValueMethod.addParameter(new JParameter(new JClass("java.lang.String"), "value"));
        jEnum.addMethod(setValueMethod, false);
    }

    private void addFromValueMethod(JEnum jEnum, JField enumConstantsField) {
        JMethod fromValueMethod = new JMethod("fromValue", jEnum, "the constant for this value");
        fromValueMethod.addParameter(new JParameter(new JClass("java.lang.String"), "value"));
        JSourceCode sourceCode = new JSourceCode();
        sourceCode.add(jEnum.getLocalName() + " c = " + jEnum.getLocalName() + "." + enumConstantsField.getName() + ".get(value);");
        sourceCode.add("if (c != null) {");
        sourceCode.indent();
        sourceCode.add("return c;");
        sourceCode.unindent();
        sourceCode.add("}");
        sourceCode.add("throw new IllegalArgumentException(value);");
        fromValueMethod.setSourceCode(sourceCode);
        JModifiers modifiers = new JModifiers();
        modifiers.setStatic(true);
        fromValueMethod.setModifiers(modifiers);
        jEnum.addMethod(fromValueMethod, false);
    }

    private JSourceCode getSourceCodeForInitMethod(JClass jClass) {
        JMethod currentInitMethod = jClass.getMethod(this.getInitMethodName(this._maxSuffix), 0);
        if (currentInitMethod.getSourceCode().size() > this._maxEnumerationsPerClass) {
            ++this._maxSuffix;
            JMethod mInit = this.createInitMethod(jClass);
            currentInitMethod.getSourceCode().add("members.putAll(" + mInit.getName() + "());");
            currentInitMethod.getSourceCode().add("return members;");
            return mInit.getSourceCode();
        }
        return currentInitMethod.getSourceCode();
    }

    private String getInitMethodName(int index) {
        if (index == 0) {
            return "init";
        }
        return "init" + index;
    }

    private boolean selectNamingScheme(XMLBindingComponent component, Enumeration<Facet> enumeration, boolean useValuesAsName) {
        boolean duplicateTranslation = false;
        int numberOfTranslationToSpecialCharacter = 0;
        while (enumeration.hasMoreElements()) {
            Facet facet = enumeration.nextElement();
            String possibleId = this.translateEnumValueToIdentifier(component.getEnumBinding(), facet);
            if (possibleId.equals("_") && (numberOfTranslationToSpecialCharacter = (int)((short)(numberOfTranslationToSpecialCharacter + 1))) > 1) {
                duplicateTranslation = true;
            }
            if (this.getJavaNaming().isValidJavaIdentifier(possibleId)) continue;
            return false;
        }
        if (duplicateTranslation) {
            return false;
        }
        return useValuesAsName;
    }

    private void createGetTypeMethod(JClass jClass, String className) {
        JMethod mGetType = new JMethod("getType", JType.INT, "the type of this " + className);
        mGetType.getSourceCode().add("return this.type;");
        JDocComment jdc = mGetType.getJDocComment();
        jdc.appendComment("Returns the type of this " + className);
        jClass.addMethod(mGetType);
    }

    private void createReadResolveMethod(JClass jClass) {
        JMethod mReadResolve = new JMethod("readResolve", SGTypes.OBJECT, "this deserialized object");
        mReadResolve.getModifiers().makePrivate();
        jClass.addMethod(mReadResolve);
        JDocComment jdc = mReadResolve.getJDocComment();
        jdc.appendComment(" will be called during deserialization to replace ");
        jdc.appendComment("the deserialized object with the correct constant ");
        jdc.appendComment("instance.");
        JSourceCode jsc = mReadResolve.getSourceCode();
        jsc.add("return valueOf(this.stringValue);");
    }

    private JMethod createInitMethod(JClass jClass) {
        String initMethodName = this.getInitMethodName(this._maxSuffix);
        JMethod mInit = new JMethod(initMethodName, SGTypes.createHashtable(this.getConfig().useJava50()), "the initialized Hashtable for the member table");
        jClass.addMethod(mInit);
        mInit.getModifiers().makePrivate();
        mInit.getModifiers().setStatic(true);
        if (this.getConfig().useJava50()) {
            mInit.getSourceCode().add("java.util.Hashtable<Object, Object> members = new java.util.Hashtable<Object, Object>();");
        } else {
            mInit.getSourceCode().add("java.util.Hashtable members = new java.util.Hashtable();");
        }
        return mInit;
    }

    private void createToStringMethod(JClass jClass, String className) {
        JMethod mToString = new JMethod("toString", SGTypes.STRING, "the String representation of this " + className);
        jClass.addMethod(mToString);
        JDocComment jdc = mToString.getJDocComment();
        jdc.appendComment("Returns the String representation of this ");
        jdc.appendComment(className);
        mToString.getSourceCode().add("return this.stringValue;");
    }

    private void createEnumerateMethod(JClass jClass, String className) {
        JMethod mEnumerate = new JMethod("enumerate", SGTypes.createEnumeration(SGTypes.OBJECT, this.getConfig().useJava50(), true), "an Enumeration over all possible instances of " + className);
        mEnumerate.getModifiers().setStatic(true);
        jClass.addMethod(mEnumerate);
        JDocComment jdc = mEnumerate.getJDocComment();
        jdc.appendComment("Returns an enumeration of all possible instances of ");
        jdc.appendComment(className);
        mEnumerate.getSourceCode().add("return _memberTable.elements();");
    }

    private void createValueOfMethod(JClass jClass, String className) {
        JMethod mValueOf = new JMethod("valueOf", jClass, "the " + className + " value of parameter 'string'");
        mValueOf.addParameter(new JParameter(SGTypes.STRING, "string"));
        mValueOf.getModifiers().setStatic(true);
        jClass.addMethod(mValueOf);
        JDocComment jdc = mValueOf.getJDocComment();
        jdc.appendComment("Returns a new " + className);
        jdc.appendComment(" based on the given String value.");
        JSourceCode jsc = mValueOf.getSourceCode();
        jsc.add("java.lang.Object obj = null;\nif (string != null) {\n obj = _memberTable.get(string{1});\n}\nif (obj == null) {\n String err = \"'\" + string + \"' is not a valid {0}\";\n throw new IllegalArgumentException(err);\n}\nreturn ({0}) obj;", className, this._caseInsensitive ? ".toLowerCase()" : "");
    }

    void processEnumerationAsBaseType(ExtendedBinding binding, SimpleType simpleType, FactoryState state) {
        SimpleType base = (SimpleType)simpleType.getBaseType();
        XSType baseType = null;
        baseType = base == null ? new XSString() : this._typeConversion.convertType(base, this.getConfig().useJava50());
        Enumeration<Facet> enumeration = simpleType.getFacets("enumeration");
        JClass jClass = state.getJClass();
        String className = jClass.getLocalName();
        JField fValues = null;
        JDocComment jdc = null;
        JSourceCode jsc = null;
        JConstructor constructor = jClass.getConstructor(0);
        constructor.getModifiers().makePrivate();
        fValues = new JField(new JArrayType(baseType.getJType(), this.getConfig().useJava50()), "values");
        int count = 0;
        StringBuilder values = new StringBuilder("{\n");
        while (enumeration.hasMoreElements()) {
            Facet facet = enumeration.nextElement();
            String value = facet.getValue();
            if (count > 0) {
                values.append(",\n");
            }
            values.append("    ");
            if (baseType.getType() == 1) {
                values.append('\"');
                values.append(EnumerationFactory.escapeValue(value));
                values.append('\"');
            } else {
                values.append(value);
            }
            ++count;
        }
        values.append("\n}");
        fValues.setInitString(values.toString());
        jClass.addField(fValues);
        JMethod method = new JMethod("valueOf", jClass, "the String value of the provided " + baseType.getJType());
        method.addParameter(new JParameter(SGTypes.STRING, "string"));
        method.getModifiers().setStatic(true);
        jClass.addMethod(method);
        jdc = method.getJDocComment();
        jdc.appendComment("Returns the " + baseType.getJType());
        jdc.appendComment(" based on the given String value.");
        jsc = method.getSourceCode();
        jsc.add("for (int i = 0; i < values.length; i++) {");
        jsc.add("}");
        jsc.add("throw new IllegalArgumentException(\"");
        jsc.append("Invalid value for ");
        jsc.append(className);
        jsc.append(": \" + string + \".\");");
    }

    private String translateEnumValueToIdentifier(EnumBindingType enumBinding, Facet facet) {
        String enumValue = facet.getValue();
        try {
            Object enumerationValue = null;
            int intVal = Integer.parseInt(facet.getValue());
            String customMemberName = null;
            if (enumBinding != null) {
                customMemberName = this.getCustomMemberName(enumBinding, String.valueOf(intVal));
            }
            enumerationValue = customMemberName != null ? customMemberName : (intVal >= 0 ? "VALUE_" + intVal : "VALUE_NEG_" + Math.abs(intVal));
            return enumerationValue;
        }
        catch (NumberFormatException enumerationValue) {
            StringBuilder sb = new StringBuilder(32);
            String customMemberName = null;
            if (enumBinding != null) {
                customMemberName = this.getCustomMemberName(enumBinding, enumValue);
            }
            if (customMemberName != null) {
                sb.append(customMemberName);
            } else {
                sb.append(enumValue.toUpperCase());
                for (int i = 0; i < sb.length(); ++i) {
                    char c = sb.charAt(i);
                    if ("[](){}<>'`\"".indexOf(c) >= 0) {
                        sb.deleteCharAt(i);
                        --i;
                        continue;
                    }
                    if (!Character.isWhitespace(c) && "\\/?~!@#$%^&*-+=:;.,".indexOf(c) < 0) continue;
                    sb.setCharAt(i, '_');
                }
            }
            return sb.toString();
        }
    }

    private String getCustomMemberName(EnumBindingType enumBinding, String enumValue) {
        EnumMember[] enumMembers;
        String customMemberName = null;
        for (EnumMember enumMember : enumMembers = enumBinding.getEnumMember()) {
            if (!enumMember.getValue().equals(enumValue)) continue;
            customMemberName = enumMember.getJavaName();
        }
        return customMemberName;
    }

    public void setCaseInsensitive(boolean caseInsensitive) {
        this._caseInsensitive = caseInsensitive;
    }

    private static String escapeValue(String str) {
        char[] chars;
        if (str == null) {
            return str;
        }
        StringBuilder sb = new StringBuilder();
        for (char ch : chars = str.toCharArray()) {
            switch (ch) {
                case '\"': 
                case '\'': 
                case '\\': {
                    sb.append('\\');
                    break;
                }
            }
            sb.append(ch);
        }
        return sb.toString();
    }
}

