/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.javasource;

import java.util.Enumeration;
import java.util.Vector;
import org.exolab.javasource.JComment;
import org.exolab.javasource.JDocDescriptor;
import org.exolab.javasource.JSourceWriter;

public final class JDocComment {
    private final Vector<JDocDescriptor> _descriptors = new Vector();
    private final StringBuffer _comment = new StringBuffer();

    public JDocComment() {
    }

    public JDocComment(JDocDescriptor jdesc) {
        this();
        this.addDescriptor(jdesc);
    }

    public void addDescriptor(JDocDescriptor jdesc) {
        if (jdesc == null) {
            return;
        }
        if (this._descriptors.isEmpty()) {
            this._descriptors.add(jdesc);
            return;
        }
        for (int i = 0; i < this._descriptors.size(); ++i) {
            JDocDescriptor jdd = this._descriptors.elementAt(i);
            short compare = jdesc.compareTo(jdd);
            switch (compare) {
                case 0: {
                    this._descriptors.insertElementAt(jdesc, i + 1);
                    return;
                }
                case -1: {
                    this._descriptors.insertElementAt(jdesc, i);
                    return;
                }
            }
        }
        this._descriptors.addElement(jdesc);
    }

    public void appendComment(String comment) {
        this._comment.append(comment);
    }

    public String getComment() {
        return this._comment.toString();
    }

    public void setComment(String comment) {
        this._comment.setLength(0);
        this._comment.append(comment);
    }

    public Enumeration<JDocDescriptor> getDescriptors() {
        return this._descriptors.elements();
    }

    public int getLength() {
        return this._comment.length();
    }

    public JDocDescriptor getParamDescriptor(String name) {
        if (name == null) {
            return null;
        }
        for (JDocDescriptor jdd : this._descriptors) {
            if (jdd.getType() != 0 || !name.equals(jdd.getName())) continue;
            return jdd;
        }
        return null;
    }

    public void print(JSourceWriter jsw) {
        JComment jComment = new JComment(4);
        jComment.setComment(this._comment.toString());
        if (!this._descriptors.isEmpty()) {
            jComment.appendComment("\n");
        }
        for (JDocDescriptor jdd : this._descriptors) {
            jComment.appendComment("\n");
            jComment.appendComment(jdd.toString());
        }
        jComment.print(jsw);
    }

    public String toString() {
        return "/**\n *  */\n";
    }
}

