/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.util.gui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ValueButtonGroup
extends ButtonGroup {
    private final Map valueMap_ = new HashMap();
    private final List listeners_ = new ArrayList();
    private final ChangeListener buttonListener_ = new ChangeListener(){

        public void stateChanged(ChangeEvent evt) {
            if (evt.getSource() instanceof AbstractButton) {
                AbstractButton butt = (AbstractButton)evt.getSource();
                if (butt.isSelected()) {
                    ValueButtonGroup.this.fireValueChanged();
                }
            } else {
                ValueButtonGroup.this.fireValueChanged();
            }
        }
    };

    public void add(AbstractButton button, Object value) {
        super.add(button);
        this.valueMap_.put(button, value);
        button.addChangeListener(this.buttonListener_);
    }

    public void remove(AbstractButton button) {
        button.removeChangeListener(this.buttonListener_);
        this.valueMap_.remove(button);
        super.remove(button);
    }

    public Object getValue() {
        Iterator it = this.buttons.iterator();
        while (it.hasNext()) {
            AbstractButton button = (AbstractButton)it.next();
            if (!button.isSelected()) continue;
            return this.valueMap_.get(button);
        }
        return null;
    }

    public void setValue(Object value) {
        Iterator it = this.valueMap_.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            AbstractButton button = (AbstractButton)entry.getKey();
            if (!(value == null ? value == entry.getValue() : value.equals(entry.getValue()))) continue;
            if (!button.isSelected()) {
                button.setSelected(true);
                this.fireValueChanged();
            }
            return;
        }
        throw new IllegalArgumentException("No value " + value + " in group");
    }

    public void addChangeListener(ChangeListener listener) {
        this.listeners_.add(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.listeners_.remove(listener);
    }

    private void fireValueChanged() {
        ChangeEvent evt = new ChangeEvent(this);
        Iterator it = this.listeners_.iterator();
        while (it.hasNext()) {
            ((ChangeListener)it.next()).stateChanged(evt);
        }
    }
}

