/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.alarmsystem.source;

import alma.JavaContainerError.wrappers.AcsJContainerServicesEx;
import alma.acs.container.ContainerServicesBase;
import alma.acs.logging.AcsLogLevel;
import alma.acsErrTypeAlarmSourceFactory.ACSASFactoryNotInitedEx;
import alma.acsErrTypeAlarmSourceFactory.SourceCreationErrorEx;
import alma.alarmsystem.source.ACSAlarmSystemInterface;
import alma.alarmsystem.source.ACSAlarmSystemInterfaceFactory;
import alma.alarmsystem.source.ACSFaultState;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;

public class AlarmSender {
    private ACSAlarmSystemInterface source = null;
    private volatile boolean closed = false;
    private final ContainerServicesBase containerServices;
    private static final Properties emptyProps = new Properties();

    public AlarmSender(ContainerServicesBase containerServices) {
        if (containerServices == null) {
            throw new IllegalArgumentException("The containerServices can't be null");
        }
        this.containerServices = containerServices;
    }

    public void sendAlarm(String FF, String FM, int FC, Properties properties, boolean active) {
        if (this.closed) {
            StringBuilder str = new StringBuilder("Alarm factory closed alarm sending disabled");
            this.containerServices.getLogger().log((Level)AcsLogLevel.WARNING, str.toString());
            return;
        }
        if (this.source == null) {
            try {
                this.init();
            }
            catch (Throwable t) {
                this.containerServices.getLogger().log((Level)AcsLogLevel.ERROR, "Error initializing the alarm service structs", t);
            }
        }
        if (properties == null) {
            properties = emptyProps;
        }
        try {
            ACSFaultState fs = ACSAlarmSystemInterfaceFactory.createFaultState(FF, FM, FC);
            if (active) {
                fs.setDescriptor("ACTIVE");
            } else {
                fs.setDescriptor("TERMINATE");
            }
            fs.setUserTimestamp(new Timestamp(System.currentTimeMillis()));
            fs.setUserProperties(properties);
            this.source.push(fs);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void sendAlarm(String FF, String FM, int FC, boolean active) {
        this.sendAlarm(FF, FM, FC, null, active);
    }

    private void init() throws AcsJContainerServicesEx, ACSASFactoryNotInitedEx, SourceCreationErrorEx {
        try {
            ACSAlarmSystemInterfaceFactory.usingACSAlarmSystem();
        }
        catch (ACSASFactoryNotInitedEx e) {
            ACSAlarmSystemInterfaceFactory.init(this.containerServices);
        }
        this.source = ACSAlarmSystemInterfaceFactory.createSource();
    }

    public void close() {
        this.closed = true;
    }
}

