/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.guiutil.mvc.examples;

import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.InvalidCoordException;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.OutOfRangeException;
import alma.obsprep.guiutil.mvc.examples.Coords;
import alma.obsprep.guiutil.mvc.examples.CoordsEditor;
import alma.obsprep.util.Convert;
import alma.obsprep.util.Convert4dp;

public class CoordModel
extends Model {
    public CoordModel(Coords coords) {
        super(coords);
    }

    private Coords getCoords() {
        return (Coords)this.getDocument();
    }

    @Override
    public void publish() {
        try {
            this.publish(CoordsEditor.FID_RA, Convert4dp.milliarcsecToHHMMSS(this.getCoords().getRA()));
            this.publish(CoordsEditor.FID_DEC, Convert.milliarcsecToDDMMSS(this.getCoords().getDec()));
        }
        catch (OutOfRangeException outOfRangeException) {
        }
        catch (InvalidCoordException invalidCoordException) {
            // empty catch block
        }
    }

    @Override
    public Object update(Editor editor, FieldID fieldID, Object object) {
        String string = object.toString();
        try {
            if (fieldID.equals(CoordsEditor.FID_RA)) {
                this.getCoords().setRA(Convert4dp.HHMMSSToMilliarcsec(string));
            } else if (fieldID.equals(CoordsEditor.FID_DEC)) {
                this.getCoords().setDec(Convert.DDMMSSToMilliarcsec(string));
            }
        }
        catch (InvalidCoordException invalidCoordException) {
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return string;
    }
}

