/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.misc;

import alma.hla.runtime.obsprep.bo.IBusinessObject;
import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.obsproject.AbstractScienceGoal;
import alma.obsprep.bo.obsproject.ObsProgram;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.guiutil.mvc.MultipageViewException;
import alma.obsprep.guiutil.mvc.widgets.OTTextField;
import alma.obsprep.ot.editors.sciencegoals.MultiResolutionElementTable;
import alma.obsprep.ot.gui.factory.Table;
import alma.obsprep.ot.gui.toplevel.ObservingToolController;
import alma.obsprep.ot.gui.toplevel.ObservingToolGui;
import alma.obsprep.ot.persistence.ImpexFactory;
import alma.obsprep.ot.persistence.ProjectResetListener;
import alma.obsprep.ot.valdef.ProblemListModel;
import alma.obsprep.ot.valdef.others.UserRestrictionsProvider;
import alma.obsprep.problems.DefaultProblem;
import alma.obsprep.problems.Problem;
import alma.obsprep.services.generator.refactored.SchedBlockWorker;
import alma.obsprep.services.network.roledirectory.RoleDirectoryService;
import alma.obsprep.services.network.roledirectory.RoleDirectoryServiceHelper;
import java.awt.Color;
import java.awt.Component;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public class UserEditRestrictionController
implements ProjectResetListener,
RoleDirectoryService.UserAuthenticatesListener {
    public static final Color EDITABLE_BY_ALL_COLOUR = Color.WHITE;
    public static final Color PI_CAN_EDIT_COLOUR = new Color(191, 204, 255);
    private boolean phasesComparisonNotPossible = false;
    private List<JComponent> userEditRestrictionAffectedComponents = new ArrayList<JComponent>();
    private Map<ScienceGoal, UserEditRestriction> majorEditRestrictions = new HashMap<ScienceGoal, UserEditRestriction>();
    private List<MajorChangePersistence> majorChangePersistenceData = new ArrayList<MajorChangePersistence>();
    private static UserEditRestrictionController instance = null;
    private List<Class> componentsTypesColourControlled = List.of(OTTextField.class, JTextField.class, JComboBox.class);
    private Map<Component, Color> previousBackgroundColourMap = new ConcurrentHashMap<Component, Color>();

    public static synchronized UserEditRestrictionController getInstance() {
        if (instance == null) {
            instance = new UserEditRestrictionController();
        }
        return instance;
    }

    private UserEditRestrictionController() {
        ImpexFactory.getInstance().addProjectImportListener(this);
    }

    public void reset() {
        this.majorEditRestrictions.clear();
    }

    private void initialiseManagedFields(@NonNull ObsProject obsProject) throws UnknownEntityException {
        if (obsProject == null) {
            throw new NullPointerException("project is marked non-null but is null");
        }
        this.phasesComparisonNotPossible = false;
        ObsProposal obsProposal = obsProject.getObsProposal();
        ObsProgram obsProgram = obsProject.getObsProgram();
        if (obsProposal == null || obsProgram == null) {
            return;
        }
        ScienceGoal[] scienceGoalArray = obsProposal.getAbstractScienceGoalScienceGoal();
        ScienceGoal[] scienceGoalArray2 = obsProgram.getAbstractScienceGoalScienceGoal();
        this.reset();
        if (scienceGoalArray.length == 0) {
            Log.logger(UserEditRestrictionController.class).info("No phase 1 science goals detected - cannot setup minor edit restrictions");
            this.phasesComparisonNotPossible = true;
            return;
        }
        if (scienceGoalArray.length != scienceGoalArray2.length) {
            Log.logger(UserEditRestrictionController.class).info("Different number of science goals in P1 and P2");
            this.phasesComparisonNotPossible = true;
            return;
        }
        for (ScienceGoal scienceGoal : scienceGoalArray2) {
            ScienceGoal scienceGoal2 = null;
            for (ScienceGoal scienceGoal3 : scienceGoalArray) {
                if (!StringUtils.equals((CharSequence)scienceGoal3.getName(), (CharSequence)scienceGoal.getName())) continue;
                scienceGoal2 = scienceGoal3;
            }
            UserEditRestriction userEditRestriction = new UserEditRestriction(this);
            if (scienceGoal2 == null) {
                Log.logger(UserEditRestrictionController.class).info("Cannot find P1 science goal counterpart to P2 science goal");
                this.phasesComparisonNotPossible = true;
                break;
            }
            userEditRestriction.setP1SG(scienceGoal2);
            userEditRestriction.setP2SG(scienceGoal);
            UserRestrictionsProvider.getUserRestrictionPredicates(userEditRestriction);
            this.majorEditRestrictions.put(scienceGoal, userEditRestriction);
        }
    }

    public void setComponentVisibility(ScienceGoal scienceGoal) {
        List<SchedBlock> list = SchedBlockWorker.findSBsInSG((AbstractScienceGoal)((Object)scienceGoal));
        boolean bl = true;
        for (SchedBlock schedBlock : list) {
            if (schedBlock.isDeletable()) continue;
            bl = false;
            break;
        }
        boolean bl2 = RoleDirectoryServiceHelper.isUserP2G();
        boolean bl3 = false;
        try {
            bl3 = RoleDirectoryServiceHelper.isContactScientist(scienceGoal.getObsProposal().getObsProject());
        }
        catch (UnknownEntityException unknownEntityException) {
            Log.logger(UserEditRestrictionController.class).warning("Unable to determine if user is a contact scientist for the project");
            return;
        }
        boolean bl4 = bl2 || !bl3 && bl && !this.isPreExistingP2GMajorEditsInPlace(scienceGoal);
        this.userEditRestrictionAffectedComponents.stream().forEach(jComponent -> {
            Serializable serializable;
            if (jComponent instanceof MultiResolutionElementTable) {
                jComponent.setEnabled(bl4);
            } else if (Table.class.isAssignableFrom(jComponent.getClass())) {
                serializable = (Table)jComponent;
                if (bl4 && !bl2) {
                    serializable.setEnabled(bl4, PI_CAN_EDIT_COLOUR);
                } else {
                    serializable.setEnabled(bl4);
                }
            } else {
                jComponent.setEnabled(bl4);
            }
            if (this.isComponentColourControlled((Component)jComponent)) {
                serializable = this.previousBackgroundColourMap.containsKey(jComponent) ? this.previousBackgroundColourMap.get(jComponent) : EDITABLE_BY_ALL_COLOUR;
                jComponent.setBackground((Color)(bl4 && !bl2 ? PI_CAN_EDIT_COLOUR : serializable));
            }
        });
    }

    public boolean isPreExistingP2GMajorEditsInPlace(ScienceGoal scienceGoal) {
        boolean bl = RoleDirectoryServiceHelper.isUserP2G();
        if (bl) {
            return false;
        }
        if (this.phasesComparisonNotPossible) {
            Log.logger(UserEditRestrictionController.class).fine("Phases comparision is not possible");
            return true;
        }
        if (!bl) {
            for (MajorChangePersistence object : this.majorChangePersistenceData) {
                if (!StringUtils.equals((CharSequence)object.getP2SGName(), (CharSequence)scienceGoal.getName())) continue;
                return object.getIsMajorChangeDetected();
            }
        }
        if (this.phasesComparisonNotPossible || !this.majorEditRestrictions.containsKey(scienceGoal)) {
            return true;
        }
        UserEditRestriction userEditRestriction = this.majorEditRestrictions.get(scienceGoal);
        if (!userEditRestriction.getP1SG().isPresent()) {
            Log.logger(UserEditRestrictionController.class).fine("P1 SG counterpart is missing: PI cannot change P2 SG");
            return true;
        }
        if (!userEditRestriction.isNecessaryToReevaluateMajorChanges()) {
            return userEditRestriction.isMajorChangeDetected();
        }
        userEditRestriction.setNecessaryToReevaluateMajorChange(false);
        for (Predicate<UserEditRestriction> predicate : userEditRestriction.getUserRestrictionPredicates()) {
            try {
                if (!predicate.test(userEditRestriction) || bl) continue;
                return userEditRestriction.setMajorChangeDetected(true);
            }
            catch (UserRestrictionsProvider.UserRestrictionComparisonNotPossibleException userRestrictionComparisonNotPossibleException) {
                Log.logger(UserEditRestrictionController.class).fine("Unable to execute the predicate: PI cannot change P2 SG");
                userEditRestriction.setMajorChangeReason(userRestrictionComparisonNotPossibleException.getMessage());
                return userEditRestriction.setMajorChangeDetected(true);
            }
        }
        return userEditRestriction.setMajorChangeDetected(false);
    }

    public void performUserRestrictedValidationChecks(ScienceGoal scienceGoal, ProblemListModel problemListModel) {
        boolean bl = RoleDirectoryServiceHelper.isUserP2G();
        if (this.phasesComparisonNotPossible || !this.majorEditRestrictions.containsKey(scienceGoal)) {
            this.createComparisonNotPossibleValidationReport(scienceGoal, problemListModel, "");
            return;
        }
        UserEditRestriction userEditRestriction = this.majorEditRestrictions.get(scienceGoal);
        if (!userEditRestriction.getP1SG().isPresent()) {
            this.createComparisonNotPossibleValidationReport(scienceGoal, problemListModel, userEditRestriction.getMajorChangeReason());
            return;
        }
        assert (userEditRestriction.getUserRestrictionPredicates() != null && userEditRestriction.getValidationReports() != null);
        assert (userEditRestriction.getUserRestrictionPredicates().size() == userEditRestriction.getValidationReports().size()) : "Ensure that the number of validation reports matches the number of predicates that they should map to";
        int n = 0;
        for (Predicate<UserEditRestriction> predicate : userEditRestriction.getUserRestrictionPredicates()) {
            try {
                if (predicate.test(userEditRestriction)) {
                    ValidationReport validationReport = userEditRestriction.getValidationReports().get(n);
                    Problem problem = bl ? DefaultProblem.createWarning(validationReport.getDescription(), validationReport.getSuggestion(), (IBusinessObject)scienceGoal) : DefaultProblem.createError(validationReport.getDescription(), validationReport.getSuggestion(), (IBusinessObject)scienceGoal);
                    problemListModel.add(problem);
                }
                ++n;
            }
            catch (UserRestrictionsProvider.UserRestrictionComparisonNotPossibleException userRestrictionComparisonNotPossibleException) {
                this.createComparisonNotPossibleValidationReport(scienceGoal, problemListModel, userRestrictionComparisonNotPossibleException.getMessage());
                return;
            }
        }
    }

    private void createComparisonNotPossibleValidationReport(ScienceGoal scienceGoal, ProblemListModel problemListModel, String string) {
        Problem problem = RoleDirectoryServiceHelper.isUserP2G() ? DefaultProblem.createWarning("The project structure has been altered compared to Phase 1", "Submission will only be possible by a privileged user.", (IBusinessObject)scienceGoal) : DefaultProblem.createError("The project structure has been altered compared to Phase 1", "Submission will only be possible by a privileged user.", (IBusinessObject)scienceGoal);
        if (!StringUtils.isEmpty((CharSequence)string)) {
            Log.logger(UserEditRestrictionController.class).info("Major changes exist in " + scienceGoal.getName() + " - " + string);
        }
        problemListModel.add(problem);
    }

    @Override
    public void projectDocumentReset(ObsProject obsProject, ImpexFactory.WorkingPersistenceData workingPersistenceData) {
        Log.logger(UserEditRestrictionController.class).info("Project imported - setting up user major change restrictions");
        this.majorChangePersistenceData = List.copyOf(workingPersistenceData.getMajorChangePersistenceData());
        try {
            this.initialiseManagedFields(obsProject);
        }
        catch (UnknownEntityException unknownEntityException) {
            Log.logger(UserEditRestrictionController.class).severe("Unable to set up P2 major-edit restrictions : " + unknownEntityException.getMessage());
        }
    }

    @Override
    public void userHasAuthenticated() {
        ObservingToolController.getMyInstance();
        ObservingToolGui observingToolGui = ObservingToolController.getOTGui();
        ObsProject obsProject = observingToolGui.getActiveProject();
        if (obsProject != null) {
            this.projectDocumentReset(obsProject, new ImpexFactory.WorkingPersistenceData());
            if (SwingUtilities.isEventDispatchThread()) {
                try {
                    observingToolGui.updateEditor(true);
                }
                catch (MultipageViewException multipageViewException) {}
            } else {
                SwingUtilities.invokeLater(() -> {
                    try {
                        observingToolGui.updateEditor(true);
                    }
                    catch (MultipageViewException multipageViewException) {
                        // empty catch block
                    }
                });
            }
        }
    }

    public void registerUserChangeRestrictionAffectedComponents(List<JComponent> list) {
        list.stream().filter(jComponent -> !this.userEditRestrictionAffectedComponents.contains(jComponent)).forEach(jComponent -> this.userEditRestrictionAffectedComponents.add((JComponent)jComponent));
    }

    public void removeUserChangeRestrictionAffectedComponents(List<JComponent> list) {
        this.userEditRestrictionAffectedComponents.removeAll(list);
    }

    public boolean isComponentP2EditRestrictionControlled(Component component) {
        return this.userEditRestrictionAffectedComponents.contains(component);
    }

    public ArrayList<MajorChangePersistence> getMajorChangePersistenceData() {
        ArrayList<MajorChangePersistence> arrayList = new ArrayList<MajorChangePersistence>();
        for (ScienceGoal scienceGoal : this.majorEditRestrictions.keySet()) {
            UserEditRestriction userEditRestriction = this.majorEditRestrictions.get(scienceGoal);
            arrayList.add(new MajorChangePersistence(scienceGoal.getName(), userEditRestriction.isMajorChangeDetected()));
        }
        return arrayList;
    }

    public boolean isComponentColourControlled(Component component) {
        for (Class clazz : this.componentsTypesColourControlled) {
            if (!component.getClass().equals(clazz)) continue;
            return true;
        }
        return false;
    }

    public void resetColourMapping() {
        this.userEditRestrictionAffectedComponents.stream().forEach(jComponent -> {
            if (jComponent.getBackground().equals(PI_CAN_EDIT_COLOUR)) {
                jComponent.setBackground(this.previousBackgroundColourMap.containsKey(jComponent) ? this.previousBackgroundColourMap.get(jComponent) : EDITABLE_BY_ALL_COLOUR);
            }
        });
    }

    public class UserEditRestriction {
        private String majorChangeReason = "";
        private boolean isMajorChangeDetected = false;
        private boolean isNecessaryToReevaluateMajorChange = true;
        private List<Predicate<UserEditRestriction>> userRestrictionPredicates = null;
        private ScienceGoal p1SG = null;
        private ScienceGoal p2SG = null;
        private List<ValidationReport> validationReports = null;

        public UserEditRestriction(UserEditRestrictionController userEditRestrictionController) {
        }

        public boolean isMajorChangeDetected() {
            return this.isMajorChangeDetected;
        }

        public boolean setMajorChangeDetected(boolean bl) {
            this.isMajorChangeDetected = bl;
            if (!bl) {
                this.setMajorChangeReason("");
            }
            return bl;
        }

        public void setP1SG(ScienceGoal scienceGoal) {
            this.p1SG = scienceGoal;
        }

        public Optional<ScienceGoal> getP1SG() {
            return Optional.ofNullable(this.p1SG);
        }

        public ScienceGoal getP2SG() {
            return this.p2SG;
        }

        public void setP2SG(ScienceGoal scienceGoal) {
            this.p2SG = scienceGoal;
        }

        public List<Predicate<UserEditRestriction>> getUserRestrictionPredicates() {
            return this.userRestrictionPredicates;
        }

        public void setUserRestrictionPredicates(List<Predicate<UserEditRestriction>> list) {
            this.userRestrictionPredicates = list;
        }

        public boolean isNecessaryToReevaluateMajorChanges() {
            return this.isNecessaryToReevaluateMajorChange;
        }

        public void setNecessaryToReevaluateMajorChange(boolean bl) {
            this.isNecessaryToReevaluateMajorChange = bl;
        }

        public void setValidationReports(@NonNull List<ValidationReport> list) {
            if (list == null) {
                throw new NullPointerException("validationReports is marked non-null but is null");
            }
            this.validationReports = list;
        }

        public List<ValidationReport> getValidationReports() {
            return this.validationReports;
        }

        public String getMajorChangeReason() {
            return this.majorChangeReason;
        }

        public void setMajorChangeReason(String string) {
            this.majorChangeReason = string;
        }
    }

    public static class MajorChangePersistence
    implements Serializable {
        private static final long serialVersionUID = 6723784416725625585L;
        private String p2SGName;
        private Boolean isMajorChangeDetected;

        public MajorChangePersistence(String string, Boolean bl) {
            this.setP2SGName(string);
            this.setIsMajorChangeDetected(bl);
        }

        public String getP2SGName() {
            return this.p2SGName;
        }

        public void setP2SGName(String string) {
            this.p2SGName = string;
        }

        public Boolean getIsMajorChangeDetected() {
            return this.isMajorChangeDetected;
        }

        public void setIsMajorChangeDetected(Boolean bl) {
            this.isMajorChangeDetected = bl;
        }
    }

    public static class ValidationReport {
        private String description;
        private String suggestion;

        public ValidationReport(String string, String string2) {
            this.setDescription(string);
            this.setSuggestion(string2);
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String string) {
            this.description = string;
        }

        public String getSuggestion() {
            return this.suggestion;
        }

        public void setSuggestion(String string) {
            this.suggestion = string;
        }
    }
}

