/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.schedblock;

import alma.obsprep.bo.schedblock.AbstractBaseBandConfig;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.guiutil.ColumnResizer;
import alma.obsprep.ot.editors.misc.ComboBoxCellEditor;
import alma.obsprep.ot.editors.misc.ComboBoxWithTextStyle;
import alma.obsprep.ot.editors.misc.ValueUnitPairCellEditor;
import alma.obsprep.ot.editors.spectralvisual.ResourceColumnRenderer;
import alma.obsprep.ot.gui.factory.Table;
import alma.obsprep.ot.models.schedblock.BaseBandConfigTableModel;
import alma.valuetypes.DataRate;
import alma.valuetypes.Frequency;
import alma.valuetypes.data.DataRateData;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class BaseBandConfigTable
extends Table {
    private static final long serialVersionUID = -867257392963771967L;
    public static final int TABLE_WIDTH = 800;

    public BaseBandConfigTable(TableModel tableModel) {
        super(tableModel);
        this.setSelectionMode(0);
        this.setColumnSelectionAllowed(false);
        this.getTableHeader().setReorderingAllowed(false);
        this.setToolTipText("Up to " + SpectralSpec.maxBaseBandCount() + " BaseBands may be added");
        Dimension dimension = new Dimension(800, 80);
        this.setPreferredScrollableViewportSize(dimension);
        this.setupTableCellEditors();
        this.setupTableCellRenderers();
    }

    private BaseBandConfigTableModel getMyModel() {
        return (BaseBandConfigTableModel)this.getModel();
    }

    private void setupTableCellEditors() {
        ValueUnitPairCellEditor.FrequencyEditor frequencyEditor = new ValueUnitPairCellEditor.FrequencyEditor();
        ValueUnitPairCellEditor.FrequencyEditor frequencyEditor2 = new ValueUnitPairCellEditor.FrequencyEditor(false);
        TableColumn tableColumn = this.getColumnModel().getColumn(BaseBandConfigTableModel.ColumnDescriptor.CENTER_FREQUENCY.ordinal());
        tableColumn.setCellEditor(frequencyEditor);
        tableColumn = this.getColumnModel().getColumn(BaseBandConfigTableModel.ColumnDescriptor.IMAGE_FREQUENCY.ordinal());
        tableColumn.setCellEditor(frequencyEditor);
        tableColumn = this.getColumnModel().getColumn(BaseBandConfigTableModel.ColumnDescriptor.LO2FREQUENCY.ordinal());
        tableColumn.setCellEditor(frequencyEditor2);
        ComboBoxWithTextStyle comboBoxWithTextStyle = new ComboBoxWithTextStyle(AbstractBaseBandConfig.getKnownDataProductsList());
        ComboBoxCellEditor comboBoxCellEditor = new ComboBoxCellEditor(comboBoxWithTextStyle){
            private static final long serialVersionUID = 7790659089224318391L;

            @Override
            public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
                BaseBandConfigTable.this.setRowSelectionInterval(n, n);
                return this.getComponent();
            }
        };
        ((DefaultCellEditor)comboBoxCellEditor).setClickCountToStart(2);
        tableColumn = this.getColumnModel().getColumn(BaseBandConfigTableModel.ColumnDescriptor.DATA_PRODUCT.ordinal());
        tableColumn.setCellEditor(comboBoxCellEditor);
        ColumnResizer.initColumnSizes(this, this.getMyModel().getLongValues());
    }

    private void setupTableCellRenderers() {
        this.setDefaultRenderer(Object.class, new ResourceColumnRenderer());
        ResourceColumnRenderer resourceColumnRenderer = new ResourceColumnRenderer(){
            private static final long serialVersionUID = -3616967765402635302L;

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Frequency frequency = (Frequency)((Object)object);
                String string = String.format("%.5f GHz", frequency.getContentInGHz());
                return super.getTableCellRendererComponent(jTable, string, bl, bl2, n, n2);
            }
        };
        this.setDefaultRenderer(Frequency.class, resourceColumnRenderer);
        ResourceColumnRenderer resourceColumnRenderer2 = new ResourceColumnRenderer(){
            private static final long serialVersionUID = 4525687481420190324L;

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                DataRate dataRate = (DataRate)((Object)object);
                String string = String.format("%.3f MB/s", dataRate.getContentInUnits(DataRateData.UNIT_MB_S));
                return super.getTableCellRendererComponent(jTable, string, bl, bl2, n, n2);
            }
        };
        resourceColumnRenderer2.setToolTipText("Correlator output data rate : " + this.getToolTipText());
        this.getColumnModel().getColumn(BaseBandConfigTableModel.ColumnDescriptor.DATARATE.ordinal()).setCellRenderer(resourceColumnRenderer2);
    }
}

