/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.sciencegoals;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.obsprep.bo.obsproject.AbstractScienceGoal;
import alma.obsprep.bo.obsproject.AbstractScienceSpectralWindow;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.ScienceSpectralWindow;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.ot.boEditors.ValueUnitPairVerifier;
import alma.obsprep.ot.editors.sciencegoals.SfiSpectralSetupEditor;
import alma.obsprep.ot.editors.sciencegoals.SpectralSetupPropertyChangeListener;
import alma.obsprep.ot.editors.sciencegoals.SpectralWindowGroupEditor;
import alma.obsprep.ot.editors.valuetypes.ValueUnitPairEditor;
import alma.obsprep.ot.gui.toplevel.DialogId;
import alma.obsprep.ot.models.sciencegoals.SpectralSetupParametersModel;
import alma.obsprep.ot.models.sciencegoals.SpectralWindowGroupModel;
import alma.obsprep.services.experts.VLBIExpert;
import alma.obsprep.services.experts.spectralline.SpectralLineChooser;
import alma.obsprep.util.GUIUtilities;
import alma.valuetypes.Frequency;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelListener;

public class SpectralSetupParametersEditor
extends Editor
implements SfiSpectralSetupEditor.ScienceSpectralWindowSelector {
    private static final long serialVersionUID = 8402604590109137691L;
    public static final FieldID FID_REPFREQ_VUP = new FieldID("SpectralSetup.ReprFreq.vup");
    public static final int NUM_BASEBANDS = 4;
    private static final DialogId dialogId = new DialogId("SpectralSetupParametersEditor.swapBasebands", "Notify the user that basebands have been re-ordered");
    private static final String REP_FREQ_MSG = "<html><h4>Representative Frequency</h4>The representative frequency is used in conjunction with the sensitivity entered on the 'Control and Performance' page to estimate the required<br>observing time and to set the size of the antenna beam shown in the 'Spatial Visual' editor. If the transition you are most interested in does<br>not fall in the centre of the chosen spectral window, its frequency can be changed here. The sky equivalents of the representative frequency are<br>shown in the targets table below.</html>";
    private SpectralWindowGroupEditor[] spectralWindowGroupEditors;
    private final SpectralLineChooser lineChooser;
    private ValueUnitPairEditor repFreqEditor;
    private ValueUnitPairVerifier reprFreqVerifier;
    protected int chosenTargetIndex = -1;
    private static int basebandSwapId = 0;

    public SpectralSetupParametersEditor(Model model2, SpectralLineChooser spectralLineChooser) {
        this.setModel(model2);
        this.lineChooser = spectralLineChooser;
        this.build();
        if (model2 instanceof SpectralSetupParametersModel) {
            SpectralSetupParametersModel spectralSetupParametersModel = (SpectralSetupParametersModel)model2;
            spectralSetupParametersModel.subscribeToAllRegisteredModels((model, fieldID, object) -> this.refreshRepFreqVerifier());
        }
        model2.publish();
    }

    SpectralSetupParametersModel getMyModel() {
        return (SpectralSetupParametersModel)this.getModel();
    }

    SpectralWindowGroupEditor getSpectralWindowGroupEditor(int n) throws IndexOutOfBoundsException {
        return this.spectralWindowGroupEditors[n];
    }

    public void setButtonBoxesVisible(boolean bl) {
        for (int i = 0; i < 4; ++i) {
            this.spectralWindowGroupEditors[i].setButtonBoxVisible(bl);
        }
    }

    public void setReadOnlyTable(boolean bl) {
        for (int i = 0; i < 4; ++i) {
            this.spectralWindowGroupEditors[i].getMyModel().getTableModel().setReadOnlyTable(bl);
        }
    }

    private void refreshAllTableColumnSizes() {
        try {
            int n = this.spectralWindowGroupEditors[0].getTableColumnCount();
            for (int i = 0; i < n; ++i) {
                int n2 = this.spectralWindowGroupEditors[0].getTableColumnWidth(i);
                for (int j = 1; j < 4; ++j) {
                    this.spectralWindowGroupEditors[j].setTableColumnWidth(i, n2);
                }
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Override
    protected void build() {
        JComponent jComponent2;
        boolean bl;
        this.setLayout(new BorderLayout());
        this.setName("SpectralSetupParametersEditor");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 3));
        this.spectralWindowGroupEditors = new SpectralWindowGroupEditor[4];
        for (bl = false; bl < 4 != 0; bl += 1) {
            SpectralWindowGroupModel object = this.getMyModel().getSubModel(bl ? 1 : 0);
            this.spectralWindowGroupEditors[bl] = new SpectralWindowGroupEditor(object, this.lineChooser);
            jPanel.add(this.spectralWindowGroupEditors[bl]);
            if (bl <= false) continue;
            this.spectralWindowGroupEditors[bl].removeTableHeader();
        }
        bl = true;
        for (JComponent jComponent2 : this.spectralWindowGroupEditors) {
            JButton jButton = jComponent2.getSelectLineButton();
            final ArrayList<JButton> arrayList = new ArrayList<JButton>();
            for (SpectralWindowGroupEditor spectralWindowGroupEditor : this.spectralWindowGroupEditors) {
                if (jComponent2 == spectralWindowGroupEditor) continue;
                arrayList.add(spectralWindowGroupEditor.getSelectLineButton());
            }
            jButton.addPropertyChangeListener("enabled", new SpectralSetupPropertyChangeListener(bl){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    Boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                    for (JButton jButton : arrayList) {
                        boolean bl2 = true;
                        if (this.isStateVLBISpectralLineAffected) {
                            boolean bl3 = false;
                            boolean bl4 = false;
                            try {
                                SpectralSetupParameters spectralSetupParameters = (SpectralSetupParameters)((Object)SpectralSetupParametersEditor.this.getMyModel().getDocument());
                                bl3 = spectralSetupParameters.isSpectralLine();
                                bl4 = ObsProposal.isProposalVLBI();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            boolean bl5 = bl2 = !bl4 || !bl3 || !VLBIExpert.IS_VLBI_SPECTRALLINE_ENABLED;
                        }
                        if (jButton.isEnabled() == bl.booleanValue() || !bl2) continue;
                        jButton.setEnabled(bl);
                    }
                }
            });
            bl = false;
        }
        TableColumnModelListener tableColumnModelListener = new TableColumnModelListener(){

            @Override
            public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
            }

            @Override
            public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
            }

            @Override
            public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
            }

            @Override
            public void columnMarginChanged(ChangeEvent changeEvent) {
                SpectralSetupParametersEditor.this.refreshAllTableColumnSizes();
            }

            @Override
            public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
            }
        };
        this.spectralWindowGroupEditors[0].addTableColumnListener(tableColumnModelListener);
        JPanel jPanel2 = new JPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel2.setLayout(new GridBagLayout());
        jComponent2 = new JLabel(REP_FREQ_MSG);
        gridBagConstraints.fill = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        jPanel2.add((Component)jComponent2, gridBagConstraints);
        this.repFreqEditor = new ValueUnitPairEditor(this.getMyModel().getRepFreqModel());
        this.repFreqEditor.setToolTipText("<html>Defaults to centre of Representative Window</html>");
        this.registerSubView(this.repFreqEditor);
        gridBagConstraints.gridy = 1;
        jPanel2.add((Component)this.repFreqEditor, gridBagConstraints);
        this.add((Component)jPanel, "Center");
        this.add((Component)jPanel2, "Last");
    }

    private void refreshRepFreqVerifier() {
        ScienceSpectralWindow scienceSpectralWindow = this.getMyModel().getRepresentativeWindow();
        if (scienceSpectralWindow != null) {
            Object object;
            boolean bl = false;
            if (this.reprFreqVerifier != null && this.reprFreqVerifier.verify() == null) {
                bl = true;
            }
            Frequency frequency = (Frequency)scienceSpectralWindow.getEffectiveBandwidth().half(true);
            if (scienceSpectralWindow.getIsSkyFrequency()) {
                Frequency frequency2 = scienceSpectralWindow.getCenterFrequencySky();
                object = ((Frequency)frequency2.minus((AbstractDoubleWithUnit)frequency, true)).getContentInDefaultUnits();
                Double d = ((Frequency)frequency2.plus((AbstractDoubleWithUnit)frequency, true)).getContentInDefaultUnits();
                this.reprFreqVerifier = new ValueUnitPairVerifier(this.repFreqEditor, ((Double)object).doubleValue(), (double)d);
            } else {
                Frequency frequency3 = scienceSpectralWindow.getCenterFrequencyRest();
                AbstractScienceGoal abstractScienceGoal = (AbstractScienceGoal)((SpectralSetupParameters)((Object)((SpectralSetupParametersModel)this.getModel()).getDocument())).getParent();
                if (!(abstractScienceGoal instanceof ScienceGoal)) {
                    return;
                }
                ScienceGoal scienceGoal = (ScienceGoal)((Object)abstractScienceGoal);
                object = this.chosenTargetIndex == -1 || this.chosenTargetIndex >= scienceGoal.getTargetParametersCount() ? scienceGoal.getTargetParameters(0) : scienceGoal.getTargetParameters(this.chosenTargetIndex);
                Frequency frequency4 = object.getSourceVelocity().reverseShift(frequency);
                Double d = ((Frequency)frequency3.minus((AbstractDoubleWithUnit)frequency4, true)).getContentInDefaultUnits();
                Double d2 = ((Frequency)frequency3.plus((AbstractDoubleWithUnit)frequency4, true)).getContentInDefaultUnits();
                this.reprFreqVerifier = new ValueUnitPairVerifier(this.repFreqEditor, (double)d, (double)d2);
            }
            this.repFreqEditor.setVerifier("KEYSTROKE_VERIFIER", this.reprFreqVerifier);
            object = this.reprFreqVerifier.verify();
            if (bl && object != null) {
                this.repFreqEditor.updateField(this.repFreqEditor.getValueFID());
                this.repFreqEditor.updateField(this.repFreqEditor.getUnitFID());
            }
        } else {
            this.reprFreqVerifier = null;
            this.repFreqEditor.setVerifier("KEYSTROKE_VERIFIER", this.reprFreqVerifier);
        }
    }

    @Override
    public AbstractScienceSpectralWindow getSelectedScienceSpectralWindow() {
        return this.getSpectralWindowGroupEditor(0).getSelectedScienceSpectralWindow();
    }

    public AbstractScienceSpectralWindow getSelectedScienceSpectralWindow(int n) {
        return this.getSpectralWindowGroupEditor(n).getSelectedScienceSpectralWindow();
    }

    public int getSelectedScienceSpectralWindowIndex(int n) {
        return this.getSpectralWindowGroupEditor(n).getSelectedScienceSpectralWindowIndex();
    }

    public void addListSelectionListener(int n, ListSelectionListener listSelectionListener) {
        this.getSpectralWindowGroupEditor(n).addListSelectionListener(listSelectionListener);
    }

    public void removeListSelectionListener(int n, ListSelectionListener listSelectionListener) {
        this.getSpectralWindowGroupEditor(n).removeListSelectionListener(listSelectionListener);
    }

    public ListSelectionListener getListSelectionListener(int n) {
        return this.getSpectralWindowGroupEditor(n).getListSelectionListener();
    }

    public void clearSelection(int n) {
        this.getSpectralWindowGroupEditor(n).clearSelection();
    }

    public void addTableModelListener(TableModelListener tableModelListener) {
        for (int i = 0; i < 4; ++i) {
            this.spectralWindowGroupEditors[i].addTableModelListener(tableModelListener);
        }
    }

    public void addTargetTableListener(JTable jTable) {
        if (jTable == null) {
            return;
        }
        ListSelectionListener listSelectionListener = listSelectionEvent -> {
            ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
            if (!listSelectionModel.getValueIsAdjusting()) {
                this.chosenTargetIndex = jTable.getSelectedRow();
                this.refreshRepFreqVerifier();
            }
        };
        jTable.getSelectionModel().addListSelectionListener(listSelectionListener);
    }

    @Override
    public void update(FieldID fieldID, Object object) {
        if (SpectralSetupParametersModel.BASEBANDS_SWAPPED.equals(fieldID)) {
            int[] nArray = (int[])object;
            int n = nArray[0] + 1;
            int n2 = nArray[1] + 1;
            int n3 = nArray[2];
            if (n3 != basebandSwapId) {
                basebandSwapId = n3;
                String string = "<html>Basebands " + n + " and " + n2 + " have been exchanged to comply with baseband order restrictions.</html>";
                GUIUtilities.infoWithDoNotShowAgain(dialogId, string);
            }
        }
    }

    @Override
    public void finalizeUserEdits() {
        Arrays.stream(this.spectralWindowGroupEditors).forEach(spectralWindowGroupEditor -> spectralWindowGroupEditor.finalizeUserEdits());
    }
}

