/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.sciencegoals;

import alma.obsprep.ot.editors.misc.ValueCellEditor;
import alma.obsprep.ot.editors.obsproject.DateEditorFactory;
import alma.obsprep.ot.gui.factory.Table;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;

public class TimingConstraintsTable
extends Table {
    private static final long serialVersionUID = 3900865882362616898L;
    public static final int TABLE_WIDTH = 700;
    private static final DateEditorFactory DATE_EDITOR_FACTORY = new DateEditorFactory();

    public TimingConstraintsTable(TableModel tableModel) {
        super(tableModel);
        this.setSelectionMode(0);
        this.setColumnSelectionAllowed(false);
        this.getTableHeader().setReorderingAllowed(false);
        this.setToolTipText("TODO add tooltip");
        this.setupTableCellEditors();
        this.setupTableCellRenderers();
        ActionMap actionMap = this.getActionMap();
        actionMap.put("selectPreviousColumnCell", new PreviousFocusHandler());
        actionMap.put("selectNextColumnCell", new NextFocusHandler());
    }

    private void setupTableCellEditors() {
        this.setDefaultEditor(Double.class, new ValueCellEditor.Double());
        this.setDefaultEditor(Date.class, DATE_EDITOR_FACTORY.getEditor());
    }

    private void setupTableCellRenderers() {
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer(){
            private static final long serialVersionUID = 1L;
            final String sdfStr = "yyyy-MM-dd HH:mm";
            final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                this.setToolTipText("To edit a date/time, click upon the cell to be changed and then press the \"Edit\" button below. ");
                super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                if (object instanceof Date) {
                    this.setText(this.sdf.format((Date)object));
                }
                return this;
            }
        };
        this.setDefaultRenderer(Date.class, defaultTableCellRenderer);
    }

    public class PreviousFocusHandler
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            keyboardFocusManager.focusPreviousComponent();
        }
    }

    public class NextFocusHandler
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            keyboardFocusManager.focusNextComponent();
        }
    }
}

