/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.sciencegoals;

import alma.hla.runtime.obsprep.util.UnitMap;
import alma.obsprep.bo.TestUtilities;
import alma.obsprep.bo.obsproject.PerformanceParameters;
import alma.obsprep.bo.obsproject.VisitConstraint;
import alma.obsprep.bo.obsproject.data.PerformanceParametersData;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.widgets.OTButtonGroup;
import alma.obsprep.guiutil.mvc.widgets.OTComboBox;
import alma.obsprep.ot.boEditors.EditorWithGridBagLayout;
import alma.obsprep.ot.editors.misc.CompactIsoDatePicker;
import alma.obsprep.ot.editors.sciencegoals.VisitConstraintListEditor;
import alma.obsprep.ot.editors.valuetypes.ValueUnitPairEditor;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.ot.models.sciencegoals.VisitConstraintsListModel;
import alma.obsprep.ot.models.valuetypes.AbstractValueUnitPairModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.EventObject;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;

public class VisitConstraintEditor
extends EditorWithGridBagLayout
implements TableCellEditor {
    private static final long serialVersionUID = -4606878953621068475L;
    protected transient ChangeEvent changeEvent = null;
    public static final FieldID START_TIME_FID = new FieldID("VisitConstraintEditor.startTime");
    public static final FieldID FIXED_START_FID = new FieldID("VisitConstraintEditor.isSpecificDateFID");
    public static final FieldID VISIT_ID_FID = new FieldID("VisitConstraintEditor.visitFID");
    public static final FieldID PREVIOUS_VISIT_FID = new FieldID("VisitConstraintEditor.previousVisitFID");
    public static final FieldID CLOSE_BUTTON_FID = new FieldID("VisitConstraintEditor.okButtonFID");
    public static final FieldID VISIT_CONSTRAINT_FID = new FieldID("VisitConstraintEditor.CurrentVisitConstraint");
    public static final String SPECIFIC_START_LABEL = "Specific Date";
    public static final String RELATIVE_START_LABEL = "Relative Date";
    public static final String ARBITRARY_START_LABEL = "Arbitrary Start";
    public static final String[] START_TYPE_OPTIONS = new String[]{"Specific Date", "Relative Date", "Arbitrary Start"};
    public static final String[] START_TYPE_LABELS = new String[]{"Requires a specific start time", "Schedule relative to a previous constraint", "Can be scheduled at any time"};
    private JComponent specificStartOptions = null;
    private JComponent relativeStartOptions = null;
    private OTButtonGroup isSelectedGrp = null;
    private OTComboBox previousVisitBox = null;
    private CompactIsoDatePicker dtPanel = null;
    private ValueUnitPairEditor vupMargin = null;
    private JComponent vupLabel = null;
    private UnitMap reasonableTimeUnits = UnitMap.getUnits((String)"BasicTime");

    public VisitConstraintEditor(Model model) {
        this.setModel(model);
        this.build();
        model.publish();
    }

    @Override
    protected void addComponents(String string) {
        VisitConstraintsListModel visitConstraintsListModel = (VisitConstraintsListModel)this.getModel();
        this.isSelectedGrp = this.makeOTButtonGroup(FIXED_START_FID, START_TYPE_OPTIONS, START_TYPE_LABELS);
        this.add(this.isSelectedGrp);
        this.setLayout(new BoxLayout(this, 2));
        this.add(Box.createHorizontalGlue());
        this.specificStartOptions = this.createSpecificStartOptions();
        this.add(this.specificStartOptions);
        this.relativeStartOptions = this.createRelativeStartOptions();
        this.add(this.relativeStartOptions);
        this.add(this.makeButton(CLOSE_BUTTON_FID, "Close", "Finishing editing"));
    }

    private boolean setFixedStart(boolean bl) {
        boolean bl2;
        VisitConstraintsListModel visitConstraintsListModel = (VisitConstraintsListModel)this.getModel();
        boolean bl3 = bl2 = visitConstraintsListModel.getCurrentVisitConstraint() != null && visitConstraintsListModel.getCurrentVisitConstraint().getVisitId() == 1;
        if (bl2) {
            this.isSelectedGrp.setSelectedItem(bl ? SPECIFIC_START_LABEL : ARBITRARY_START_LABEL);
            Enumeration<AbstractButton> enumeration = this.isSelectedGrp.getButtonGroup().getElements();
            while (enumeration.hasMoreElements()) {
                JRadioButton jRadioButton = (JRadioButton)enumeration.nextElement();
                boolean bl4 = jRadioButton.getText() != RELATIVE_START_LABEL;
                jRadioButton.setVisible(bl4);
            }
        } else {
            this.isSelectedGrp.setSelectedItem(bl ? SPECIFIC_START_LABEL : RELATIVE_START_LABEL);
            Enumeration<AbstractButton> enumeration = this.isSelectedGrp.getButtonGroup().getElements();
            while (enumeration.hasMoreElements()) {
                JRadioButton jRadioButton = (JRadioButton)enumeration.nextElement();
                boolean bl5 = jRadioButton.getText() != ARBITRARY_START_LABEL;
                jRadioButton.setVisible(bl5);
            }
        }
        return bl2;
    }

    public void makeYearFocus() {
        this.dtPanel.makeYearFocus();
    }

    private void displaySpecificStartComponents(boolean bl) {
        boolean bl2 = this.setFixedStart(bl);
        boolean bl3 = this.canSwitchBetweenFixedAndRelative(bl, bl2);
        this.isSelectedGrp.setEnabled(bl3);
        if (bl) {
            this.specificStartOptions.setVisible(true);
            this.relativeStartOptions.setVisible(false);
            this.dtPanel.makeYearFocus();
            return;
        }
        if (bl2) {
            this.specificStartOptions.setVisible(false);
            this.relativeStartOptions.setVisible(false);
            return;
        }
        this.specificStartOptions.setVisible(false);
        this.relativeStartOptions.setVisible(true);
    }

    private JComponent createSpecificStartOptions() {
        VisitConstraintsListModel visitConstraintsListModel = (VisitConstraintsListModel)this.getModel();
        JPanel jPanel = this.createNewGroup();
        jPanel.setLayout(new BoxLayout(jPanel, 2));
        jPanel.add(this.makeLabel("Date "));
        this.dtPanel = this.makeCompactIsoDateTimePanel(this, START_TIME_FID, "start time for monitoring visit", VisitConstraint.nowInUTC());
        jPanel.add(this.dtPanel);
        jPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        this.vupMargin = this.makeValueUnitPairEditor((AbstractValueUnitPairModel)visitConstraintsListModel.getAllowedMarginModel(), this.reasonableTimeUnits, "Allowed margin from the specified delay");
        this.vupLabel = this.makeLabel("<html>Margin (&plusmn;)</html>");
        jPanel.add(this.vupLabel);
        jPanel.add(this.vupMargin);
        int n = (int)this.vupMargin.getUnits().getPreferredSize().getHeight();
        this.dtPanel.setMaximumSize(new Dimension(640, (int)((double)n * 0.8)));
        this.vupMargin.getInput().setMaximumSize(new Dimension(500, (int)((double)n * 0.8)));
        return jPanel;
    }

    private ArrayList<String> getPreviousIds() {
        boolean bl;
        boolean bl2;
        VisitConstraintsListModel visitConstraintsListModel = (VisitConstraintsListModel)this.getModel();
        int n = visitConstraintsListModel.getArbitraryStartVisitID();
        boolean bl3 = bl2 = n == -1;
        if (bl2) {
            ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(visitConstraintsListModel.getValidPreviousVisitIds()));
            return arrayList;
        }
        VisitConstraint visitConstraint = visitConstraintsListModel.getCurrentVisitConstraint();
        boolean bl4 = bl = visitConstraint != null && n == visitConstraint.getVisitId();
        if (bl) {
            ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList("None"));
            return arrayList;
        }
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(visitConstraintsListModel.getValidPreviousVisitIds()));
        return arrayList;
    }

    private JComponent createRelativeStartOptions() {
        JPanel jPanel = this.createNewGroup();
        jPanel.setLayout(new BoxLayout(jPanel, 2));
        VisitConstraintsListModel visitConstraintsListModel = (VisitConstraintsListModel)this.getModel();
        jPanel.add(this.makeLabel("Delay"));
        jPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        ValueUnitPairEditor valueUnitPairEditor = this.makeValueUnitPairEditor((AbstractValueUnitPairModel)visitConstraintsListModel.getRequiredDelayModel(), this.reasonableTimeUnits, "Required delay after previous visit");
        this.previousVisitBox = new OTComboBox(this.getPreviousIds().toArray());
        this.initEvents(this.previousVisitBox, PREVIOUS_VISIT_FID);
        this.previousVisitBox.setToolTipText("select the id of a previous visit from the list");
        this.vupMargin = this.makeValueUnitPairEditor((AbstractValueUnitPairModel)visitConstraintsListModel.getAllowedMarginModel(), this.reasonableTimeUnits, "Allowed margin from the specified delay");
        this.vupLabel = this.makeLabel("<html>Margin (&plusmn;)</html>");
        int n = (int)this.vupMargin.getUnits().getPreferredSize().getHeight();
        int n2 = (int)((double)n * 0.8);
        this.previousVisitBox.getInput().setPreferredSize(new Dimension(50, n2));
        this.previousVisitBox.getInput().setMaximumSize(new Dimension(50, n2));
        this.vupMargin.getInput().setPreferredSize(new Dimension(50, n2));
        this.vupMargin.getUnits().setPreferredSize(new Dimension(70, n2));
        this.vupMargin.getInput().setMaximumSize(new Dimension(50, n2));
        this.vupMargin.getUnits().setMaximumSize(new Dimension(70, n2));
        valueUnitPairEditor.getInput().setPreferredSize(new Dimension(50, n2));
        valueUnitPairEditor.getUnits().setPreferredSize(new Dimension(70, n2));
        valueUnitPairEditor.getInput().setMaximumSize(new Dimension(50, n2));
        valueUnitPairEditor.getUnits().setMaximumSize(new Dimension(70, n2));
        jPanel.add(valueUnitPairEditor);
        jPanel.add(this.makeLabel("after visit"));
        jPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel.add(this.previousVisitBox);
        jPanel.add(this.vupLabel);
        jPanel.add(this.vupMargin);
        return jPanel;
    }

    @Override
    protected void build() {
        super.build("");
    }

    @Override
    public Object widgetUpdated(FieldID fieldID, Object object) {
        if (fieldID.equals(FIXED_START_FID)) {
            Boolean bl = object.toString().equals(SPECIFIC_START_LABEL);
            this.displaySpecificStartComponents(bl);
        } else if (fieldID.equals(START_TIME_FID)) {
            this.dtPanel.initDateTime((String)object);
        } else if (fieldID.equals(PREVIOUS_VISIT_FID)) {
            this.set2(this.previousVisitBox, object);
            if (((String)object).equals("0") && null != this.vupMargin) {
                this.vupMargin.setVisible(false);
                this.vupLabel.setVisible(false);
            } else {
                this.vupMargin.setVisible(true);
                this.vupLabel.setVisible(false);
            }
        } else if (fieldID.equals(CLOSE_BUTTON_FID)) {
            this.stopCellEditing();
        }
        return super.widgetUpdated(fieldID, object);
    }

    @Override
    public Object getCellEditorValue() {
        VisitConstraintsListModel visitConstraintsListModel = (VisitConstraintsListModel)this.getModel();
        return visitConstraintsListModel.getCurrentVisitConstraint();
    }

    @Override
    public boolean isCellEditable(EventObject eventObject) {
        return !(eventObject instanceof MouseEvent);
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        VisitConstraintsListModel visitConstraintsListModel = (VisitConstraintsListModel)this.getModel();
        if (object instanceof VisitConstraint) {
            VisitConstraint visitConstraint = (VisitConstraint)((Object)object);
            visitConstraintsListModel.setCurrentVisitConstraint((Object)visitConstraint);
            this.displaySpecificStartComponents(visitConstraint.getIsFixedStart());
            this.update(START_TIME_FID, visitConstraint.getStartTime());
            this.update(PREVIOUS_VISIT_FID, visitConstraint.getPreviousVisitId());
            return this;
        }
        return null;
    }

    @Override
    public boolean shouldSelectCell(EventObject eventObject) {
        return true;
    }

    @Override
    public boolean stopCellEditing() {
        this.fireEditingStopped();
        return true;
    }

    @Override
    public void cancelCellEditing() {
        this.fireEditingCanceled();
    }

    @Override
    public void addCellEditorListener(CellEditorListener cellEditorListener) {
        this.listenerList.add(CellEditorListener.class, cellEditorListener);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        this.listenerList.remove(CellEditorListener.class, cellEditorListener);
    }

    public CellEditorListener[] getCellEditorListeners() {
        return (CellEditorListener[])this.listenerList.getListeners(CellEditorListener.class);
    }

    protected void fireEditingStopped() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != CellEditorListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((CellEditorListener)objectArray[i + 1]).editingStopped(this.changeEvent);
        }
    }

    protected void fireEditingCanceled() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != CellEditorListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((CellEditorListener)objectArray[i + 1]).editingCanceled(this.changeEvent);
        }
    }

    @Override
    public void update(FieldID fieldID, Object object) {
        if (fieldID.equals(VisitConstraintListEditor.addTPFID)) {
            this.previousVisitBox.updateOptions(this.getPreviousIds());
        } else if (fieldID.equals(FIXED_START_FID)) {
            Boolean bl = object.toString().equals(SPECIFIC_START_LABEL);
            Boolean bl2 = object.toString().equals(ARBITRARY_START_LABEL);
            this.displaySpecificStartComponents(bl);
            boolean bl3 = this.canSwitchBetweenFixedAndRelative(bl, bl2);
            this.isSelectedGrp.setEnabled(bl3);
        } else if (fieldID.equals(PREVIOUS_VISIT_FID)) {
            boolean bl;
            this.previousVisitBox.updateOptions(this.getPreviousIds());
            boolean bl4 = bl = !object.equals("None") && !object.toString().equals("0");
            if (this.vupMargin != null) {
                this.vupMargin.setVisible(bl);
                this.vupLabel.setVisible(bl);
            }
            object = bl ? object : "None";
        } else if (fieldID.equals(START_TIME_FID)) {
            this.dtPanel.initDateTime((String)object);
        } else if (fieldID.equals(VisitConstraintListEditor.VISIT_CONSTRAINT_TABLE_FID)) {
            this.previousVisitBox.updateOptions(this.getPreviousIds());
        }
        super.update(fieldID, object);
    }

    private boolean canSwitchBetweenFixedAndRelative(Boolean bl, Boolean bl2) {
        boolean bl3;
        VisitConstraintsListModel visitConstraintsListModel = (VisitConstraintsListModel)this.getModel();
        VisitConstraint visitConstraint = visitConstraintsListModel.getCurrentVisitConstraint();
        boolean bl4 = visitConstraintsListModel.getArbitraryStartVisitID() == -1;
        boolean bl5 = visitConstraintsListModel.allButFirstRecordRelative();
        boolean bl6 = bl3 = visitConstraint.getVisitId() == 1;
        boolean bl7 = bl3 ? (bl2.booleanValue() ? bl5 : true) : (bl != false ? true : bl4);
        return bl7;
    }

    public static void main(String[] stringArray) {
        System.setProperty("otData.dir", "config\\otData");
        InitServices.initModelSupportClasses();
        JFrame jFrame = new JFrame("Visit Constraint Editor");
        jFrame.setDefaultCloseOperation(3);
        PerformanceParameters performanceParameters = PerformanceParametersData.createPerformanceParameters();
        VisitConstraintsListModel visitConstraintsListModel = new VisitConstraintsListModel(null);
        VisitConstraintEditor visitConstraintEditor = new VisitConstraintEditor(visitConstraintsListModel);
        visitConstraintsListModel.setDocument(performanceParameters);
        TestUtilities.runTestApp(visitConstraintEditor);
    }
}

