/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.models.schedblock;

import alma.obsprep.bo.annotations.SpectralWindowI;
import alma.obsprep.bo.schedblock.AbstractBaseBandConfig;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.ot.editors.misc.TabbedEditor;
import alma.obsprep.ot.editors.schedblock.SpectralWindowTabbedEditor;
import alma.obsprep.ot.models.misc.TabbedEditorWithSummaryTableModel;
import alma.obsprep.ot.models.schedblock.SpectralSpecModel;
import alma.obsprep.ot.models.schedblock.SpectralWindowModel;
import alma.obsprep.ot.models.schedblock.SpectralWindowTableModel;

public class SpectralWindowTabbedModel
extends TabbedEditorWithSummaryTableModel {
    private SpectralSpecModel ssm;

    public SpectralWindowTabbedModel(AbstractBaseBandConfig abstractBaseBandConfig) {
        super(abstractBaseBandConfig);
        super.setTableModel(new SpectralWindowTableModel(null));
        SpectralWindowModel spectralWindowModel = new SpectralWindowModel(null);
        this.setSubModel(spectralWindowModel);
        this.registerSubModel(spectralWindowModel);
        spectralWindowModel.getCenterFreqModel().subscribe(this);
    }

    public SpectralSpecModel getSpectralSpecModel() {
        if (this.ssm == null) {
            for (Model model = this.getParentModel(); model != null; model = model.getParentModel()) {
                if (!(model instanceof SpectralSpecModel)) continue;
                this.ssm = (SpectralSpecModel)model;
                break;
            }
        }
        return this.ssm;
    }

    public AbstractBaseBandConfig getBaseBandConfig() {
        return (AbstractBaseBandConfig)this.getDocument();
    }

    public SpectralWindowTableModel getSpectralWindowTableModel() {
        return (SpectralWindowTableModel)this.basebandConfigTableModel;
    }

    public void addSpectralWindowI(int n, SpectralWindowI spectralWindowI) {
        this.getBaseBandConfig().addSpectralWindow(n, spectralWindowI);
    }

    @Override
    public SpectralWindowI newBO() {
        return this.getBaseBandConfig().addNewSpectralWindow();
    }

    @Override
    public SpectralWindowI newBO(int n) {
        SpectralWindowI spectralWindowI = this.getBaseBandConfig().addNewSpectralWindow(n);
        this.publish();
        return spectralWindowI;
    }

    @Override
    public SpectralWindowI getBO(int n) {
        return this.getBaseBandConfig().getSpectralWindow(n);
    }

    @Override
    public void deleteBO(Object object) {
        this.getBaseBandConfig().removeSpectralWindow((SpectralWindowI)object);
        this.publish();
    }

    @Override
    public int getBOCount() {
        AbstractBaseBandConfig abstractBaseBandConfig = this.getBaseBandConfig();
        if (abstractBaseBandConfig == null) {
            return 0;
        }
        return abstractBaseBandConfig.getSpectralWindowCount();
    }

    @Override
    public void publish() {
        AbstractBaseBandConfig abstractBaseBandConfig = this.getBaseBandConfig();
        this.publish(SpectralWindowTabbedEditor.documentFID, abstractBaseBandConfig);
        if (abstractBaseBandConfig != null) {
            this.publish(TabbedEditor.FID_MULTIDOCUMENT, abstractBaseBandConfig);
        }
        this.getSpectralWindowTableModel().fireTableDataChanged();
    }

    @Override
    public Object update(Editor editor, FieldID fieldID, Object object) {
        return object;
    }

    @Override
    public void setDocument(Object object) {
        this.document = object;
        if (object != null) {
            AbstractBaseBandConfig abstractBaseBandConfig = this.getBaseBandConfig();
            this.getSpectralWindowTableModel().setBaseBandConfig(abstractBaseBandConfig);
        }
        this.publish();
    }

    @Override
    public void modelChanged(Model model, FieldID fieldID, Object object) {
        SpectralWindowModel spectralWindowModel;
        int n;
        super.modelChanged(model, fieldID, object);
        if (model == ((SpectralWindowModel)this.getSubModel()).getCenterFreqModel() && (n = (spectralWindowModel = (SpectralWindowModel)this.getSubModel()).getSpectralWindow().getSpectralWindowIndex()) != -1) {
            this.tableRowsUpdated(n);
        }
    }

    public void dataRateChanged() {
        this.getSpectralWindowTableModel().dataRateChanged();
    }
}

