/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.models.sciencegoals;

import alma.observatorycharacteristics.policies.AlmaPolicies;
import alma.obsprep.bo.obsproject.MonitoringConstraint;
import alma.obsprep.bo.obsproject.PerformanceParameters;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.ot.editors.sciencegoals.MonitoringConstraintEditor;
import alma.obsprep.ot.editors.sciencegoals.MonitoringConstraintListEditor;
import alma.obsprep.ot.editors.sciencegoals.MonitoringConstraintTableModel;
import alma.obsprep.ot.models.valuetypes.ValueUnitPairModel;
import alma.valuetypes.Time;

public class MonitoringConstraintsListModel
extends Model {
    private static final AlmaPolicies almaPolicies = AlmaPolicies.getInstance();
    private static final int DEFAULT_MARGIN = (int)(almaPolicies.getMinAdvisedTimeMargin().getContentInUnits(Time.UNIT_D) / 2.0);
    private MonitoringConstraint currentMonitoringConstraint = null;
    private MonitoringConstraintTableModel vcTableModel = null;
    private final ValueUnitPairModel lengthOfMonitoringModel = new ValueUnitPairModel();
    private final ValueUnitPairModel requiredDelayModel = new ValueUnitPairModel();
    private ValueUnitPairModel allowedMarginModel = new ValueUnitPairModel();

    public MonitoringConstraintsListModel(Object object) {
        super(object);
        this.vcTableModel = new MonitoringConstraintTableModel(this);
        this.registerSubModel(this.lengthOfMonitoringModel);
        this.registerSubModel(this.requiredDelayModel);
        this.registerSubModel(this.allowedMarginModel);
    }

    public PerformanceParameters getPerformanceParameters() {
        return (PerformanceParameters)this.getDocument();
    }

    public MonitoringConstraintTableModel getMonitoringConstraintsTableModel() {
        return this.vcTableModel;
    }

    public void clearMonitoringConstraintList() {
        this.setCurrentMonitoringConstraint(null);
        PerformanceParameters performanceParameters = this.getPerformanceParameters();
        if (performanceParameters == null) {
            return;
        }
        performanceParameters.clearMonitoringConstraint();
        this.fireTableDataChanged();
        this.publish();
    }

    @Override
    public void publish() {
        this.lengthOfMonitoringModel.publish();
        this.requiredDelayModel.publish();
        this.allowedMarginModel.publish();
        this.fireTableDataChanged();
        this.publish(MonitoringConstraintListEditor.tpCountLabelFID, this.getMonitoringConstraintCount());
        if (this.getMonitoringConstraintCount() > 0) {
            this.publish(MonitoringConstraintListEditor.MONITORING_CONSTRAINT_TABLE_FID, this.getPerformanceParameters().getMonitoringConstraint());
        }
    }

    private void fireTableDataChanged() {
        this.getMonitoringConstraintsTableModel().fireTableDataChanged();
    }

    @Override
    public void setDocument(Object object) {
        this.document = object;
        this.setCurrentMonitoringConstraint((Object)MonitoringConstraint.createMonitoringConstraint());
        this.vcTableModel.fireTableStructureChanged();
    }

    public void addMonitoringConstraint(int n) {
        this.setCurrentMonitoringConstraint((Object)MonitoringConstraint.createMonitoringConstraint());
        MonitoringConstraint monitoringConstraint = this.getCurrentMonitoringConstraint();
        monitoringConstraint.setIsFixedStart(false);
        monitoringConstraint.setMonitoringLength(Time.createTime((double)0.0, (String)Time.UNIT_MIN));
        monitoringConstraint.setAllowedMargin(Time.createTime((double)DEFAULT_MARGIN, (String)Time.UNIT_D));
        monitoringConstraint.setEndTime(null);
        if (this.getPerformanceParameters().getMonitoringConstraintCount() > 0) {
            MonitoringConstraint monitoringConstraint2 = this.getPerformanceParameters().getMonitoringConstraint(0);
            monitoringConstraint.setNote(monitoringConstraint2.getNote());
        }
        this.getPerformanceParameters().addMonitoringConstraint(n, monitoringConstraint);
        this.getMonitoringConstraintsTableModel().fireTableRowsInserted(n, n);
    }

    public MonitoringConstraint getMonitoringConstraint(int n) {
        return this.getPerformanceParameters().getMonitoringConstraint(n);
    }

    public void addVisit(MonitoringConstraint monitoringConstraint) {
        int n = this.getMonitoringConstraintCount();
        this.getPerformanceParameters().addMonitoringConstraint(n, monitoringConstraint);
        this.getMonitoringConstraintsTableModel().fireTableRowsInserted(n, n);
    }

    public void deleteMonitoringConstraint(int n) {
        if (n != -1) {
            MonitoringConstraint monitoringConstraint = this.getPerformanceParameters().getMonitoringConstraint(n);
            this.getPerformanceParameters().removeMonitoringConstraint(monitoringConstraint);
            this.getMonitoringConstraintsTableModel().fireTableRowsDeleted(n, n);
        }
    }

    private void swapParams(int n, int n2) {
        PerformanceParameters performanceParameters = this.getPerformanceParameters();
        if (performanceParameters != null) {
            MonitoringConstraint monitoringConstraint = performanceParameters.getMonitoringConstraint(n2);
            performanceParameters.removeMonitoringConstraint(monitoringConstraint);
            performanceParameters.addMonitoringConstraint(n, monitoringConstraint);
            this.getMonitoringConstraintsTableModel().fireTableRowsUpdated(n, n2);
        }
    }

    public void upMonitoringConstraints(int n) {
        if (n > 0) {
            this.swapParams(n - 1, n);
        }
    }

    public void downMonitoringConstraints(int n) {
        if (n != -1 && n < this.getMonitoringConstraintCount() - 1) {
            this.swapParams(n, n + 1);
        }
    }

    public int getMonitoringConstraintCount() {
        return this.document == null ? 0 : this.getPerformanceParameters().getMonitoringConstraintCount();
    }

    public int getMonitoringConstraintsTableRowCount() {
        MonitoringConstraintTableModel monitoringConstraintTableModel = this.getMonitoringConstraintsTableModel();
        return monitoringConstraintTableModel == null ? 0 : monitoringConstraintTableModel.getRowCount();
    }

    @Override
    public Object update(Editor editor, FieldID fieldID, Object object) {
        MonitoringConstraint monitoringConstraint = this.getCurrentMonitoringConstraint();
        switch (MonitoringConstraintEditor.EditorField.getByFieldID(fieldID)) {
            case FIXED_START_FID: {
                String string;
                boolean bl = object.toString().equals("Specific Date");
                monitoringConstraint.setIsFixedStart(bl);
                if (bl && (monitoringConstraint.getStartTime() == null || monitoringConstraint.getStartTime() == "")) {
                    string = MonitoringConstraint.convertDateToString(MonitoringConstraint.nowInUTC());
                    monitoringConstraint.setStartTime(string);
                }
                string = monitoringConstraint.getStartTime();
                this.publish(MonitoringConstraintEditor.EditorField.START_TIME_FID.getFieldID(), string);
                break;
            }
            case START_TIME_FID: {
                monitoringConstraint.setStartTime((String)object);
                break;
            }
        }
        return object;
    }

    public boolean isFixedStart() {
        MonitoringConstraint monitoringConstraint = this.getCurrentMonitoringConstraint();
        return null == monitoringConstraint ? false : monitoringConstraint.getIsFixedStart();
    }

    public void setCurrentMonitoringConstraint(Object object) {
        this.currentMonitoringConstraint = (MonitoringConstraint)((Object)object);
        if (this.currentMonitoringConstraint != null) {
            this.lengthOfMonitoringModel.setDocument(this.currentMonitoringConstraint.getMonitoringLength());
            this.allowedMarginModel.setDocument(this.currentMonitoringConstraint.getAllowedMargin());
            this.lengthOfMonitoringModel.publish();
            this.allowedMarginModel.publish();
        }
    }

    public void updateAssociatedeNote(String string) {
        MonitoringConstraint monitoringConstraint = this.getCurrentMonitoringConstraint();
        if (null != monitoringConstraint) {
            monitoringConstraint.setNote(string);
        }
    }

    public MonitoringConstraint getCurrentMonitoringConstraint() {
        return this.currentMonitoringConstraint;
    }

    public ValueUnitPairModel getLengthOfMonitoringModel() {
        return this.lengthOfMonitoringModel;
    }

    public ValueUnitPairModel getAllowedMarginModel() {
        return this.allowedMarginModel;
    }
}

