/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.valdef.others;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.bo.IBusinessObject;
import alma.obsprep.ot.valdef.AbstractValidator;
import alma.obsprep.ot.valdef.ProblemListModel;
import alma.obsprep.problems.DefaultProblem;
import alma.obsprep.problems.Problem;
import alma.valuetypes.Latitude;
import alma.valuetypes.Longitude;
import alma.valuetypes.SkyCoordinates;

public class SkyCoordinatesValidator
extends AbstractValidator {
    private static final double MIN_LAT = -90.0;
    private static final double MAX_LAT = 90.0;
    private static final double MIN_LON = 0.0;
    private static final double MAX_LON = 360.0;
    private static final double MIN_GALLON = -180.0;
    private static final double MAX_GALLON = 180.0;

    @Override
    public void localValidate(BusinessObject businessObject, ProblemListModel problemListModel) {
        Problem problem;
        SkyCoordinates skyCoordinates = (SkyCoordinates)businessObject;
        Latitude latitude = skyCoordinates.getLatitude();
        Longitude longitude = skyCoordinates.getLongitude();
        double d = latitude.getContentInUnits(Latitude.UNIT_DEG);
        if (d < -90.0) {
            problem = DefaultProblem.createError("Latitude is less than -90.0 degrees", "Navigate to the latitude and correct the value ", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
        if (d > 90.0) {
            problem = DefaultProblem.createError("Latitude is greater than 90.0 degrees", "Navigate to the latitude and correct the value ", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
        double d2 = skyCoordinates.isGalactic() ? -180.0 : 0.0;
        double d3 = skyCoordinates.isGalactic() ? -180.0 : 0.0;
        double d4 = longitude.getContentInUnits(Longitude.UNIT_DEG);
        if (d4 < d2) {
            problem = DefaultProblem.createError("Longitude is less than " + d2 + " degrees", "Navigate to the longitude and correct the value ", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
        if (d4 > d3) {
            problem = DefaultProblem.createError("Longitude is greater than " + d3 + " degrees", "Navigate to the longitude and correct the value ", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
    }
}

