/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.experts.spectralline.gui.filters;

import alma.obsprep.services.experts.spectralline.SpectralLine;
import ca.odell.glazedlists.matchers.AbstractMatcherEditor;
import ca.odell.glazedlists.matchers.Matcher;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MaximumUpperStateEnergyMatcherEditor
extends AbstractMatcherEditor<SpectralLine>
implements ChangeListener {
    private final JSlider slider;

    public MaximumUpperStateEnergyMatcherEditor(JSlider jSlider) {
        this.slider = jSlider;
        jSlider.addChangeListener(this);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        Double d = this.slider.getValue();
        this.fireChanged(new MaximumUpperStateEnergyMatcher(d));
    }

    private static class MaximumUpperStateEnergyMatcher
    implements Matcher<SpectralLine> {
        private final Double threshold;

        public MaximumUpperStateEnergyMatcher(Double d) {
            this.threshold = d;
        }

        public boolean matches(SpectralLine spectralLine) {
            if (this.threshold > 100.0) {
                return true;
            }
            Double d = spectralLine.getUpperStateEnergy();
            if (d == null) {
                return false;
            }
            return d < this.threshold;
        }
    }
}

