/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator;

import alma.obsprep.bo.schedblock.AmplitudeCalParameters;
import alma.obsprep.bo.schedblock.CalibratorParameters;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.services.generator.AbstractCalibratorParametersFactory;
import alma.valuetypes.Time;

public class CalibratorSurveyCalibratorParametersFactory
extends AbstractCalibratorParametersFactory {
    private final Time targetIntegrationTime;

    public CalibratorSurveyCalibratorParametersFactory(SpectralSpec spectralSpec, Time time) {
        super(spectralSpec);
        this.targetIntegrationTime = time.deepCopy();
    }

    @Override
    public AmplitudeCalParameters getAmplitudeCalParameters(int n) {
        AmplitudeCalParameters amplitudeCalParameters = super.getAmplitudeCalParameters(n);
        if (n == 2) {
            amplitudeCalParameters.setCycleTime(Time.createTime((double)99999.0, (String)Time.UNIT_H));
            amplitudeCalParameters.setName("Survey Target Amplitude Parameters");
            amplitudeCalParameters.setDefaultIntegrationTime(this.targetIntegrationTime.deepCopy());
            amplitudeCalParameters.setSubScanDuration(Time.createTimeSec(0.0));
        }
        this.setMissingParameters((CalibratorParameters)((Object)amplitudeCalParameters), n);
        return amplitudeCalParameters;
    }
}

