/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator;

import alma.obsprep.bo.schedblock.PointingCalParameters;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.services.generator.AbstractCalibratorParametersFactory;
import alma.valuetypes.Time;

public class RadiometricPointingCalibratorParametersFactory
extends AbstractCalibratorParametersFactory {
    protected final Time targetIntegrationTime;

    public RadiometricPointingCalibratorParametersFactory(SpectralSpec spectralSpec, Time time) {
        super(spectralSpec);
        this.targetIntegrationTime = time.deepCopy();
    }

    @Override
    public PointingCalParameters getPointingCalParameters(int n) {
        PointingCalParameters pointingCalParameters = super.getPointingCalParameters(n);
        if (n == 2) {
            pointingCalParameters.setDefaultIntegrationTime(this.targetIntegrationTime.deepCopy());
            double d = this.targetIntegrationTime.getContentInUnits(Time.UNIT_S);
            double d2 = this.integrationTime.getContentInUnits(Time.UNIT_S);
            double d3 = this.correlatorExpert.calcSubscanDuration(d, d2, pointingCalParameters.getPointingMethod());
            pointingCalParameters.setSubScanDuration(Time.createTime((double)d3, (String)Time.UNIT_S));
            pointingCalParameters.setCycleTime(Time.createTime((double)99999.0, (String)Time.UNIT_H));
            pointingCalParameters.setMaximumElapsedTime(Time.createTime((double)99999.0, (String)Time.UNIT_H));
        }
        return pointingCalParameters;
    }
}

