/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored;

import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.enumerations.Antenna;
import alma.obsprep.bo.enumerations.Array;
import alma.obsprep.bo.obsproject.Rectangle;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.schedblock.FieldPattern;
import alma.obsprep.bo.schedblock.FieldSource;
import alma.obsprep.bo.schedblock.FillPattern;
import alma.obsprep.bo.schedblock.RectanglePattern;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.ScienceParameters;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.services.etc.ETCTimeCalculator;
import alma.obsprep.services.etc.ObservingTimeCalculator;
import alma.obsprep.services.etc.SourceNeverVisibleException;
import alma.obsprep.services.experts.InvalidFrequencyException;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.services.generator.refactored.ScienceGoalSchedBlockGenerator;
import alma.valuetypes.Angle;
import alma.valuetypes.Frequency;
import alma.valuetypes.Latitude;
import alma.valuetypes.Longitude;
import alma.valuetypes.Sensitivity;
import alma.valuetypes.Time;
import alma.valuetypes.UserSensitivity;
import java.util.ArrayList;
import lombok.NonNull;

public class ScienceParametersSensitivityCalculator {
    private Sensitivity getSensitivityForACA7m(@NonNull ObservingTimeCalculator observingTimeCalculator, @NonNull Target target, @NonNull Frequency frequency, double d, @NonNull SchedBlock schedBlock) throws ScienceGoalSchedBlockGenerator.UnableToDetermineSensitivityException, InvalidFrequencyException, SourceNeverVisibleException, InvalidObsProgramParametersException {
        Time time;
        if (observingTimeCalculator == null) {
            throw new NullPointerException("observingTimeCalculator is marked non-null but is null");
        }
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        if (frequency == null) {
            throw new NullPointerException("repFreq is marked non-null but is null");
        }
        if (schedBlock == null) {
            throw new NullPointerException("sb is marked non-null but is null");
        }
        TargetParameters targetParameters = target.getFieldSource().getTargetParameters();
        if (targetParameters == null) {
            throw new ScienceGoalSchedBlockGenerator.UnableToDetermineSensitivityException("keyTargetParameters has not been specified");
        }
        int n = targetParameters.getNumberOfPointings();
        FieldPattern.FieldPatternType fieldPatternType = targetParameters.getFieldPatternType();
        Sensitivity sensitivity = switch (fieldPatternType) {
            case FieldPattern.FieldPatternType.POINT -> {
                int var8_9 = target.getFieldSource().getNumberOfPointings();
                ScienceGoal var13_11 = schedBlock.getSbGenerationContext().getGoal();
                time = var13_11.getPerformanceParameters().getNeedsMoreTime() ? (Time)var13_11.getPerformanceParameters().getDesiredTime().multiply(d) : (Time)((Time)((Time)observingTimeCalculator.singlePointOnSourceTime(Array.ARRAY_12M, targetParameters, false, ETCTimeCalculator.CorrelatorModeConversionEnum.NoCorrelatorConversion).multiply(d)).multiply(n)).divide(var8_9);
                yield observingTimeCalculator.singlePointOnSourceSensitivity(RequestedArray.SEVEN_M.getArray(), time, targetParameters, frequency, ETCTimeCalculator.CorrelatorModeConversionEnum.NoCorrelatorConversion);
            }
            case FieldPattern.FieldPatternType.RECTANGLE -> {
                Rectangle var14_15 = targetParameters.getFieldRectangle()[0];
                int var8_10 = var14_15.getNumberOfPointings(Array.ARRAY_7M);
                ScienceGoal var13_12 = schedBlock.getSbGenerationContext().getGoal();
                time = var13_12.getPerformanceParameters().getNeedsMoreTime() ? (Time)var13_12.getPerformanceParameters().getDesiredTime().multiply(d) : (Time)((Time)((Time)observingTimeCalculator.singlePointOnSourceTime(Array.ARRAY_12M, targetParameters, false, ETCTimeCalculator.CorrelatorModeConversionEnum.NoCorrelatorConversion).multiply(n)).multiply(d)).divide(var8_10);
                yield observingTimeCalculator.singlePointOnSourceSensitivity(RequestedArray.SEVEN_M.getArray(), time, targetParameters, frequency, ETCTimeCalculator.CorrelatorModeConversionEnum.NoCorrelatorConversion);
            }
            default -> throw new IllegalArgumentException("Unsupported field type defined: " + String.valueOf((Object)fieldPatternType));
        };
        Log.logger(this.getClass()).fine(String.format("Sensitivity for ACA 7-m for an integration time of %s for a sky freq of %s and a declination of %s is %s", time.toString(), frequency.toString(), targetParameters.getSourceCoordinates().getLatitude().toString(), sensitivity.toString()));
        return sensitivity;
    }

    private Sensitivity getSensitivityForTM(@NonNull RequestedArray requestedArray, @NonNull ObservingTimeCalculator observingTimeCalculator, @NonNull Target target, @NonNull Frequency frequency, double d, SchedBlock schedBlock) throws ScienceGoalSchedBlockGenerator.UnableToDetermineSensitivityException, InvalidFrequencyException, SourceNeverVisibleException, InvalidObsProgramParametersException {
        if (requestedArray == null) {
            throw new NullPointerException("arrayRequested is marked non-null but is null");
        }
        if (observingTimeCalculator == null) {
            throw new NullPointerException("observingTimeCalculator is marked non-null but is null");
        }
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        if (frequency == null) {
            throw new NullPointerException("repFreq is marked non-null but is null");
        }
        TargetParameters targetParameters = target.getFieldSource().getTargetParameters();
        if (targetParameters == null) {
            throw new ScienceGoalSchedBlockGenerator.UnableToDetermineSensitivityException("keyTargetParameters has not been specified");
        }
        ScienceGoal scienceGoal = schedBlock.getSbGenerationContext().getGoal();
        Time time = scienceGoal.getPerformanceParameters().getNeedsMoreTime() ? (Time)scienceGoal.getPerformanceParameters().getDesiredTime().multiply(d) : (Time)observingTimeCalculator.singlePointOnSourceTime(Array.ARRAY_12M, targetParameters, false, ETCTimeCalculator.CorrelatorModeConversionEnum.NoCorrelatorConversion).multiply(d);
        assert (time != null);
        Sensitivity sensitivity = observingTimeCalculator.singlePointOnSourceSensitivity(requestedArray.getArray(), time, targetParameters, frequency, ETCTimeCalculator.CorrelatorModeConversionEnum.NoCorrelatorConversion);
        Log.logger(ScienceGoalSchedBlockGenerator.class).fine(String.format("Sensitivity for array %s for an integration time of %s for a sky freq of %s and a declination of %s is %s", requestedArray.getArray().toString(), time.toString(), frequency.toString(), targetParameters.getSourceCoordinates().getLatitude().toString(), sensitivity.toString()));
        return sensitivity;
    }

    @Deprecated(since="OBSPREP-2024JUN", forRemoval=false)
    private Sensitivity getTPAmpCalSBSensitivity(@NonNull RequestedArray requestedArray, @NonNull ObservingTimeCalculator observingTimeCalculator, int n, @NonNull Target target, @NonNull ScienceParameters scienceParameters, Frequency frequency) throws ScienceGoalSchedBlockGenerator.UnableToDetermineSensitivityException, InvalidFrequencyException, SourceNeverVisibleException {
        if (requestedArray == null) {
            throw new NullPointerException("arrayRequested is marked non-null but is null");
        }
        if (observingTimeCalculator == null) {
            throw new NullPointerException("observingTimeCalculator is marked non-null but is null");
        }
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        if (scienceParameters == null) {
            throw new NullPointerException("scienceParameters is marked non-null but is null");
        }
        TargetParameters targetParameters = target.getFieldSource().getQuerySource().getKeyTargetParameters();
        if (targetParameters == null) {
            throw new ScienceGoalSchedBlockGenerator.UnableToDetermineSensitivityException("keyTargetParameters has not been specified");
        }
        RectanglePattern rectanglePattern = (RectanglePattern)((Object)target.getFieldSource().getFieldPattern());
        double d = rectanglePattern.getLatitudeLength().getContentInUnits(Latitude.UNIT_ARCSEC) * rectanglePattern.getLongitudeLength().getContentInUnits(Longitude.UNIT_ARCSEC);
        Angle angle = Antenna.ANTENNA_12M.getBeamArea(frequency);
        assert (angle != null);
        Time time = (Time)((Time)scienceParameters.getIntegrationTime().getTime().multiply(n)).divide(d / angle.getContentInUnits(Angle.UNIT_ARCSEC));
        assert (time != null);
        Sensitivity sensitivity = observingTimeCalculator.singlePointOnSourceSensitivity(requestedArray.getArray(), time, targetParameters, frequency, ETCTimeCalculator.CorrelatorModeConversionEnum.Convert4BitModeTo2Bit);
        Log.logger(ScienceGoalSchedBlockGenerator.class).fine(String.format("Sensitivity for array %s for an integration time of %s for a sky freq of %s and a declination of %s is %s", requestedArray.getArray().toString(), time.toString(), frequency.toString(), targetParameters.getSourceCoordinates().getLatitude().toString(), sensitivity.toString()));
        return sensitivity;
    }

    private Sensitivity getTPScienceSBSensitivity(@NonNull RequestedArray requestedArray, @NonNull ObservingTimeCalculator observingTimeCalculator, @NonNull Target target, @NonNull Frequency frequency, double d, @NonNull SchedBlock schedBlock) throws ScienceGoalSchedBlockGenerator.UnableToDetermineSensitivityException, InvalidFrequencyException, SourceNeverVisibleException, InvalidObsProgramParametersException {
        Object object;
        int n;
        if (requestedArray == null) {
            throw new NullPointerException("arrayRequested is marked non-null but is null");
        }
        if (observingTimeCalculator == null) {
            throw new NullPointerException("observingTimeCalculator is marked non-null but is null");
        }
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        if (frequency == null) {
            throw new NullPointerException("repFreq is marked non-null but is null");
        }
        if (schedBlock == null) {
            throw new NullPointerException("sb is marked non-null but is null");
        }
        int n2 = schedBlock.getSchedBlockControl().getExecutionCount();
        FieldSource fieldSource = target.getFieldSource();
        TargetParameters targetParameters = fieldSource.getTargetParameters();
        if (targetParameters == null) {
            throw new ScienceGoalSchedBlockGenerator.UnableToDetermineSensitivityException("keyTargetParameters has not been specified");
        }
        ScienceGoal scienceGoal = schedBlock.getSbGenerationContext().getGoal();
        Array array = scienceGoal.getPrincipalActualArray();
        FieldPattern.FieldPatternType fieldPatternType = targetParameters.getFieldPatternType();
        if (fieldPatternType.equals((Object)FieldPattern.FieldPatternType.POINT)) {
            n = targetParameters.getNumberOfPointings();
        } else if (fieldPatternType.equals((Object)FieldPattern.FieldPatternType.RECTANGLE)) {
            object = targetParameters.getFieldRectangle()[0];
            n = ((Rectangle)object).getNumberOfPointings(array);
        } else {
            throw new RuntimeException("Unsupported field type found: " + String.valueOf((Object)fieldPatternType));
        }
        object = scienceGoal.getPerformanceParameters().getNeedsMoreTime() ? (Time)scienceGoal.getPerformanceParameters().getDesiredTime().multiply(d) : (Time)((Time)observingTimeCalculator.singlePointOnSourceTime(array, targetParameters, false, ETCTimeCalculator.CorrelatorModeConversionEnum.Convert4BitModeTo2Bit).multiply(d)).multiply(n);
        Sensitivity sensitivity = observingTimeCalculator.singlePointOnSourceSensitivity(requestedArray.getArray(), (Time)object, targetParameters, frequency, ETCTimeCalculator.CorrelatorModeConversionEnum.Convert4BitModeTo2Bit);
        double d2 = Antenna.ANTENNA_12M.getBeamSize(frequency).getArcsec();
        double d3 = Math.PI * Math.pow(d2 / 2.0, 2.0);
        FieldPattern fieldPattern = fieldSource.getFieldPattern();
        double d4 = 0.0;
        double d5 = 0.0;
        if (fieldPattern instanceof RectanglePattern) {
            RectanglePattern rectanglePattern = (RectanglePattern)((Object)fieldPattern);
            d4 = rectanglePattern.getLatitudeLength().getArcsec();
            d5 = rectanglePattern.getLongitudeLength().getArcsec();
        } else if (fieldPattern instanceof FillPattern) {
            FillPattern fillPattern = (FillPattern)((Object)fieldPattern);
            d4 = fillPattern.getLatitudeLength().getArcsec();
            d5 = fillPattern.getLongitudeLength().getArcsec();
        } else {
            throw new WizardSBGenerationException("Unknown field pattern detected " + fieldPattern.getShortClassName());
        }
        double d6 = d4 * d5;
        Sensitivity sensitivity2 = (Sensitivity)sensitivity.multiply(1.24 * Math.sqrt(d6 / d3));
        double d7 = Math.min(d4, d5);
        double d8 = target.getFieldSource().getReference(0).getSubScanDuration().getSecs();
        double d9 = target.getFirstScienceParameters().orElseThrow(() -> new WizardSBGenerationException("Unable to find science parameters")).getSubScanDuration().getSecs();
        Sensitivity sensitivity3 = (Sensitivity)sensitivity.multiply(1.19 * Math.sqrt(d7 / d2) * Math.sqrt(d9 / d8));
        double d10 = sensitivity2.getContentInUnits(Sensitivity.UNIT_MJY);
        double d11 = sensitivity3.getContentInUnits(Sensitivity.UNIT_MJY);
        Sensitivity sensitivity4 = Sensitivity.createSensitivity((double)Math.sqrt(Math.pow(d10, 2.0) + Math.pow(d11, 2.0)), (String)Sensitivity.UNIT_MJY);
        if (Log.logger(ScienceGoalSchedBlockGenerator.class).fine()) {
            Log.logger(ScienceGoalSchedBlockGenerator.class).fine(String.format("Sensitivity for array %s for an integration time of %s for a sky freq of %s and a declination of %s is %s", requestedArray.getArray().toString(), ((Time)object).toString(), frequency.toString(), targetParameters.getSourceCoordinates().getLatitude().toString(), sensitivity4.toString()));
            Log.logger(ScienceParametersSensitivityCalculator.class).fine("keyTargetParameters: " + targetParameters.getSourceName());
            Log.logger(ScienceParametersSensitivityCalculator.class).fine("repFreq: " + String.valueOf((Object)frequency));
            Log.logger(ScienceParametersSensitivityCalculator.class).fine("noOfPointings: " + n);
            Log.logger(ScienceParametersSensitivityCalculator.class).fine("beamSize_arcsec: " + d2);
            Log.logger(ScienceParametersSensitivityCalculator.class).fine("beamArea_arcsec: " + d3);
            Log.logger(ScienceParametersSensitivityCalculator.class).fine("tpIntegrationTime: " + String.valueOf(object));
            Log.logger(ScienceParametersSensitivityCalculator.class).fine("latitude_arcsec: " + d4);
            Log.logger(ScienceParametersSensitivityCalculator.class).fine("longitude_arcsec: " + d5);
            Log.logger(ScienceParametersSensitivityCalculator.class).fine("tpMapArea_arcsec: " + d6);
            Log.logger(ScienceParametersSensitivityCalculator.class).fine("sigma_on: " + String.valueOf((Object)sensitivity2));
            Log.logger(ScienceParametersSensitivityCalculator.class).fine("TP_map_length_short_arcsec: " + d7);
            Log.logger(ScienceParametersSensitivityCalculator.class).fine("referenceSubscan_s: " + d8);
            Log.logger(ScienceParametersSensitivityCalculator.class).fine("sourceSubscan_s: " + d9);
            Log.logger(ScienceParametersSensitivityCalculator.class).fine("sigma_off: " + String.valueOf((Object)sensitivity3));
            Log.logger(ScienceParametersSensitivityCalculator.class).fine("sigma_off_mJy: " + d11);
            Log.logger(ScienceParametersSensitivityCalculator.class).fine("sigma_on_mJy: " + d10);
            Log.logger(ScienceParametersSensitivityCalculator.class).fine("etcSensitivity: " + String.valueOf((Object)sensitivity));
            Log.logger(ScienceParametersSensitivityCalculator.class).fine("sensitivity: " + String.valueOf((Object)sensitivity4));
            Log.logger(ScienceParametersSensitivityCalculator.class).fine("antennaRelatedTOSTimeMultiplierUsed: " + d);
            Log.logger(ScienceParametersSensitivityCalculator.class).fine("sbExecutionCount: " + n2);
        }
        return sensitivity4;
    }

    void setScienceParametersSensitivity(@NonNull SchedBlock schedBlock, @NonNull RequestedArray requestedArray, @NonNull ObservingTimeCalculator observingTimeCalculator, @NonNull ScienceGoal scienceGoal, @NonNull ScienceGoal scienceGoal2) throws ScienceGoalSchedBlockGenerator.UnableToDetermineSensitivityException {
        if (schedBlock == null) {
            throw new NullPointerException("sb is marked non-null but is null");
        }
        if (requestedArray == null) {
            throw new NullPointerException("arrayRequested is marked non-null but is null");
        }
        if (observingTimeCalculator == null) {
            throw new NullPointerException("observingTimeCalculator is marked non-null but is null");
        }
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        if (scienceGoal2 == null) {
            throw new NullPointerException("userDefinedScienceGoal is marked non-null but is null");
        }
        int n = schedBlock.getSchedBlockControl().getExecutionCount();
        boolean bl = scienceGoal.isStandAloneACA();
        ArrayList<ScienceParameters> arrayList = new ArrayList<ScienceParameters>();
        for (Target target : schedBlock.getAllTargets(ScienceParameters.scienceParametersFilter)) {
            Sensitivity sensitivity;
            ScienceParameters scienceParameters = target.getFirstScienceParameters().orElseThrow(() -> new WizardSBGenerationException("Unable to find science parameters"));
            if (arrayList.contains((Object)scienceParameters)) continue;
            try {
                boolean bl2;
                Frequency frequency = scienceGoal2.getPerformanceParameters().getRepresentativeFrequency();
                FieldPattern fieldPattern = target.getFieldSource().getFieldPattern();
                assert (fieldPattern != null);
                double d = schedBlock.getSbGenerationContext().getAntennaRelatedTOSTimeMultiplier();
                boolean bl3 = scienceGoal.getPerformanceParameters().getDesiredSensitivity().inTemperatureUnit();
                boolean bl4 = bl && schedBlock.isACA7mArraySB();
                boolean bl5 = bl2 = !bl3 && schedBlock.is12mExtendedArraySB();
                if (bl4 || bl2) {
                    UserSensitivity userSensitivity = scienceGoal.getPerformanceParameters().getDesiredSensitivity();
                    String string = userSensitivity.getFriendlyUnit();
                    sensitivity = Sensitivity.createSensitivity((double)userSensitivity.getContentInUnits(string), (String)string);
                } else {
                    sensitivity = schedBlock.isTotalPowerAmpcalSB() ? this.getTPAmpCalSBSensitivity(requestedArray, observingTimeCalculator, n, target, scienceParameters, frequency) : (schedBlock.isTotalPowerScienceSB() ? this.getTPScienceSBSensitivity(requestedArray, observingTimeCalculator, target, frequency, d, schedBlock) : (schedBlock.isACA7mArraySB() ? this.getSensitivityForACA7m(observingTimeCalculator, target, frequency, d, schedBlock) : this.getSensitivityForTM(requestedArray, observingTimeCalculator, target, frequency, d, schedBlock)));
                }
            }
            catch (SourceNeverVisibleException | InvalidFrequencyException | InvalidObsProgramParametersException exception) {
                Log.logger(ScienceGoalSchedBlockGenerator.class).warning("Unable to determine sensitivity from integration time");
                continue;
            }
            assert (sensitivity != null);
            Log.logger(ScienceGoalSchedBlockGenerator.class).fine("Sensitivity calculated from science integration time : " + String.valueOf((Object)sensitivity));
            scienceParameters.setSensitivityGoal(sensitivity);
            arrayList.add(scienceParameters);
        }
    }
}

