/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.losolutions.wrappers;

import alma.Control.LO2Parameters;
import alma.obsprep.bo.enumerations.NetSideBand;
import alma.valuetypes.Frequency;

public class LO2ParametersWrapper {
    private Frequency dYTOFrequency;
    private Frequency fTSFrequency;
    private boolean tuneHigh;
    private NetSideBand skyFreqSideband;
    private boolean isUsed;
    private Frequency iFFrequency;
    private Frequency lO2Frequency;
    private Frequency lsbSkyFrequency;
    private Frequency usbSkyFrequency;

    public LO2ParametersWrapper() {
    }

    public LO2ParametersWrapper(LO2Parameters lO2Parameters) {
        this();
        this.importNativeLO2Parameters(lO2Parameters);
    }

    public void importNativeLO2Parameters(LO2Parameters lO2Parameters) {
        this.getDYTOFrequency().setContentInGHz(lO2Parameters.DYTOFrequency / 1.0E9);
        this.getFTSFrequency().setContentInMHz(lO2Parameters.FTSFrequency / 1000000.0);
        this.setTuneHigh(lO2Parameters.tuneHigh);
        switch (lO2Parameters.skyFreqSideband.value()) {
            case 1: {
                this.setSkyFreqSideband(NetSideBand.LSB);
                break;
            }
            case 0: {
                this.setSkyFreqSideband(NetSideBand.USB);
                break;
            }
            case 2: {
                this.setSkyFreqSideband(NetSideBand.DSB);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected skyFreqSideband : " + String.valueOf(lO2Parameters.skyFreqSideband));
            }
        }
        this.setIsUsed(lO2Parameters.isUsed);
    }

    public Frequency getDYTOFrequency() {
        if (this.dYTOFrequency == null) {
            this.dYTOFrequency = Frequency.createFrequency();
        }
        return this.dYTOFrequency;
    }

    public void setDYTOFrequency(Frequency frequency) {
        this.dYTOFrequency = frequency;
    }

    public Frequency getFTSFrequency() {
        if (this.fTSFrequency == null) {
            this.fTSFrequency = Frequency.createFrequency();
        }
        return this.fTSFrequency;
    }

    public void setFTSFrequency(Frequency frequency) {
        this.fTSFrequency = frequency;
    }

    public boolean getTuneHigh() {
        return this.tuneHigh;
    }

    public void setTuneHigh(boolean bl) {
        this.tuneHigh = bl;
    }

    public NetSideBand getSkyFreqSideband() {
        return this.skyFreqSideband;
    }

    public void setSkyFreqSideband(NetSideBand netSideBand) {
        this.skyFreqSideband = netSideBand;
    }

    public boolean getIsUsed() {
        return this.isUsed;
    }

    public void setIsUsed(boolean bl) {
        this.isUsed = bl;
    }

    public Frequency getIFFrequency() {
        return this.iFFrequency;
    }

    public void setIFFrequency(Frequency frequency) {
        this.iFFrequency = frequency;
    }

    public Frequency getLO2Frequency() {
        return this.lO2Frequency;
    }

    public void setLO2Frequency(Frequency frequency) {
        this.lO2Frequency = frequency;
    }

    public Frequency getLSBSkyFrequency() {
        return this.lsbSkyFrequency;
    }

    public void setLSBSkyFrequency(Frequency frequency) {
        this.lsbSkyFrequency = frequency;
    }

    public Frequency getUSBSkyFrequency() {
        return this.usbSkyFrequency;
    }

    public void setUSBSkyFrequency(Frequency frequency) {
        this.usbSkyFrequency = frequency;
    }
}

