/*
 * Decompiled with CFR 0.152.
 */
package jsky.image.graphics;

import diva.canvas.CanvasLayer;
import diva.canvas.VisibleComponent;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jsky.coords.CoordinateConverter;
import jsky.coords.DMS;
import jsky.coords.HMS;
import jsky.image.graphics.ContourPlot;
import jsky.image.gui.MainImageDisplay;

public class CoordsGridLayer
extends CanvasLayer
implements VisibleComponent {
    boolean polar = false;
    protected final int NSKIP = 10;
    private MainImageDisplay imageDisplay;
    private ContourPlot contour = new ContourPlot();
    private boolean visible = false;

    public void setImageDisplay(MainImageDisplay imageDisplay) {
        this.imageDisplay = imageDisplay;
    }

    public void paint(Graphics2D g) {
        this.paintGrid(g);
    }

    public void paint(Graphics2D g, Rectangle2D region) {
        this.paintGrid(g);
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean b) {
        this.visible = b;
    }

    public void paintGrid(Graphics2D g) {
        if (!this.isVisible() || !this.imageDisplay.isWCS()) {
            return;
        }
        boolean isGalactic = this.imageDisplay.getCoordSystem().equals((Object)MainImageDisplay.CoordSystemType.GALACTIC);
        Point2D size = this.getCanvasPane().getSize();
        Dimension d = new Dimension((int)size.getX(), (int)size.getY());
        int x = (int)size.getX();
        int y = (int)size.getY();
        int nx = x / 10 + 1;
        int ny = y / 10 + 1;
        double[][] lon = new double[ny][nx];
        double[][] lat = new double[ny][nx];
        ArrayList<Double> lonLevels = new ArrayList<Double>();
        ArrayList<Double> latLevels = new ArrayList<Double>();
        this.calcCoords(lon, lat, lonLevels, latLevels);
        double[] lonArr = new double[lonLevels.size()];
        String[] lonLabels = new String[lonLevels.size()];
        for (int i = 0; i < lonArr.length; ++i) {
            lonArr[i] = (Double)lonLevels.get(i);
            double v = lonArr[i] >= 0.0 ? lonArr[i] : lonArr[i] + 360.0;
            lonLabels[i] = isGalactic ? String.format("%+3.5g", v) : new HMS(v / 15.0).toString();
        }
        double[] latArr = new double[latLevels.size()];
        String[] latLabels = new String[latLevels.size()];
        for (int i = 0; i < latArr.length; ++i) {
            latArr[i] = (Double)latLevels.get(i);
            latLabels[i] = isGalactic ? String.format("%+3.5g", latArr[i]) : new DMS(latArr[i]).toString();
        }
        if (this.polar) {
            this.drawRadial(g);
        } else {
            this.contour.setData(lon, lonArr, lonLabels);
            this.contour.paint(g, d);
        }
        this.contour.setData(lat, latArr, latLabels);
        this.contour.paint(g, d);
    }

    private void calcCoords(double[][] lon, double[][] lat, List<Double> lonLevels, List<Double> latLevels) {
        CoordinateConverter converter = this.imageDisplay.getCoordinateConverter();
        Point2D size = this.getCanvasPane().getSize();
        int nx = lon[0].length;
        int ny = lon.length;
        for (int iy = 0; iy < ny; ++iy) {
            for (int ix = 0; ix < nx; ++ix) {
                int x = (int)size.getX() * ix / (nx - 1);
                int y = (int)size.getY() * iy / (ny - 1);
                Point2D.Double p = new Point2D.Double(x, y);
                converter.screenToWorldCoords(p, false);
                double plon = p.getX();
                double plat = p.getY();
                lon[iy][ix] = plon;
                lat[iy][ix] = plat;
            }
        }
        this.calcLevels(lon, lonLevels, true);
        this.calcLevels(lat, latLevels, false);
    }

    private void drawRadial(Graphics g) {
        int ix;
        double[] levels = new double[]{0.0, 45.0, 90.0, 135.0, 180.0, 215.0, 270.0, 305.0};
        CoordinateConverter converter = this.imageDisplay.getCoordinateConverter();
        Point2D size = this.getCanvasPane().getSize();
        int nx = (int)size.getX();
        int ny = (int)size.getY();
        double[][] lon = new double[ny][nx];
        double[][] lat = new double[ny][nx];
        for (int iy = 0; iy < ny; ++iy) {
            for (int ix2 = 0; ix2 < nx; ++ix2) {
                Point2D.Double p = new Point2D.Double(ix2, iy);
                converter.screenToWorldCoords(p, false);
                lon[iy][ix2] = p.x;
                lat[iy][ix2] = p.y;
            }
        }
        double maxlat = 0.0;
        int px = 0;
        int py = 0;
        for (int iy = 0; iy < ny; ++iy) {
            for (int ix3 = 0; ix3 < nx; ++ix3) {
                if (!(Math.abs(lat[iy][ix3]) > maxlat)) continue;
                maxlat = Math.abs(lat[iy][ix3]);
                px = ix3;
                py = iy;
            }
        }
        ArrayList<Point2D.Double> outerPoint = new ArrayList<Point2D.Double>();
        ArrayList<Double> outerLon = new ArrayList<Double>();
        int iy = 0;
        for (ix = 0; ix < nx; ++ix) {
            outerPoint.add(new Point2D.Double(ix, iy));
            outerLon.add(lon[iy][ix]);
        }
        ix = nx - 1;
        for (iy = 0; iy < ny; ++iy) {
            outerPoint.add(new Point2D.Double(ix, iy));
            outerLon.add(lon[iy][ix]);
        }
        iy = ny - 1;
        for (ix = nx - 1; ix >= 0; --ix) {
            outerPoint.add(new Point2D.Double(ix, iy));
            outerLon.add(lon[iy][ix]);
        }
        ix = 0;
        for (iy = ny - 1; iy >= 0; --iy) {
            outerPoint.add(new Point2D.Double(ix, iy));
            outerLon.add(lon[iy][ix]);
        }
        outerPoint.add(new Point2D.Double(0.0, 0.0));
        outerLon.add(lon[0][0]);
        for (double level : levels) {
            int index = this.where(outerLon, level);
            if (index == -1) continue;
            Point2D pt = (Point2D)outerPoint.get(index);
            g.drawLine(px, py, (int)pt.getX(), (int)pt.getY());
        }
    }

    private int where(List<Double> lon, double level) {
        Iterator<Double> it = lon.iterator();
        double prev = it.next();
        while (it.hasNext()) {
            Double elm = it.next();
            if (Math.abs(prev - elm) > 180.0) {
                prev = prev > 180.0 ? 0.0 : 360.0;
            }
            if ((prev - level) * (elm - level) <= 0.0) {
                return lon.indexOf(elm);
            }
            prev = elm;
        }
        return -1;
    }

    private void calcLevels(double[][] data, List<Double> levels, boolean lon) {
        double step;
        double max = -1.7976931348623157E308;
        double min = Double.MAX_VALUE;
        boolean shifted = false;
        for (double[] d : data) {
            for (int ix = 0; ix < data[0].length; ++ix) {
                max = Math.max(max, d[ix]);
                min = Math.min(min, d[ix]);
            }
        }
        if (lon) {
            this.polar = false;
            if (max - min > 180.0) {
                max = -1.7976931348623157E308;
                min = Double.MAX_VALUE;
                for (int iy = 0; iy < data.length; ++iy) {
                    for (int ix = 0; ix < data[0].length; ++ix) {
                        double vv = data[iy][ix];
                        double v = vv - 180.0 > 0.0 ? vv - 360.0 : vv;
                        max = Math.max(max, v);
                        min = Math.min(min, v);
                        data[iy][ix] = v;
                    }
                }
                shifted = true;
            }
        }
        if (shifted && max - min > 180.0) {
            this.polar = true;
            return;
        }
        double digit = 1000.0;
        double range = (max - min) / digit;
        while (range < 1.0) {
            range *= 10.0;
            digit /= 10.0;
        }
        int n = (int)range;
        switch (n) {
            case 1: {
                step = 0.25;
                break;
            }
            case 2: {
                step = 0.5;
                break;
            }
            case 3: 
            case 4: {
                step = 1.25;
                break;
            }
            default: {
                step = 2.5;
            }
        }
        for (double level = (double)((int)(min / (step *= digit))) * step; level < max; level += step) {
            levels.add(level);
        }
    }
}

