/*
 * Decompiled with CFR 0.152.
 */
package alma.common.sensitivitycalculatorcore.utils;

import alma.common.sensitivitycalculatorcore.exceptions.InvalidCoordException;
import alma.common.sensitivitycalculatorcore.exceptions.OutOfRangeException;

public final class Convert {
    public static final double HOURS_TO_DEGREES = 15.0;
    public static final int MAX_MILLISECS_DEC = 324000000;
    public static final int MAX_MILLISECS_RA = 1295999985;
    public static final int MILLISECS_PER_SEC = 1000;
    public static final int SECONDS_PER_MINUTE = 60;
    public static final int MILLISECS_PER_MINUTE = 60000;
    public static final int MILLISECS_PER_UNIT = 3600000;
    public static final int FW_BEFORE = 2;
    public static final int FW_AFTER = 3;

    public static boolean isValidDec(long dec) {
        return -324000000L <= dec && dec <= 324000000L;
    }

    public static boolean isValidRA(long ra) {
        return 0L <= ra && ra <= 1295999985L;
    }

    public static String degToDDMMSS(double value) throws OutOfRangeException, InvalidCoordException {
        long msec = Math.round(value * 3600000.0);
        return Convert.milliarcsecToString(msec, false, false);
    }

    public static String milliarcsecToString(long value, boolean ra, boolean noCheck) throws OutOfRangeException, InvalidCoordException {
        if (!noCheck) {
            if (value > Long.MAX_VALUE || value < Long.MIN_VALUE) {
                throw new OutOfRangeException("Out of range: " + value);
            }
            if (ra) {
                if (!Convert.isValidRA(value)) {
                    throw new InvalidCoordException("Invalid masec RA: " + value);
                }
            } else if (!Convert.isValidDec(value)) {
                throw new InvalidCoordException("Invalid masec Dec: " + value);
            }
        }
        if (ra) {
            value /= 15L;
        }
        char sign = ' ';
        if (value < 0L) {
            sign = '-';
            value = -value;
        }
        long units = value / 3600000L;
        long minutes = (value -= units * 3600000L) / 60000L;
        return sign + Convert.zeroPadded(2, units) + ":" + Convert.zeroPadded(2, minutes) + ":" + Convert.zeroPadded(2, (value -= minutes * 60000L) / 1000L) + "." + Convert.zeroPadded(3, value % 1000L);
    }

    public static String zeroPadded(int numDigits, long n) {
        String unpadded = new Long(n).toString();
        if (numDigits <= unpadded.length()) {
            return unpadded;
        }
        return "0000000000000000000000000000000".substring(0, numDigits - unpadded.length()) + unpadded;
    }
}

