/*
 * Decompiled with CFR 0.152.
 */
package alma.archive.wrappers;

import alma.archive.exceptions.general.DatabaseException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class ArchiveTimeStamp {
    private Timestamp time = null;
    protected final SimpleDateFormat isoFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
    protected final SimpleDateFormat sqlFormat = new SimpleDateFormat("dd-MMM-yy hh.mm.ss.SSS a");

    public ArchiveTimeStamp() {
        Calendar now = Calendar.getInstance();
        this.time = new Timestamp(now.getTimeInMillis());
    }

    public ArchiveTimeStamp(Timestamp ts) {
        this.time = ts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArchiveTimeStamp(String timeStampString) throws DatabaseException {
        try {
            SimpleDateFormat simpleDateFormat = this.isoFormat;
            synchronized (simpleDateFormat) {
                this.time = new Timestamp(this.isoFormat.parse(timeStampString).getTime());
            }
        }
        catch (ParseException e) {
            throw new DatabaseException("Illegal Timestamp format: " + timeStampString);
        }
    }

    public Timestamp getTimestamp() {
        return this.time;
    }

    public static long diff(ArchiveTimeStamp one, ArchiveTimeStamp two) {
        return one.time.getTime() - two.time.getTime();
    }

    public boolean equals(Object timeStamp) {
        if (timeStamp.getClass().getName() == "alma.archive.wrappers.ArchiveTimeStamp") {
            return ((ArchiveTimeStamp)timeStamp).time.equals(this.time);
        }
        return ((Timestamp)timeStamp).equals(this.time);
    }

    public boolean after(ArchiveTimeStamp timeStamp) {
        return this.time.after(timeStamp.time);
    }

    public boolean before(ArchiveTimeStamp timeStamp) {
        return this.time.before(timeStamp.time);
    }

    public boolean after(Timestamp timeStamp) {
        return this.time.after((Date)timeStamp);
    }

    public boolean before(Timestamp timeStamp) {
        return this.time.before((Date)timeStamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toISOString() {
        SimpleDateFormat simpleDateFormat = this.isoFormat;
        synchronized (simpleDateFormat) {
            return this.isoFormat.format(this.time);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toSQLString() {
        SimpleDateFormat simpleDateFormat = this.sqlFormat;
        synchronized (simpleDateFormat) {
            return this.sqlFormat.format(this.time);
        }
    }
}

