/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.join;

import java.util.ArrayList;
import java.util.Arrays;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.join.MatchEngine;

public class CombinedMatchEngine
implements MatchEngine {
    private final MatchEngine[] engines;
    private final int[] tupleSizes;
    private final int[] tupleStarts;
    private final int nPart;
    private String name;
    private final Object[][] work0;
    private final Object[][] work1;
    private final Object[][] work2;
    static final /* synthetic */ boolean $assertionsDisabled;

    public CombinedMatchEngine(MatchEngine[] engines) {
        this.engines = engines;
        this.nPart = engines.length;
        this.tupleSizes = new int[this.nPart];
        for (int i = 0; i < this.nPart; ++i) {
            this.tupleSizes[i] = engines[i].getTupleInfos().length;
        }
        this.tupleStarts = new int[this.nPart];
        int ts = 0;
        this.work0 = new Object[this.nPart][];
        this.work1 = new Object[this.nPart][];
        this.work2 = new Object[this.nPart][];
        for (int i = 0; i < this.nPart; ++i) {
            this.tupleStarts[i] = ts;
            ts += this.tupleSizes[i];
            this.work0[i] = new Object[this.tupleSizes[i]];
            this.work1[i] = new Object[this.tupleSizes[i]];
            this.work2[i] = new Object[this.tupleSizes[i]];
        }
        StringBuffer buf = new StringBuffer("(");
        for (int i = 0; i < this.nPart; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(engines[i].toString());
        }
        buf.append(")");
        this.name = buf.toString();
    }

    public double matchScore(Object[] tuple1, Object[] tuple2) {
        double totalScore = 0.0;
        for (int i = 0; i < this.nPart; ++i) {
            Object[] subTuple1 = this.work1[i];
            Object[] subTuple2 = this.work2[i];
            System.arraycopy(tuple1, this.tupleStarts[i], subTuple1, 0, this.tupleSizes[i]);
            System.arraycopy(tuple2, this.tupleStarts[i], subTuple2, 0, this.tupleSizes[i]);
            double score = this.engines[i].matchScore(subTuple1, subTuple2);
            if (score < 0.0) {
                return -1.0;
            }
            totalScore += score;
        }
        return totalScore;
    }

    public ValueInfo getMatchScoreInfo() {
        return null;
    }

    public Object[] getBins(Object[] tuple) {
        Object[][] binBag = new Object[this.nPart][];
        for (int i = 0; i < this.nPart; ++i) {
            Object[] subTuple = this.work0[i];
            System.arraycopy(tuple, this.tupleStarts[i], subTuple, 0, this.tupleSizes[i]);
            binBag[i] = this.engines[i].getBins(subTuple);
        }
        int nBin = 1;
        for (int i = 0; i < this.nPart; ++i) {
            nBin *= binBag[i].length;
        }
        Object[] bins = new Object[nBin];
        int[] offset = new int[this.nPart];
        block2: for (int ibin = 0; ibin < nBin; ++ibin) {
            ArrayList<Object> bin = new ArrayList<Object>(this.nPart);
            for (int i = 0; i < this.nPart; ++i) {
                bin.add(binBag[i][offset[i]]);
            }
            bins[ibin] = bin;
            for (int j = 0; j < this.nPart; ++j) {
                int n = j;
                offset[n] = offset[n] + 1;
                if (offset[n] < binBag[j].length) continue block2;
                offset[j] = 0;
            }
        }
        for (int i = 0; i < this.nPart; ++i) {
            if (!$assertionsDisabled && offset[i] != 0) {
                throw new AssertionError();
            }
        }
        return bins;
    }

    public ValueInfo[] getTupleInfos() {
        int nargs = this.tupleStarts[this.nPart - 1] + this.tupleSizes[this.nPart - 1];
        ValueInfo[] infos = new ValueInfo[nargs];
        for (int i = 0; i < this.nPart; ++i) {
            System.arraycopy(this.engines[i].getTupleInfos(), 0, infos, this.tupleStarts[i], this.tupleSizes[i]);
        }
        return infos;
    }

    public DescribedValue[] getMatchParameters() {
        ArrayList<DescribedValue> params = new ArrayList<DescribedValue>();
        for (int i = 0; i < this.nPart; ++i) {
            params.addAll(Arrays.asList(this.engines[i].getMatchParameters()));
        }
        return params.toArray(new DescribedValue[0]);
    }

    public boolean canBoundMatch() {
        for (int i = 0; i < this.nPart; ++i) {
            if (!this.engines[i].canBoundMatch()) continue;
            return true;
        }
        return false;
    }

    public Comparable[][] getMatchBounds(Comparable[] min, Comparable[] max) {
        min = (Comparable[])min.clone();
        max = (Comparable[])max.clone();
        for (int i = 0; i < this.nPart; ++i) {
            if (!this.engines[i].canBoundMatch()) continue;
            int size = this.tupleSizes[i];
            int start = this.tupleStarts[i];
            Comparable[] subMin = new Comparable[size];
            Comparable[] subMax = new Comparable[size];
            System.arraycopy(min, start, subMin, 0, size);
            System.arraycopy(max, start, subMax, 0, size);
            Comparable[][] subBounds = this.engines[i].getMatchBounds(subMin, subMax);
            subMin = subBounds[0];
            subMax = subBounds[1];
            System.arraycopy(subMin, 0, min, start, size);
            System.arraycopy(subMax, 0, max, start, size);
        }
        return new Comparable[][]{min, max};
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    static {
        $assertionsDisabled = !CombinedMatchEngine.class.desiredAssertionStatus();
    }
}

