/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.logging.client.cache;

import com.cosylab.logging.client.cache.ILogMap;
import com.cosylab.logging.client.cache.LogCacheException;
import com.cosylab.logging.client.cache.LogIterator;
import com.cosylab.logging.client.cache.MultiFileTableRecord;
import com.cosylab.logging.engine.log.ILogEntry;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;

public class LogMultiFileCache
implements ILogMap {
    public static final String FILEMAXSIZE_PROPERTY_NAME = "jlog.cache.fileMaxSize";
    public static final long DEFAULT_FILEMAXSIZE = 10000000L;
    private boolean debugTrace = false;
    private long fileMaxSize;
    private Vector<MultiFileTableRecord> logFileTable = new Vector();
    private final AtomicInteger logsInCache = new AtomicInteger(0);
    private int ID = -1;

    private static long getDefaultMaxFileSize() {
        Integer fileSizeFromProperty = Integer.getInteger(FILEMAXSIZE_PROPERTY_NAME);
        if (fileSizeFromProperty != null) {
            return fileSizeFromProperty.longValue();
        }
        return 10000000L;
    }

    private void printDebugTrace(String traceInfo) {
        if (this.debugTrace) {
            System.out.println(traceInfo);
        }
    }

    private MultiFileTableRecord createNewFileRecord() throws LogCacheException {
        MultiFileTableRecord newFileRec = new MultiFileTableRecord();
        this.logFileTable.add(newFileRec);
        return newFileRec;
    }

    private MultiFileTableRecord searchFileLogTable(Integer logKey) throws LogCacheException {
        if (logKey == null || logKey < 0) {
            throw new IllegalArgumentException("Invalid or null log key " + logKey);
        }
        if (this.logFileTable.isEmpty()) {
            throw new LogCacheException("Empty log file table");
        }
        for (MultiFileTableRecord record : this.logFileTable) {
            if (logKey < record.getMinLogIdx() || logKey > record.getMaxLogIdx()) continue;
            return record;
        }
        throw new LogCacheException("Log record containing " + logKey + " not found");
    }

    public LogMultiFileCache(long fileSize) throws LogCacheException {
        if (fileSize <= 0L) {
            throw new IllegalArgumentException("Invalid size for logFile " + fileSize);
        }
        this.fileMaxSize = fileSize;
        this.printDebugTrace("LogMultiFileCache uses file of max size: " + this.fileMaxSize);
    }

    public LogMultiFileCache() throws LogCacheException {
        this(LogMultiFileCache.getDefaultMaxFileSize());
    }

    @Override
    public ILogEntry getLog(Integer logKey) throws LogCacheException {
        MultiFileTableRecord fileRecord = this.searchFileLogTable(logKey);
        return fileRecord.getLog(logKey);
    }

    @Override
    public synchronized int add(ILogEntry log) throws LogCacheException {
        long actualSize;
        if (log == null) {
            throw new LogCacheException("Trying to add a null log to the buffer");
        }
        MultiFileTableRecord fileRecord = this.logFileTable.size() > 0 ? this.logFileTable.get(this.logFileTable.size() - 1) : this.createNewFileRecord();
        try {
            actualSize = fileRecord.getFileSize();
        }
        catch (IOException e) {
            throw new LogCacheException("Error getting the size of the file", e);
        }
        if (actualSize >= this.fileMaxSize) {
            fileRecord.flushBuffer();
            this.printDebugTrace("LogMultiFileCache log file : fileSize " + actualSize + " logs = " + fileRecord.getNumOfLogs() + " Range keys = " + fileRecord.getMinLogIdx() + " " + fileRecord.getMaxLogIdx());
            fileRecord = this.createNewFileRecord();
        }
        fileRecord.addLog(log, ++this.ID);
        this.logsInCache.incrementAndGet();
        return this.ID;
    }

    @Override
    public synchronized void deleteLog(Integer logKey) throws LogCacheException {
        if (logKey == null) {
            throw new IllegalArgumentException("The key can't be null");
        }
        MultiFileTableRecord fileRecord = this.searchFileLogTable(logKey);
        int idx = this.logFileTable.indexOf(fileRecord);
        if (idx == -1) {
            throw new IllegalStateException("The record is not in the vector");
        }
        fileRecord.deleteLog(logKey);
        this.logsInCache.decrementAndGet();
        this.printDebugTrace("\n Delete log key = " + logKey + " from record " + idx + "  Tot. Logs " + this.logsInCache + "  Range keys = " + fileRecord.getMinLogIdx() + " " + fileRecord.getMaxLogIdx());
        if (fileRecord.getNumOfLogs() == 0) {
            fileRecord.clear();
            this.printDebugTrace("Delete log file: recId " + idx + " num. of logs = " + fileRecord.getNumOfLogs() + " Range keys = [" + fileRecord.getMinLogIdx() + ", " + fileRecord.getMaxLogIdx() + "] files in table " + this.logFileTable.size());
            this.logFileTable.remove(fileRecord);
        }
    }

    @Override
    public int getSize() {
        return this.logsInCache.get();
    }

    @Override
    public Integer getLastLog() {
        if (this.logsInCache.get() == 0) {
            return null;
        }
        MultiFileTableRecord lastRecord = this.logFileTable.lastElement();
        Integer key = lastRecord.getLastLog();
        if (key == null) {
            throw new IllegalStateException("The cache is not empty but the last log does not exist?!?!");
        }
        return key;
    }

    @Override
    public Integer getFirstLog() {
        if (this.logsInCache.get() == 0) {
            return null;
        }
        MultiFileTableRecord firstRecord = this.logFileTable.get(0);
        Integer key = firstRecord.getFirstLog();
        if (key == null) {
            throw new IllegalStateException("The cache is not empty but the last log does not exist?!?!");
        }
        return key;
    }

    @Override
    public void deleteLogs(Collection<Integer> keys) throws LogCacheException {
        if (keys == null || keys.size() == 0) {
            return;
        }
        for (Integer key : keys) {
            this.deleteLog(key);
        }
    }

    @Override
    public synchronized void clear() throws LogCacheException {
        for (MultiFileTableRecord record : this.logFileTable) {
            record.clear();
        }
        this.logFileTable.clear();
        this.logsInCache.set(0);
    }

    @Override
    public void replaceLog(Integer key, ILogEntry log) throws LogCacheException {
        MultiFileTableRecord tableRecord = this.searchFileLogTable(key);
        tableRecord.replaceLog(key, log);
    }

    @Override
    public Iterator<ILogEntry> iterator() {
        return new LogIterator(this);
    }

    @Override
    public Set<Integer> keySet() {
        HashSet<Integer> ret = new HashSet<Integer>();
        for (MultiFileTableRecord record : this.logFileTable) {
            ret.addAll(record.keySet());
        }
        return ret;
    }

    @Override
    public int getFirstLogs(int n, Collection<Integer> keys) {
        int ret = 0;
        Vector<Integer> temp = new Vector<Integer>();
        for (MultiFileTableRecord record : this.logFileTable) {
            temp.clear();
            ret += record.getFirstLogs(n - ret, temp);
            for (int t = 0; t < temp.size(); ++t) {
                temp.set(t, temp.get(t) + record.getMinLogIdx());
            }
            keys.addAll(temp);
            if (ret != n) continue;
            break;
        }
        return ret;
    }

    public long getLogFileSize() throws LogCacheException {
        long fileSize;
        if (this.logFileTable.isEmpty()) {
            return 0L;
        }
        MultiFileTableRecord lastRecord = this.logFileTable.lastElement();
        if (lastRecord == null) {
            throw new LogCacheException("Null file record");
        }
        try {
            fileSize = lastRecord.getFileSize();
        }
        catch (IOException ioe) {
            throw new LogCacheException(ioe);
        }
        return fileSize;
    }

    public synchronized long getFilesSize() throws IOException {
        long ret = 0L;
        for (MultiFileTableRecord mftb : this.logFileTable) {
            ret += mftb.getFileSize();
        }
        return ret;
    }

    public long getMaxFileSize() throws LogCacheException {
        return this.fileMaxSize;
    }

    public void setDebugTrace(boolean flag) throws LogCacheException {
        this.debugTrace = flag;
    }

    public void printFileTableInfo() throws LogCacheException {
        System.out.println("\nlogFileTable : total logs = " + this.logsInCache);
        for (int idx = 0; idx < this.logFileTable.size(); ++idx) {
            long actualSize;
            MultiFileTableRecord fr = this.logFileTable.get(idx);
            try {
                actualSize = fr.getFileSize();
            }
            catch (IOException e) {
                throw new LogCacheException("Error getting the size of the file", e);
            }
            System.out.println("logFile " + idx + ": log counter = " + fr.getNumOfLogs() + "  Range Keys [" + fr.getMinLogIdx() + "  " + fr.getMaxLogIdx() + "] file size " + actualSize);
        }
        System.out.println("\n");
    }

    public int getNumberOfCacheFiles() {
        return this.logFileTable.size();
    }
}

