/*
 * Decompiled with CFR 0.152.
 */
package skyview.test;

import com.sun.image.codec.jpeg.JPEGCodec;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import org.junit.Assert;
import org.junit.Test;
import skyview.executive.Imager;
import skyview.executive.Settings;
import skyview.test.Util;
import skyview.vo.CatalogProcessor;

public class BasicTester {
    private static DataOutputStream os;
    private static boolean first;
    private static int minTest;
    private static int maxTest;
    private static int base;
    private static boolean updateSettings;

    @Test
    public void testSurveys() throws Exception {
        int i;
        base = 1;
        os = new DataOutputStream(new FileOutputStream("upd.settings"));
        if (System.getenv("MIN_TEST") != null) {
            minTest = Integer.parseInt(System.getenv("MIN_TEST"));
        }
        if (System.getenv("MAX_TEST") != null) {
            maxTest = Integer.parseInt(System.getenv("MAX_TEST"));
        }
        System.err.println("Tests from:" + minTest + " to " + maxTest);
        String[] surveys = new String[]{"dss", "dss1r", "dss1b", "dss2r", "dss2b", "dss2ir", "pspc2int", "pspc1int", "pspc2cnt", "pspc2exp", "2massh", "2massj", "2massk", "sdssi", "sdssu", "sdssz", "sdssg", "sdssr", "iras100", "iras60", "iras25", "iras12", "first", "nvss", "hriint", "rass3bb", "rass3hb", "rass3sb", "halpha", "sfddust", "sfd100m", "shassa_c", "shassa_cc", "shassa_h", "shassa_sm", "4850mhz", "iris12", "iris25", "iris60", "iris100", "wfcf1", "wfcf2", "euve83", "euve171", "euve405", "euve555", "neat", "rass", "rasshb", "rasssb"};
        String[] allSky = new String[]{"1420mhz", "408mhz", "heao1a", "cobe", "cobeaam", "cobezsma", "comptel", "egretsoft", "egrethard", "egret3d", "rass.25kev", "rass.75kev", "rass1.5kev", "rxte3_20K_sig", "rxte3_8k_sig", "rxte8_20k_sig", "nh", "0035mhz", "wmapk", "wmapka", "wmapq", "wmapv", "wmapw", "wmapilc", "mell-r", "mell-g", "mell-b"};
        String[] gc = new String[]{"co", "granat_sigma_sig", "granat_sigma_flux", "integralspi_gc", "batflux0", "batflux1", "batflux2", "batflux3", "batflux4", "batsig0", "batsig1", "batsig2", "batsig3", "batsig4", "rassbck1", "rassbck2", "rassbck3", "rassbck4", "rassbck5", "rassbck6", "rassbck7", "mell-r", "mell-g", "mell-b"};
        Settings.put("position", "187.27791499999998,2.052388");
        for (i = 0; i < surveys.length; ++i) {
            this.testSurvey(surveys[i], i + base);
        }
        Settings.put("position", "0.,0.");
        Settings.put("coordinates", "galactic");
        Settings.put("Projection", "Car");
        Settings.put("pixels", "600,300");
        Settings.put("size", "360,180");
        base += surveys.length;
        for (i = 0; i < allSky.length; ++i) {
            this.testSurvey(allSky[i], i + base);
        }
        Settings.put("size", "5");
        Settings.put("pixels", "300");
        base += allSky.length;
        for (i = 0; i < gc.length; ++i) {
            this.testSurvey(gc[i], i + base);
        }
        Settings.put("position", "0., 90.");
        Settings.put("coordinates", "ICRS");
        Settings.put("pixels", "500,500");
        Settings.put("projection", "Tan");
        this.testSurvey("wenss", base += gc.length);
        Settings.put("position", "0., -90.");
        this.testSurvey("sumss", ++base);
        Settings.put("position", "10.,10.");
        Settings.put("size", ".4");
        this.testSurvey("galexnear", ++base);
        this.testSurvey("galexfar", ++base);
        ++base;
        Settings.put("size", "5");
    }

    public int jpegSum(String jpegName, int nx, int ny) throws Exception {
        FileInputStream is = new FileInputStream(jpegName);
        int[] data = new int[3 * nx * ny];
        int sum = 0;
        data = JPEGCodec.createJPEGDecoder((InputStream)is).decodeAsRaster().getPixels(0, 0, nx, ny, data);
        for (int i = 0; i < data.length; ++i) {
            sum += data[i];
        }
        ((InputStream)is).close();
        return sum;
    }

    Imager runImager(int index) throws Exception {
        Imager img = this.runImagerx(index);
        Settings.restore();
        return img;
    }

    Imager runImagerx(int index) throws Exception {
        Imager img = Imager.getImager();
        Settings.put("output", "out" + index);
        if (first) {
            Settings.addArgs(new String[]{"settings=comparison.settings", "noexit"});
            img.init();
            first = false;
        }
        Settings.save();
        if (updateSettings) {
            img.checkUpdateSettings();
        }
        String surv = Settings.get("survey");
        System.err.println("Processing survey:" + surv);
        img.processSurvey(surv);
        return img;
    }

    void testSurvey(String surv, int index) throws Exception {
        Settings.put("survey", surv);
        if (index < minTest || index > maxTest) {
            return;
        }
        Imager img = this.runImager(index);
        double[] data = (double[])img.getImageData();
        double sum = this.total(data);
        System.err.println("  Sum is:" + sum);
        Util.regress(surv + "_sum_" + index, sum, os);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSamplers() throws Exception {
        base = 101;
        String[] samplers = new String[]{"NN", "LI", "Lanczos", "Lanczos3", "Lanczos4", "Spline", "Spline3", "Spline4", "Spline5", "Clip"};
        Settings.put("survey", "user");
        Settings.put("size", "1.1");
        Settings.put("pixels", "22");
        Settings.put("userfile", "inputtest1.fits");
        Settings.put("position", "0.,0.");
        Settings.put("Coordinates", "J2000");
        this.doTests(samplers, "sampler", base);
        Settings.put("UserFile", "null");
        Settings.save();
        try {
            Settings.put("Sampler", "Clip");
            Settings.put("Survey", "IRIS100");
            Settings.put("Size", "30");
            Settings.put("Pixels", "500");
            this.doTests(new String[]{"skyview.process.IDMosaic"}, "mosaicker", base += samplers.length);
            ++base;
            Settings.put("Survey", "User");
            Settings.put("userfile", "inputtest1.fits,inputtest2.fits,inputtest3.fits");
            Settings.put("position", "0.,0.");
            Settings.put("size", "10.1");
            Settings.put("pixels", "101");
            Settings.put("Sampler", "Clip");
            Settings.put("Projection", "Car");
            String[] specialFinders = new String[]{"Bypass", "Overlap"};
            Settings.put("Mosaicker", "skyview.process.AddingMosaicker");
            this.doTests(specialFinders, "imagefinder", base);
            base += specialFinders.length;
            Settings.put("Survey", "galexfar");
            Settings.put("Position", "m81");
            Settings.put("MAXRAD", "1391");
            Settings.put("ExposureFinder", "FitsKeyword");
            Settings.put("ExposureKeyword", "EXPTIME");
            Settings.put("Size", "0.3");
            Settings.put("Pixels", "600");
            Settings.put("Projection", "Tan");
            this.doTests(specialFinders, "imagefinder", base);
            base += specialFinders.length;
        }
        finally {
            Settings.restore();
        }
    }

    double doTests(String[] options, String param, int base) throws Exception {
        double grand = 0.0;
        for (int i = 0; i < options.length; ++i) {
            System.err.println("Setting " + param + " to " + options[i]);
            int index = base + i;
            if (index < minTest || index > maxTest) continue;
            Settings.put(param, options[i]);
            Imager img = this.runImager(base + i);
            double sum = this.total((double[])img.getImageData());
            grand += sum;
            img.clearImageCache();
            System.err.println("  Sum is:" + sum);
            Util.regress(options[i] + "_sum_" + index, sum, os);
        }
        return grand;
    }

    private double total(double[] data) {
        double sum = 0.0;
        for (int j = 0; j < data.length; ++j) {
            if (data[j] != data[j]) continue;
            sum += data[j];
        }
        return sum;
    }

    private long fileSum(String filename) {
        long sum = 0L;
        try {
            int byt;
            FileInputStream bf = new FileInputStream(filename);
            while ((byt = bf.read()) >= 0) {
                sum += (long)byt;
            }
            bf.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        return sum;
    }

    private void jpegCheck(String msg, int base, int nx, int ny) throws Exception {
        String jpegFile = "out" + base + ".jpg";
        int sum = this.jpegSum(jpegFile, nx, ny);
        Util.regress("JPEG_" + msg + "_" + base, sum, os);
    }

    private void jpegRGBCheck(String msg, int base, int nx, int ny) throws Exception {
        String jpegFile = "out" + base + "_rgb.jpg";
        int sum = this.jpegSum(jpegFile, nx, ny);
        Util.regress("JPEG_" + msg + "_" + base, sum, os);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProjections() throws Exception {
        String[] projections = new String[]{"Tan", "Sin", "Car", "Ait", "Csc", "Zea", "Arc", "Stg", "Sfl", "Hpx", "Tea"};
        Settings.put("Survey", "heao1a");
        Settings.put("Coordinates", "Galactic");
        Settings.put("size", "90");
        Settings.put("pixels", "300");
        this.doTests(projections, "projection", 201);
        String[] proj2 = new String[]{"Toa"};
        Settings.save();
        boolean updSave = updateSettings;
        try {
            Settings.put("Coordinates", "J2000");
            Settings.put("Position", "0.,90.");
            Settings.put("Survey", "HEAO1A");
            Settings.put("Pixels", "200");
            Settings.put("Size", "90");
            Settings.put("Sampler", "Clip");
            Settings.put("ClipIntensive", "1");
            this.doTests(proj2, "projection", 201 + projections.length);
            updateSettings = true;
            Settings.put("Size", "null");
            Settings.put("Pixels", "null");
            Settings.put("Survey", "DSS");
            Settings.put("level", "9");
            Settings.put("TileX", "255");
            Settings.put("TileY", "255");
            Settings.put("Subdiv", "9");
            String upd = Settings.get("SettingsUpdaters");
            Settings.put("SettingsUpdaters", "skyview.request.ToastGridder," + upd);
            this.doTests(proj2, "projection", 201 + projections.length + proj2.length);
        }
        finally {
            Settings.restore();
            updateSettings = updSave;
        }
    }

    @Test
    public void testCoordinates() throws Exception {
        String[] coordinates = new String[]{"J2000", "B1950", "E2000", "H2000", "Galactic", "ICRS"};
        Settings.put("Survey", "heao1a");
        Settings.put("projection", "Car");
        Settings.put("size", "90");
        Settings.put("pixels", "300");
        this.doTests(coordinates, "coordinates", 301);
    }

    @Test
    public void testRotation() throws Exception {
        String[] angles = new String[]{"0", "30", "60", "90", "180", "-30", "-90"};
        Settings.put("Survey", "heao1a");
        Settings.put("projection", "Car");
        Settings.put("size", "90");
        Settings.put("coordinates", "galactic");
        Settings.put("pixels", "300");
        Settings.put("Sampler", "NN");
        this.doTests(angles, "rotation", 401);
        Settings.put("rotation", "null");
        Settings.put("survey", "dss");
        Settings.put("projection", "Tan");
        Settings.put("coordinates", "J2000");
        Settings.put("size", "null");
        Settings.put("position", "187.27791499999998,2.052388");
        double sum0 = this.doTests(new String[]{"1"}, "min", 401 + angles.length);
        Settings.put("pixels", "150");
        double sum1 = this.doTests(new String[]{"-75,-75", "-75,75", "75,-75", "75,75"}, "offset", 402 + angles.length);
        Assert.assertEquals((String)"Offset test:", (Object)sum0, (Object)sum1);
        Settings.put("offset", "null");
        Settings.put("pixels", "500,250");
        Settings.put("size", "380,180");
        Settings.put("projection", "Ait");
        Settings.put("Position", "0.,90.");
        Settings.put("Survey", "408Mhz");
        this.doTests(new String[]{"0.,1.", "0.,90.", "0.,-89.", "179.,0."}, "RefCoords", 401 + angles.length + 5);
        Settings.put("Position", "187.27791499999998,2.052388");
        Settings.put("RefCoords", "null");
        Settings.put("Size", "null");
        Settings.put("Survey", "dss");
        Settings.put("pixels", "300");
        Settings.put("projection", "Car");
    }

    @Test
    public void testScale() throws Exception {
        String[] scales = new String[]{"0.25", "0.25,0.25", "0.5,0.25", "0.25,0.5", "0.1"};
        Settings.put("Survey", "heao1a");
        Settings.put("Position", "0.,0.");
        Settings.put("projection", "Car");
        Settings.put("size", "90");
        Settings.put("coordinates", "Galactic");
        Settings.put("pixels", "300");
        Settings.put("Sampler", "NN");
        this.doTests(scales, "scale", 501);
    }

    @Test
    public void testPixel() throws Exception {
        String[] pixels = new String[]{"300", "300,150", "150,300", "10,10"};
        Settings.put("Survey", "heao1a");
        Settings.put("projection", "Car");
        Settings.put("size", "90");
        Settings.put("coordinates", "galactic");
        Settings.put("pixels", "300");
        Settings.put("Sampler", "NN");
        this.doTests(pixels, "pixels", 601);
    }

    @Test
    public void testSettings() {
        base = 701;
        if (base < minTest || base > maxTest) {
            return;
        }
        System.err.println("Testing settings");
        Assert.assertTrue((String)"XXX not set", (!Settings.has("xxx") ? 1 : 0) != 0);
        Settings.add("XXX", "aaa");
        Assert.assertTrue((String)"XXX should not be set", (boolean)Settings.has("xxx"));
        Assert.assertEquals((String)"XXX should be lenght 1", (Object)Settings.getArray("xxx").length, (Object)1);
        Settings.add("XXX", "bbb");
        Assert.assertEquals((String)"XXX should be length 2", (Object)Settings.getArray("xxx").length, (Object)2);
        System.err.println("Adds worked!");
        Settings.put("xxx", "null");
        Assert.assertTrue((String)"Cleared xxx", (!Settings.has("xxx") ? 1 : 0) != 0);
        Assert.assertTrue((String)"Cleared xxx2", (Settings.get("xxx") == null ? 1 : 0) != 0);
        Assert.assertEquals((String)"Cleared xxx3", (Object)Settings.getArray("xxx").length, (Object)0);
        System.err.println("Delete worked");
        Settings.put("xxx", "a,b,c");
        Assert.assertEquals((String)"Reset xxx", (Object)Settings.getArray("xxx").length, (Object)3);
        System.err.println("Settings OK");
        Assert.assertTrue((String)"Sugg1", (boolean)Settings.get("xxx").equals("a,b,c"));
        Settings.suggest("xxx", "d,e,f");
        Assert.assertTrue((String)"Sugg2", (boolean)Settings.get("xxx").equals("a,b,c"));
        Settings.suggest("yyy", "d,e,f");
        Assert.assertTrue((String)"Sugg3", (boolean)Settings.get("yyy").equals("d,e,f"));
        Settings.suggest("yyy", "a,b,c");
        Assert.assertTrue((String)"Sugg4", (boolean)Settings.get("yyy").equals("d,e,f"));
        Assert.assertTrue((String)"Sugg5", (boolean)Settings.has("yyy"));
        Settings.put("yyy", "null");
        Assert.assertTrue((String)"Sugg6", (!Settings.has("yyy") ? 1 : 0) != 0);
        Settings.suggest("yyy", "abc");
        Assert.assertTrue((String)"Sugg7", (!Settings.has("yyy") ? 1 : 0) != 0);
        Settings.put("yyy", "abc");
        Assert.assertTrue((String)"Sugg8", (boolean)Settings.has("yyy"));
    }

    @Test
    public void testPosit() throws Exception {
        base = 801;
        Settings.put("Survey", "heao1a");
        Settings.put("projection", "Car");
        Settings.put("size", "90");
        Settings.put("coordinates", "galactic");
        Settings.put("pixels", "30");
        Settings.put("Sampler", "NN");
        Settings.put("position", "180., 0.");
        if (minTest > 900 || maxTest < 800) {
            return;
        }
        Imager img = this.runImager(base);
        double val1 = this.total((double[])img.getImageData());
        img.clearImageCache();
        Settings.put("position", "null");
        Settings.put("Lat", "0");
        Settings.put("Lon", "180");
        img = this.runImager(++base);
        double val2 = this.total((double[])img.getImageData());
        Assert.assertEquals((String)"Use Lat/Lon or position", (Object)val1, (Object)val2);
        img.clearImageCache();
        Settings.put("lat", "null");
        Settings.put("lon", "null");
        Settings.put("copywcs", "out801.fits");
        img = this.runImager(++base);
        double val3 = this.total((double[])img.getImageData());
        Assert.assertEquals((String)"Using copyWCS", (Object)val1, (Object)val3);
        System.err.println("LatLon and copyWCS value:" + val1);
        Settings.put("copywcs", "null");
    }

    @Test
    public void testQLFormats() throws Exception {
        Settings.put("Survey", "heao1a");
        Settings.put("projection", "Car");
        Settings.put("size", "360,180");
        Settings.put("coordinates", "galactic");
        Settings.put("pixels", "200,100");
        Settings.put("Sampler", "NN");
        Settings.put("position", "180., 0.");
        String[] formats = new String[]{"", "JPEG", "JPG", "GIF", "BMP", "TIFF", "PNG"};
        boolean oldState = updateSettings;
        updateSettings = true;
        this.doTests(formats, "quicklook", 901);
        if (maxTest < 900 || minTest >= 1000) {
            return;
        }
        Assert.assertTrue((String)"JPEG1", (boolean)new File("out901.jpg").exists());
        Assert.assertTrue((String)"JPEG2", (boolean)new File("out902.jpg").exists());
        Assert.assertTrue((String)"JPEG3", (boolean)new File("out903.jpg").exists());
        Assert.assertTrue((String)"GIF", (boolean)new File("out904.gif").exists());
        Assert.assertTrue((String)"BMP", (boolean)new File("out905.bmp").exists());
        Assert.assertTrue((String)"TIFF", (boolean)new File("out906.tiff").exists());
        Assert.assertTrue((String)"PNG", (boolean)new File("out907.png").exists());
        System.err.println("Quicklook formats tested");
        Assert.assertTrue((String)"Have901Fits", (boolean)new File("out901.fits").exists());
        base = 901 + formats.length;
        Settings.put("quicklook", "");
        Settings.put("nofits", "");
        if (base >= minTest && base <= maxTest) {
            this.runImager(base);
            Assert.assertTrue((String)"Nofits test1", (boolean)new File("out" + base + ".jpg").exists());
            Assert.assertTrue((String)"Nofits test2", (!new File("out" + base + ".fits").exists() ? 1 : 0) != 0);
        }
        updateSettings = oldState;
    }

    @Test
    public void testGrid() throws Exception {
        Settings.put("scale", "null");
        Settings.put("Survey", "heao1a");
        Settings.put("projection", "Car");
        Settings.put("size", "360,180");
        Settings.put("coordinates", "galactic");
        Settings.put("pixels", "400,200");
        Settings.put("Sampler", "NN");
        Settings.put("position", "0., 0.");
        Settings.put("nofits", "");
        Settings.put("grid", "");
        Settings.put("quicklook", "JPG");
        base = 1001;
        boolean oldupd = updateSettings;
        updateSettings = true;
        if (base >= minTest && base <= maxTest) {
            Imager.getImager().clearImageCache();
            System.err.println("Size is:" + Settings.get("pixels"));
            this.runImager(base);
            this.jpegCheck("grid", base, 400, 200);
        }
        Settings.put("gridlabels", "");
        if (++base >= minTest && base <= maxTest) {
            Imager.getImager().clearImageCache();
            this.runImager(base);
            this.jpegCheck("gridlab", base, 400, 200);
        }
        Settings.put("grid", "equatorial");
        if (++base >= minTest && base <= maxTest) {
            Imager.getImager().clearImageCache();
            this.runImager(base);
            this.jpegCheck("grid", base, 400, 200);
        }
        ++base;
        Settings.put("grid", "");
        Settings.put("projection", "Tan");
        Settings.put("position", "45.,90.");
        Settings.put("pixels", "300");
        Settings.put("size", "60");
        Settings.put("gridlabels", "null");
        if (base >= minTest && base <= maxTest) {
            Imager.getImager().clearImageCache();
            this.runImager(base);
            this.jpegCheck("grid", base, 300, 300);
        }
        Settings.put("gridlabels", "");
        if (++base >= minTest && base <= maxTest) {
            Imager.getImager().clearImageCache();
            this.runImager(base);
            this.jpegCheck("gridlab", base, 300, 300);
        }
        Settings.put("grid", "equatorial");
        if (++base >= minTest && base <= maxTest) {
            Imager.getImager().clearImageCache();
            this.runImager(base);
            this.jpegCheck("gridfor", base, 300, 300);
        }
        ++base;
        Settings.put("grid", "null");
        Settings.put("gridlabels", "null");
        updateSettings = oldupd;
    }

    @Test
    public void testContour() throws Exception {
        System.err.println("Test contours");
        Settings.put("scale", "null");
        Settings.put("nofits", "null");
        Settings.put("Survey", "heao1a");
        Settings.put("projection", "Car");
        Settings.put("size", "360,180");
        Settings.put("coordinates", "galactic");
        Settings.put("pixels", "400,200");
        Settings.put("Sampler", "NN");
        Settings.put("position", "0., 0.");
        Settings.put("contour", "heao1a");
        Settings.put("quicklook", "jpg");
        boolean oldState = updateSettings;
        updateSettings = true;
        base = 1101;
        if (base >= minTest && base <= maxTest) {
            Imager.getImager().clearImageCache();
            this.runImager(base);
            this.jpegCheck("cont", base, 400, 200);
        }
        Settings.put("contourSmooth", "7");
        if (++base >= minTest && base <= maxTest) {
            Imager.getImager().clearImageCache();
            this.runImager(base);
            this.jpegCheck("contsmooth", base, 400, 200);
        }
        Settings.put("contourSmooth", "null");
        Settings.put("contour", "heao1a:linear");
        if (++base >= minTest && base <= maxTest) {
            Imager.getImager().clearImageCache();
            this.runImager(base);
            this.jpegCheck("contlin", base, 400, 200);
        }
        Settings.put("contour", "heao1a:sqrt");
        if (++base >= minTest && base <= maxTest) {
            Imager.getImager().clearImageCache();
            this.runImager(base);
            this.jpegCheck("contsqrt", base, 400, 200);
        }
        Settings.put("contour", "heao1a:log:6");
        if (++base >= minTest && base <= maxTest) {
            Imager.getImager().clearImageCache();
            this.runImager(base);
            this.jpegCheck("contncont", base, 400, 200);
        }
        Settings.put("contour", "heao1a:log:6:1:1000");
        if (++base >= minTest && base <= maxTest) {
            Imager.getImager().clearImageCache();
            this.runImager(base);
            this.jpegCheck("contspec", base, 400, 200);
        }
        Settings.put("contour", "egrethard");
        if (++base >= minTest && base <= maxTest) {
            Imager.getImager().clearImageCache();
            this.runImager(base);
            this.jpegCheck("contdiff", base, 400, 200);
        }
        Settings.put("contour", "egrethard:log:5:1.e-7:0.01");
        if (++base >= minTest && base <= maxTest) {
            Imager.getImager().clearImageCache();
            this.runImager(base);
            this.jpegCheck("contdiffspec", base, 400, 200);
        }
        Settings.put("contourSmooth", "5");
        if (++base >= minTest && base <= maxTest) {
            Imager.getImager().clearImageCache();
            this.runImager(base);
            this.jpegCheck("contdiffsmooth", base, 400, 200);
        }
        Settings.put("noContourPrint", "");
        if (++base >= minTest && base <= maxTest) {
            System.err.println("No contour countss should be printed this time");
            Imager.getImager().clearImageCache();
            this.runImager(base);
        }
        ++base;
        updateSettings = oldState;
        Settings.put("contourSmooth", "null");
        Settings.put("noContourPrint", "null");
        Settings.put("contour", "null");
    }

    @Test
    public void testSmoothing() throws Exception {
        double[] data;
        base = 1201;
        boolean oldState = updateSettings;
        updateSettings = true;
        Settings.put("survey", "user");
        Settings.put("userfile", "inputtest1.fits");
        Settings.put("CopyWCS", "inputtest1.fits");
        Settings.put("Smooth", "5");
        if (base >= minTest && base <= maxTest) {
            Imager.getImager().clearImageCache();
            this.runImager(base);
            data = (double[])Imager.getImager().getImageData();
            System.err.println("Smoothing 5x5 box:" + data[60]);
            Assert.assertEquals((String)"5x5 box: in", (Object)data[60], (Object)0.04);
            Assert.assertEquals((String)"5x5 box: in", (Object)data[61], (Object)0.04);
            Assert.assertEquals((String)"5x5 box: in", (Object)data[62], (Object)0.04);
            Assert.assertEquals((String)"5x5 box: in", (Object)data[71], (Object)0.04);
            Assert.assertEquals((String)"5x5 box: in", (Object)data[82], (Object)0.04);
            Assert.assertEquals((String)"5x5 box: out", (Object)data[93], (Object)0.0);
            Assert.assertEquals((String)"5x5 box: out", (Object)data[63], (Object)0.0);
        }
        Settings.put("Smooth", "5,1");
        if (++base >= minTest && base <= maxTest) {
            Imager.getImager().clearImageCache();
            this.runImager(base);
            data = (double[])Imager.getImager().getImageData();
            Assert.assertEquals((String)"5x5 box: in", (Object)data[60], (Object)0.2);
            Assert.assertEquals((String)"5x5 box: in", (Object)data[61], (Object)0.2);
            Assert.assertEquals((String)"5x5 box: in", (Object)data[62], (Object)0.2);
            Assert.assertEquals((String)"5x5 box: out", (Object)data[71], (Object)0.0);
            Assert.assertEquals((String)"5x5 box: out", (Object)data[63], (Object)0.0);
        }
        Settings.put("Smooth", "1,5");
        if (++base >= minTest && base <= maxTest) {
            Imager.getImager().clearImageCache();
            this.runImager(base);
            data = (double[])Imager.getImager().getImageData();
            Assert.assertEquals((String)"5x5 box: in", (Object)data[60], (Object)0.2);
            Assert.assertEquals((String)"5x5 box: in", (Object)data[71], (Object)0.2);
            Assert.assertEquals((String)"5x5 box: in", (Object)data[82], (Object)0.2);
            Assert.assertEquals((String)"5x5 box: out", (Object)data[61], (Object)0.0);
            Assert.assertEquals((String)"5x5 box: out", (Object)data[93], (Object)0.0);
        }
        ++base;
        updateSettings = oldState;
        Settings.put("userfile", "null");
        Settings.put("CopyWCS", "null");
    }

    @Test
    public void testCatalogs() throws Exception {
        base = 1301;
        Settings.put("survey", "rass3bb");
        Settings.put("scaling", "log");
        Settings.put("size", "15");
        Settings.put("pixels", "500");
        Settings.put("catalog", "rosmaster");
        Settings.put("quicklook", "jpg");
        Settings.put("position", "0.,0.");
        Settings.put("coordinates", "Galactic");
        Settings.put("nofits", "null");
        Settings.put("min", "null");
        Settings.put("max", "null");
        boolean oldState = updateSettings;
        updateSettings = true;
        if (base >= minTest && base <= maxTest) {
            Imager.getImager().clearImageCache();
            this.runImager(base);
            this.jpegCheck("cat", base, 500, 500);
        }
        Settings.put("catalogids", "");
        if (++base >= minTest && base <= maxTest) {
            Imager.getImager().clearImageCache();
            this.runImager(base);
            this.jpegCheck("catids", base, 500, 500);
        }
        ++base;
        CatalogProcessor.clearRequests();
        int count1 = Integer.MAX_VALUE;
        int count2 = Integer.MAX_VALUE;
        int count3 = Integer.MAX_VALUE;
        Settings.put("catalogfile", "");
        if (base >= minTest && base <= maxTest) {
            Imager.getImager().clearImageCache();
            this.runImagerx(base);
            Assert.assertTrue((String)"catalogcount", (boolean)Settings.has("_totalCatalogCount"));
            Assert.assertTrue((String)"tableexists", (boolean)new File("out" + base + ".tab").exists());
            count1 = Integer.parseInt(Settings.get("_totalcatalogcount"));
            Util.regress("catquery_" + base + "_a", count1, os);
            Settings.restore();
        }
        Settings.put("catalogradius", "5");
        CatalogProcessor.clearRequests();
        if (++base >= minTest && base <= maxTest) {
            Imager.getImager().clearImageCache();
            this.runImagerx(base);
            count2 = Integer.parseInt(Settings.get("_totalcatalogcount"));
            Util.regress("catquery_" + base + "_b", count2, os);
            Assert.assertTrue((String)"radiusfilter", (count2 < count1 ? 1 : 0) != 0);
            Settings.restore();
        }
        Settings.put("catalogfilter", "instrument=hri");
        CatalogProcessor.clearRequests();
        if (++base >= minTest && base <= maxTest) {
            Imager.getImager().clearImageCache();
            this.runImagerx(base);
            count3 = Integer.parseInt(Settings.get("_totalcatalogcount"));
            Util.regress("catquery_" + base + "_c", count3, os);
            Assert.assertTrue((String)"fieldfilter", (count3 < count2 ? 1 : 0) != 0);
            Settings.restore();
        }
        Settings.put("catalogfilter", "instrument=hri,exposure>20000");
        CatalogProcessor.clearRequests();
        if (++base >= minTest && base <= maxTest) {
            Imager.getImager().clearImageCache();
            this.runImagerx(base);
            count3 = Integer.parseInt(Settings.get("_totalcatalogcount"));
            Util.regress("catquery_" + base + "_c", count3, os);
            Assert.assertTrue((String)"fieldfilter", (count3 < count2 ? 1 : 0) != 0);
            Settings.restore();
        }
        ++base;
        Settings.put("position", "289.95087909728574,64.35997524900246");
        Settings.put("survey", "dss");
        Settings.put("projection", "Tan");
        Settings.put("size", "0.1");
        Settings.put("catalogFilter", "null");
        Settings.put("catalogradius", "null");
        Settings.put("nofits", "null");
        Settings.put("pixels", "300");
        Settings.put("Scale", "null");
        Settings.put("catalog", "ned");
        CatalogProcessor.clearRequests();
        if (base >= minTest && base <= maxTest) {
            Imager.getImager().clearImageCache();
            this.runImagerx(base);
            System.err.println("test:" + Settings.get("scale"));
            count3 = Integer.parseInt(Settings.get("_totalcatalogcount"));
            Util.regress("catquery_" + base, count3, os);
            Settings.restore();
        }
        Settings.put("catalog", "I/284");
        if (++base >= minTest && base <= maxTest) {
            Imager.getImager().clearImageCache();
            this.runImagerx(base);
            count3 = Integer.parseInt(Settings.get("_totalcatalogcount"));
            Util.regress("catquery_" + base, count3, os);
            Settings.restore();
        }
        Settings.put("catalog", "http://heasarc.gsfc.nasa.gov/cgi-bin/vo/cone/coneGet.pl?table=rosmaster&");
        if (++base >= minTest && base <= maxTest) {
            Imager.getImager().clearImageCache();
            this.runImagerx(base);
            count3 = Integer.parseInt(Settings.get("_totalcatalogcount"));
            Util.regress("catquery_" + base, count3, os);
            Settings.restore();
        }
        Settings.put("catalog", "ned,I/284,http://heasarc.gsfc.nasa.gov/cgi-bin/vo/cone/coneGet.pl?table=rosmaster&");
        if (++base >= minTest && base <= maxTest) {
            Imager.getImager().clearImageCache();
            this.runImagerx(base);
            count3 = Integer.parseInt(Settings.get("_totalcatalogcount"));
            Util.regress("catquery_" + base, count3, os);
            Settings.restore();
        }
        Settings.put("catalog", "ned,I/284,http://heasarc.gsfc.nasa.gov/cgi-bin/vo/cone/coneGet.pl?table=rosmaster&");
        CatalogProcessor.clearRequests();
        if (++base >= minTest && base <= maxTest) {
            Imager.getImager().clearImageCache();
            this.runImagerx(base);
            count3 = Integer.parseInt(Settings.get("_totalcatalogcount"));
            Util.regress("catquery_" + base, count3, os);
            this.jpegCheck("catcomp", base, 300, 300);
            Settings.restore();
        }
        Settings.put("catalog", "ned");
        Settings.put("catalogfields", "");
        CatalogProcessor.clearRequests();
        if (++base >= minTest && base <= maxTest) {
            Imager.getImager().clearImageCache();
            this.runImagerx(base);
            Settings.restore();
        }
        ++base;
        Settings.put("catalog", "rosmaster");
        Settings.put("catalogfields", "");
        Settings.put("catalogfile", "mycat.file");
        Settings.put("catalogcolumns", "instrument,exposure");
        CatalogProcessor.clearRequests();
        if (base >= minTest && base <= maxTest) {
            Imager.getImager().clearImageCache();
            this.runImagerx(base);
            long sum = this.fileSum("mycat.file");
            Util.regress("catquery_" + base, sum, os);
            Settings.restore();
        }
        ++base;
        Settings.put("catalog", "null");
        Settings.put("catalogfields", "null");
        Settings.put("catalogids", "null");
        Settings.put("catalogradius", "null");
        Settings.put("catalogfile", "null");
        Settings.put("preprocessor", "null");
        Settings.put("postprocessor", "null");
        updateSettings = oldState;
    }

    @Test
    public void testLUT() throws Exception {
        Settings.put("survey", "dss");
        Settings.put("quicklook", "jpg");
        Settings.put("position", "187.27791499999998,2.052388");
        Settings.put("Coordinates", "J2000");
        Settings.put("pixels", "500");
        Settings.put("nofits", "");
        Settings.put("postprocessor", "null");
        boolean oldState = updateSettings;
        updateSettings = true;
        base = 1401;
        if (base >= minTest && base <= maxTest) {
            Imager.getImager().clearImageCache();
            this.runImagerx(base);
            this.jpegCheck("lutbase", base, 500, 500);
            Settings.restore();
        }
        Settings.put("invert", "");
        if (++base >= minTest && base <= maxTest) {
            Imager.getImager().clearImageCache();
            this.runImagerx(base);
            this.jpegCheck("lutinv", base, 500, 500);
            Settings.restore();
        }
        Settings.put("invert", "null");
        Settings.put("lut", "fire");
        if (++base >= minTest && base <= maxTest) {
            Imager.getImager().clearImageCache();
            this.runImagerx(base);
            this.jpegCheck("lutij", base, 500, 500);
            Settings.restore();
        }
        Settings.put("invert", "");
        if (++base >= minTest && base <= maxTest) {
            Imager.getImager().clearImageCache();
            this.runImagerx(base);
            this.jpegCheck("lutijinv", base, 500, 500);
            Settings.restore();
        }
        Settings.put("invert", "null");
        Settings.put("lut", "null");
        Settings.put("coltab", "green-pink");
        if (++base >= minTest && base <= maxTest) {
            Imager.getImager().clearImageCache();
            this.runImagerx(base);
            this.jpegCheck("lutbatch", base, 500, 500);
            Settings.restore();
        }
        Settings.put("coltab", "null");
        Settings.put("lut", "colortables/green-pink.bin");
        if (++base >= minTest && base <= maxTest) {
            Imager.getImager().clearImageCache();
            this.runImagerx(base);
            this.jpegCheck("lutijinv", base, 500, 500);
            Settings.restore();
        }
        ++base;
        Settings.put("lut", "null");
        Settings.put("nofits", "null");
        Settings.put("quicklook", "null");
        updateSettings = oldState;
    }

    @Test
    public void testRGB() throws Exception {
        Settings.put("survey", "iras100,iras25,rass3bb");
        Settings.put("position", "0.,0.");
        Settings.put("coordinates", "G");
        Settings.put("Pixels", "600,300");
        Settings.put("size", "40,20");
        Settings.put("rgb", "");
        base = 1501;
        if (base >= minTest && base <= maxTest) {
            Settings.put("output", "out" + base);
            Imager img = new Imager();
            new Imager().run();
            this.jpegRGBCheck("rgb", base, 600, 300);
        }
        Settings.put("rgbsmooth", "1,1,5");
        if (++base >= minTest && base <= maxTest) {
            Settings.put("output", "out" + base);
            new Imager().run();
            this.jpegRGBCheck("rgbsm", base, 600, 300);
        }
        Settings.put("rgbsmooth", "1,1,5");
        Settings.put("grid", "");
        Settings.put("gridlabels", "");
        if (++base >= minTest && base <= maxTest) {
            Settings.put("output", "out" + base);
            new Imager().run();
            this.jpegRGBCheck("rgbsmgrid", base, 600, 300);
        }
        ++base;
        Settings.put("rgb", "null");
        Settings.put("grid", "null");
        Settings.put("gridlabels", "null");
        Settings.put("rgbsmooth", "null");
    }

    @Test
    public void testScaling() throws Exception {
        Settings.put("survey", "iras100");
        Settings.put("position", "0.,0.");
        Settings.put("coordinates", "G");
        Settings.put("Pixels", "500");
        Settings.put("size", "10");
        Settings.put("nofits", "null");
        base = 1601;
        boolean oldState = updateSettings;
        updateSettings = true;
        Settings.put("scaling", "log");
        if (base >= minTest && base <= maxTest) {
            Imager.getImager().clearImageCache();
            this.runImagerx(base);
            this.jpegCheck("scalelog", base, 500, 500);
            Settings.restore();
        }
        Settings.put("scaling", "linear");
        if (++base >= minTest && base <= maxTest) {
            Imager.getImager().clearImageCache();
            this.runImagerx(base);
            this.jpegCheck("scalelin", base, 500, 500);
            Settings.restore();
        }
        Settings.put("scaling", "sqrt");
        if (++base >= minTest && base <= maxTest) {
            Imager.getImager().clearImageCache();
            this.runImagerx(base);
            this.jpegCheck("scalesqrt", base, 500, 500);
            Settings.restore();
        }
        Settings.put("scaling", "histeq");
        if (++base >= minTest && base <= maxTest) {
            Imager.getImager().clearImageCache();
            this.runImagerx(base);
            this.jpegCheck("scalehisteq", base, 500, 500);
            Settings.restore();
        }
        Settings.put("scaling", "log");
        Settings.put("min", "200");
        if (++base >= minTest && base <= maxTest) {
            Imager.getImager().clearImageCache();
            this.runImagerx(base);
            this.jpegCheck("scalelogmin", base, 500, 500);
            Settings.restore();
        }
        Settings.put("scaling", "log");
        Settings.put("max", "5000");
        if (++base >= minTest && base <= maxTest) {
            Imager.getImager().clearImageCache();
            this.runImagerx(base);
            this.jpegCheck("scalelogminmax", base, 500, 500);
            Settings.restore();
        }
        ++base;
        Settings.put("scaling", "null");
        Settings.put("min", "null");
        Settings.put("max", "null");
        updateSettings = oldState;
    }

    @Test
    public void testPlot() throws Exception {
        Settings.put("survey", "iras100");
        Settings.put("position", "0.,0.");
        Settings.put("coordinates", "G");
        Settings.put("Pixels", "500");
        Settings.put("size", "10");
        Settings.put("nofits", "null");
        boolean oldSettings = updateSettings;
        updateSettings = true;
        base = 1701;
        Settings.put("grid", "");
        Settings.put("gridlabels", "");
        Settings.put("catalog", "rosmaster");
        Settings.put("catalogids", "");
        if (base >= minTest && base <= maxTest) {
            CatalogProcessor.clearRequests();
            Imager.getImager().clearImageCache();
            this.runImagerx(base);
            this.jpegCheck("plotbasic", base, 500, 500);
            Settings.restore();
        }
        Settings.put("plotscale", "2");
        if (++base >= minTest && base <= maxTest) {
            CatalogProcessor.clearRequests();
            Imager.getImager().clearImageCache();
            this.runImagerx(base);
            this.jpegCheck("plotscale", base, 500, 500);
            Settings.restore();
        }
        Settings.put("plotscale", "3");
        Settings.put("plotfontsize", "20");
        if (++base >= minTest && base <= maxTest) {
            CatalogProcessor.clearRequests();
            Imager.getImager().clearImageCache();
            this.runImagerx(base);
            this.jpegCheck("plotscalefont", base, 500, 500);
            Settings.restore();
        }
        Settings.put("plotcolor", "green");
        Settings.put("lut", "grays");
        if (++base >= minTest && base <= maxTest) {
            CatalogProcessor.clearRequests();
            Imager.getImager().clearImageCache();
            this.runImagerx(base);
            this.jpegCheck("plotcolorFAILS", base, 500, 500);
            Settings.restore();
        }
        Settings.put("lut", "fire");
        if (++base >= minTest && base <= maxTest) {
            CatalogProcessor.clearRequests();
            Imager.getImager().clearImageCache();
            this.runImagerx(base);
            this.jpegCheck("plotcolorWORKS", base, 500, 500);
            Settings.restore();
        }
        Settings.put("draw", "50 50,-50 -50,,50 -50,-50 50");
        if (++base >= minTest && base <= maxTest) {
            CatalogProcessor.clearRequests();
            Imager.getImager().clearImageCache();
            this.runImagerx(base);
            this.jpegCheck("DrawX", base, 500, 500);
            Settings.restore();
        }
        Settings.put("draw", "null");
        Settings.put("drawfile", "plot1.drw");
        if (++base >= minTest && base <= maxTest) {
            CatalogProcessor.clearRequests();
            Imager.getImager().clearImageCache();
            this.runImagerx(base);
            this.jpegCheck("DrawFile1", base, 500, 500);
            Settings.restore();
        }
        Settings.put("drawfile", "plot1.drw");
        Settings.put("drawangle", "45");
        if (++base >= minTest && base <= maxTest) {
            CatalogProcessor.clearRequests();
            Imager.getImager().clearImageCache();
            this.runImagerx(base);
            this.jpegCheck("DrawAngle", base, 500, 500);
            Settings.restore();
        }
        Settings.put("drawangle", "null");
        Settings.put("drawfile", "plot2.drw");
        if (++base >= minTest && base <= maxTest) {
            CatalogProcessor.clearRequests();
            Imager.getImager().clearImageCache();
            this.runImagerx(base);
            this.jpegCheck("DrawFile2", base, 500, 500);
            Settings.restore();
        }
        ++base;
        Settings.put("plotcolor", "null");
        Settings.put("plotscale", "null");
        Settings.put("plotfontsize", "null");
        Settings.put("drawfile", "null");
        Settings.put("drawangle", "null");
        Settings.put("draw", "null");
        Settings.put("grid", "null");
        Settings.put("gridlabels", "null");
        Settings.put("catalog", "null");
        Settings.put("catalogids", "null");
    }

    static {
        first = true;
        minTest = 0;
        maxTest = Integer.MAX_VALUE;
        base = 1;
        updateSettings = false;
    }
}

