/*
 * Decompiled with CFR 0.152.
 */
package jsky.catalog.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashSet;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import jsky.catalog.BasicQueryArgs;
import jsky.catalog.Catalog;
import jsky.catalog.CatalogDirectory;
import jsky.catalog.HTMLQueryResultHandler;
import jsky.catalog.QueryArgs;
import jsky.catalog.QueryResult;
import jsky.catalog.QueryResultHandler;
import jsky.catalog.URLQueryResult;
import jsky.catalog.gui.CatalogDirectoryChooser;
import jsky.catalog.gui.CatalogNavigator;
import jsky.catalog.gui.CatalogTreeCellRenderer;
import jsky.catalog.gui.CatalogTreeControlPanel;
import jsky.catalog.gui.CatalogTreeModel;
import jsky.catalog.gui.QueryResultDisplay;
import jsky.util.I18N;
import jsky.util.Resources;
import jsky.util.SwingWorker;
import jsky.util.gui.BasicWindowMonitor;
import jsky.util.gui.ClipboardHelper;
import jsky.util.gui.DialogUtil;
import jsky.util.gui.ProgressPanel;
import jsky.util.gui.SwingUtil;

public class CatalogTree
extends JPanel
implements QueryResultDisplay,
QueryResultHandler,
TreeModelListener {
    private static final I18N _I18N = I18N.getInstance(CatalogTree.class);
    private JTree _tree;
    private boolean _ignoreSelection = false;
    private HTMLQueryResultHandler _htmlQueryResultHandler;
    private QueryResultDisplay _queryResultDisplay;
    private CatalogDirectory _rootCatDir;
    private CatalogLoader _loader;
    private ProgressPanel _progressPanel;
    private JPopupMenu _nodeMenu;
    private AbstractAction _cutAction = new AbstractAction(_I18N.getString("cut"), Resources.getIcon((String)"Cut24.gif")){
        {
            this.putValue("ShortDescription", _I18N.getString("cutTip"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            try {
                CatalogTree.this._cut();
            }
            catch (Exception e) {
                DialogUtil.error((Exception)e);
            }
        }
    };
    private AbstractAction _copyAction = new AbstractAction(_I18N.getString("copy"), Resources.getIcon((String)"Copy24.gif")){
        {
            this.putValue("ShortDescription", _I18N.getString("copyTip"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            try {
                CatalogTree.this._copy();
            }
            catch (Exception e) {
                DialogUtil.error((Exception)e);
            }
        }
    };
    private AbstractAction _pasteAction = new AbstractAction(_I18N.getString("paste"), Resources.getIcon((String)"Paste24.gif")){
        {
            this.putValue("ShortDescription", _I18N.getString("pasteTip"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            try {
                CatalogTree.this._paste();
            }
            catch (Exception e) {
                DialogUtil.error((Exception)e);
            }
        }
    };
    private AbstractAction _addToFavoritesAction = new AbstractAction(_I18N.getString("addToFavorites")){
        {
            this.putValue("ShortDescription", _I18N.getString("addToFavoritesTip"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            try {
                CatalogTree.this._addToFavorites();
            }
            catch (Exception e) {
                DialogUtil.error((Exception)e);
            }
        }
    };
    private AbstractAction _refreshSelectedAction = new AbstractAction(_I18N.getString("refreshSelected")){
        {
            this.putValue("ShortDescription", _I18N.getString("refreshSelectedTip"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            try {
                CatalogTree.this._refreshSelected();
            }
            catch (Exception e) {
                DialogUtil.error((Exception)e);
            }
        }
    };
    private AbstractAction _configureCatalogDirectoriesAction = new AbstractAction(_I18N.getString("configureCatalogDirectories")){
        {
            this.putValue("ShortDescription", _I18N.getString("configureCatalogDirectoriesTip"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            try {
                CatalogTree.this._configureCatDirs();
            }
            catch (Exception e) {
                DialogUtil.error((Exception)e);
            }
        }
    };
    private AbstractAction _moveUpAction = new AbstractAction(_I18N.getString("moveUp")){

        @Override
        public void actionPerformed(ActionEvent evt) {
            try {
                CatalogTree.this._moveNode(true);
            }
            catch (Exception e) {
                DialogUtil.error((Exception)e);
            }
        }
    };
    private AbstractAction _moveDownAction = new AbstractAction(_I18N.getString("moveDown")){

        @Override
        public void actionPerformed(ActionEvent evt) {
            try {
                CatalogTree.this._moveNode(false);
            }
            catch (Exception e) {
                DialogUtil.error((Exception)e);
            }
        }
    };
    private AbstractAction _toTopAction = new AbstractAction(_I18N.getString("toTop")){

        @Override
        public void actionPerformed(ActionEvent evt) {
            try {
                CatalogTree.this._moveNodeToEnd(true);
            }
            catch (Exception e) {
                DialogUtil.error((Exception)e);
            }
        }
    };
    private AbstractAction _toBottomAction = new AbstractAction(_I18N.getString("toBottom")){

        @Override
        public void actionPerformed(ActionEvent evt) {
            try {
                CatalogTree.this._moveNodeToEnd(false);
            }
            catch (Exception e) {
                DialogUtil.error((Exception)e);
            }
        }
    };
    private CatalogTreeControlPanel _controlPanel;

    public CatalogTree() {
        this.setMinimumSize(new Dimension(300, 250));
        this._tree = new JTree();
        this._tree.setModel(new DefaultTreeModel(new DefaultMutableTreeNode("One moment please...")));
        this._loadCatalogDirectory();
        this._tree.setShowsRootHandles(true);
        this._tree.setBackground(this.getBackground());
        this._tree.setExpandsSelectedPaths(true);
        this._tree.setScrollsOnExpand(true);
        this._cutAction.setEnabled(false);
        this._copyAction.setEnabled(false);
        this._pasteAction.setEnabled(false);
        this._toTopAction.setEnabled(false);
        this._moveUpAction.setEnabled(false);
        this._moveDownAction.setEnabled(false);
        this._toBottomAction.setEnabled(false);
        this._addToFavoritesAction.setEnabled(false);
        this._configureCatalogDirectoriesAction.setEnabled(false);
        this._nodeMenu = this.makeNodeMenu();
        this._tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    CatalogTree.this._nodeMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    CatalogTree.this._nodeMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        this._tree.setCellRenderer(this._getTreeCellRenderer());
        ToolTipManager.sharedInstance().registerComponent(this._tree);
        this._tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                try {
                    CatalogTree.this._nodeSelected();
                    CatalogTree.this.updateEnabledStates();
                }
                catch (Exception ex) {
                    DialogUtil.error((Exception)ex);
                }
            }
        });
        JScrollPane scrollPane = new JScrollPane(this._tree);
        this._controlPanel = this._makeControlPanel();
        this._controlPanel.setEnabled(false);
        this.setLayout(new BorderLayout());
        this.add((Component)scrollPane, "Center");
        this.add((Component)this._controlPanel, "North");
    }

    private CatalogTreeControlPanel _makeControlPanel() {
        CatalogTreeControlPanel panel = new CatalogTreeControlPanel();
        ActionListener l = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CatalogTree.this._updateTreeModel();
                CatalogTree.this._expandAll();
            }
        };
        panel.getFilterTextField().addActionListener(l);
        panel.getCatalogButton().addActionListener(l);
        panel.getArchiveButton().addActionListener(l);
        panel.getImageServerButton().addActionListener(l);
        panel.getNameServerButton().addActionListener(l);
        panel.getExpandButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CatalogTree.this._expandAll();
            }
        });
        panel.getCollapseButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CatalogTree.this._collapseAll();
            }
        });
        this._setMacButtonProperties(panel.getCatalogButton(), "first");
        this._setMacButtonProperties(panel.getArchiveButton(), "middle");
        this._setMacButtonProperties(panel.getImageServerButton(), "middle");
        this._setMacButtonProperties(panel.getNameServerButton(), "last");
        this._setMacButtonProperties(panel.getExpandButton(), "first");
        this._setMacButtonProperties(panel.getCollapseButton(), "last");
        return panel;
    }

    private void _setMacButtonProperties(AbstractButton button, String pos) {
        button.putClientProperty("JButton.buttonType", "segmentedTextured");
        button.putClientProperty("JButton.segmentPosition", pos);
        button.setFocusable(false);
    }

    private void _expandAll() {
        TreeModel model = this._tree.getModel();
        this._expandAll(model, (DefaultMutableTreeNode)model.getRoot());
    }

    private void _expandAll(TreeModel model, DefaultMutableTreeNode treeNode) {
        TreePath path = new TreePath(treeNode.getPath());
        if (this._tree.isCollapsed(path)) {
            this._tree.expandPath(path);
        }
        int n = model.getChildCount(treeNode);
        for (int i = 0; i < n; ++i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)model.getChild(treeNode, i);
            this._expandAll(model, node);
        }
    }

    private void _collapseAll() {
        TreeModel model = this._tree.getModel();
        Object root = model.getRoot();
        int n = model.getChildCount(root);
        for (int i = 0; i < n; ++i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)model.getChild(root, i);
            this._collapseAll(model, node);
        }
    }

    private void _collapseAll(TreeModel model, DefaultMutableTreeNode treeNode) {
        TreePath path = new TreePath(treeNode.getPath());
        if (!this._tree.isCollapsed(path)) {
            this._tree.collapsePath(path);
        }
        int n = model.getChildCount(treeNode);
        for (int i = 0; i < n; ++i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)model.getChild(treeNode, i);
            this._collapseAll(model, node);
        }
    }

    public void setHTMLQueryResultHandler(HTMLQueryResultHandler handler) {
        this._htmlQueryResultHandler = handler;
    }

    private TreeCellRenderer _getTreeCellRenderer() {
        return new CatalogTreeCellRenderer();
    }

    public void setQueryResultDisplay(QueryResultDisplay q) {
        this._queryResultDisplay = q;
    }

    public QueryResultDisplay getQueryResultDisplay() {
        return this._queryResultDisplay;
    }

    public JTree getTree() {
        return this._tree;
    }

    public void setQueryResult(QueryResult queryResult) {
        if (queryResult instanceof URLQueryResult) {
            this._addURLQueryResult(null, ((URLQueryResult)queryResult).getURL());
        } else if (queryResult instanceof CatalogDirectory) {
            this._rootCatDir = (CatalogDirectory)queryResult;
            this._updateTreeModel();
            this._rootCatDir.removeTreeModelListener((TreeModelListener)this);
            this._rootCatDir.addTreeModelListener((TreeModelListener)this);
        } else {
            throw new RuntimeException("Expected a CatalogDirectory object, not: " + queryResult);
        }
    }

    private void _updateTreeModel() {
        TreeModel model = this._makeTreeModel();
        this._tree.setModel(model);
        this._controlPanel.setEnabled(true);
    }

    private TreeModel _makeTreeModel() {
        String filter = this._controlPanel.getFilterTextField().getText();
        HashSet<String> types = new HashSet<String>();
        if (this._controlPanel.getCatalogButton().isSelected()) {
            types.add("catalog");
        }
        if (this._controlPanel.getArchiveButton().isSelected()) {
            types.add("archive");
        }
        if (this._controlPanel.getImageServerButton().isSelected()) {
            types.add("imagesvr");
        }
        if (this._controlPanel.getNameServerButton().isSelected()) {
            types.add("namesvr");
        }
        return new CatalogTreeModel(this._rootCatDir, filter, types);
    }

    private void _addURLQueryResult(Catalog node, URL url) {
        if (this._progressPanel == null) {
            this._progressPanel = ProgressPanel.makeProgressPanel((String)_I18N.getString("downloadingCatalogDesc"), (Component)this);
        }
        if (this._loader == null) {
            this._loader = new CatalogLoader(node, url);
            this._loader.start();
        }
    }

    private void _nodeSelected() {
        if (this._ignoreSelection) {
            return;
        }
        Catalog cat = this.getSelectedCatalog();
        if (cat == null) {
            return;
        }
        if (cat == this._rootCatDir) {
            if (this._queryResultDisplay != null) {
                this._queryResultDisplay.setQueryResult(null);
            }
            return;
        }
        this._addCatalog(cat, cat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedCatalog(Catalog cat, boolean ignoreSelection) {
        if (ignoreSelection) {
            this._ignoreSelection = true;
        }
        try {
            CatalogTreeModel model = (CatalogTreeModel)this._tree.getModel();
            TreePath path = model.getTreePath(cat);
            if (path != null) {
                this._tree.clearSelection();
                this._tree.setSelectionPath(path);
                this._tree.scrollPathToVisible(path);
            }
        }
        finally {
            if (ignoreSelection) {
                this._ignoreSelection = false;
            }
        }
    }

    public Catalog getSelectedCatalog() {
        Object o;
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this._tree.getLastSelectedPathComponent();
        if (node != null && (o = node.getUserObject()) instanceof Catalog) {
            return (Catalog)o;
        }
        return null;
    }

    public void addQueryResult(QueryResult queryResult) {
        Catalog selectedCatalog = this.getSelectedCatalog();
        if (selectedCatalog == null) {
            this.setQueryResult(queryResult);
        } else {
            this._addQueryResult(selectedCatalog, queryResult);
        }
    }

    private void _addQueryResult(Catalog node, QueryResult queryResult) {
        if (queryResult instanceof URLQueryResult) {
            this._addURLQueryResult(node, ((URLQueryResult)queryResult).getURL());
        } else if (!(queryResult instanceof CatalogDirectory) && queryResult instanceof Catalog) {
            this._addCatalog(node, (Catalog)queryResult);
        }
    }

    private void _addCatalog(Catalog node, Catalog catalog) {
        if (this._queryResultDisplay != null) {
            if (catalog.getNumParams() == 0) {
                QueryResult queryResult;
                try {
                    queryResult = catalog.query((QueryArgs)new BasicQueryArgs(catalog));
                }
                catch (Exception e) {
                    DialogUtil.error((Exception)e);
                    return;
                }
                this._addQueryResult(node, queryResult);
            } else {
                this._queryResultDisplay.setQueryResult((QueryResult)catalog);
            }
        }
    }

    private void _displayQueryResult(Catalog node, CatalogDirectory catDir) {
        CatalogDirectory queryResult = catDir;
        if (catDir.getNumCatalogs() == 1) {
            queryResult = catDir.getCatalog(0);
        }
        if (node == null) {
            this.setQueryResult((QueryResult)queryResult);
        } else {
            this._addQueryResult(node, (QueryResult)queryResult);
        }
    }

    private JPopupMenu makeNodeMenu() {
        JPopupMenu menu = new JPopupMenu();
        menu.add(this._addToFavoritesAction);
        menu.add(this._refreshSelectedAction);
        menu.addSeparator();
        menu.add(this._cutAction);
        menu.add(this._copyAction);
        menu.add(this._pasteAction);
        menu.addSeparator();
        menu.add(this._toTopAction);
        menu.add(this._moveUpAction);
        menu.add(this._moveDownAction);
        menu.add(this._toBottomAction);
        return menu;
    }

    public JMenuItem makeReloadMenuItem() {
        JMenuItem menuItem = new JMenuItem(_I18N.getString("reloadConfigFile"));
        menuItem.setToolTipText(_I18N.getString("reloadConfigFileTip"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                CatalogTree.this._reload();
            }
        });
        return menuItem;
    }

    private void _loadCatalogDirectory() {
        new SwingWorker(){

            public Object construct() {
                try {
                    return CatalogNavigator.getCatalogDirectory();
                }
                catch (Exception e) {
                    return e;
                }
            }

            public void finished() {
                Object o = this.getValue();
                if (o instanceof CatalogDirectory) {
                    CatalogTree.this._rootCatDir = (CatalogDirectory)o;
                    CatalogTree.this.setQueryResult((QueryResult)CatalogTree.this._rootCatDir);
                } else if (o instanceof Exception) {
                    DialogUtil.error((Exception)((Exception)o));
                }
            }
        }.start();
    }

    private void _reload() {
        new SwingWorker(){

            public Object construct() {
                try {
                    return CatalogTree.this._rootCatDir.reload();
                }
                catch (Exception e) {
                    return e;
                }
            }

            public void finished() {
                Object o = this.getValue();
                if (o instanceof CatalogDirectory) {
                    CatalogTree.this._rootCatDir = (CatalogDirectory)o;
                    CatalogTree.this.setQueryResult((QueryResult)CatalogTree.this._rootCatDir);
                } else if (o instanceof Exception) {
                    DialogUtil.error((Exception)((Exception)o));
                }
            }
        }.start();
    }

    private void _configureCatDirs() {
        CatalogDirectoryChooser catDirChooser = new CatalogDirectoryChooser(SwingUtil.getFrame((Component)this));
        catDirChooser.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                CatalogTree.this.setQueryResult((QueryResult)CatalogTree.this._rootCatDir);
            }
        });
        catDirChooser.setVisible(true);
    }

    public QueryResult getQueryResult(URL url) throws IOException {
        URLConnection connection = url.openConnection();
        String contentType = connection.getContentType();
        if (contentType == null || !contentType.equals("text/html")) {
            CatalogDirectory dir;
            CatalogDirectory parentDir = this._rootCatDir;
            Catalog selectedNode = this.getSelectedCatalog();
            if (selectedNode != null && selectedNode != this._rootCatDir && (dir = selectedNode.getParent()) != null) {
                parentDir = dir;
            }
            return parentDir.loadSubDir(url);
        }
        this._htmlQueryResultHandler.displayHTMLPage(url);
        throw new RuntimeException(_I18N.getString("urlAccessError") + ": " + url.toString());
    }

    private void updateEnabledStates() {
        Catalog selectedNode = this.getSelectedCatalog();
        if (selectedNode == null) {
            return;
        }
        CatalogDirectory parent = selectedNode.getParent();
        boolean topLevel = parent == this._rootCatDir;
        boolean editable = topLevel && !(selectedNode instanceof CatalogDirectory);
        this._cutAction.setEnabled(editable);
        this._copyAction.setEnabled(!(selectedNode instanceof CatalogDirectory));
        this._addToFavoritesAction.setEnabled(!editable && !(selectedNode instanceof CatalogDirectory));
        this._pasteAction.setEnabled(ClipboardHelper.getClipboard() instanceof Catalog);
        this._toTopAction.setEnabled(topLevel);
        this._moveUpAction.setEnabled(topLevel);
        this._moveDownAction.setEnabled(topLevel);
        this._toBottomAction.setEnabled(topLevel);
        this._configureCatalogDirectoriesAction.setEnabled(true);
    }

    private void _cut() {
        Catalog selectedNode = this.getSelectedCatalog();
        if (selectedNode == null) {
            return;
        }
        ClipboardHelper.setClipboard((Object)selectedNode);
        this._rootCatDir.removeCatalog(selectedNode);
        this._rootCatDir.save();
        this._updateTreeModel();
    }

    private void _copy() {
        Catalog selectedNode = this.getSelectedCatalog();
        if (selectedNode == null) {
            return;
        }
        ClipboardHelper.setClipboard((Object)selectedNode);
    }

    private void _paste() {
        Object o = ClipboardHelper.getClipboard();
        if (o instanceof Catalog) {
            Catalog cat = (Catalog)o;
            this._rootCatDir.addCatalog(0, cat);
            this._rootCatDir.save();
            this._updateTreeModel();
        } else if (o == null) {
            DialogUtil.error((String)_I18N.getString("noCatalogObjInClipboard"));
        } else {
            DialogUtil.error((String)_I18N.getString("noSuitableObjInClipboard"));
        }
    }

    private void _addToFavorites() {
        Catalog selectedCatalog = this.getSelectedCatalog();
        if (selectedCatalog == null) {
            return;
        }
        this._rootCatDir.addCatalog(0, selectedCatalog);
        this._rootCatDir.save();
        this._updateTreeModel();
        this.setSelectedCatalog(selectedCatalog, true);
        this._expandAll();
    }

    private void _refreshSelected() {
        final Catalog selectedCatalog = this.getSelectedCatalog();
        if (selectedCatalog == this._rootCatDir) {
            this._reload();
            return;
        }
        new SwingWorker(){

            public Object construct() {
                try {
                    return selectedCatalog.reload();
                }
                catch (Exception e) {
                    return e;
                }
            }

            public void finished() {
                Object o = this.getValue();
                if (o instanceof Catalog) {
                    Catalog cat = (Catalog)o;
                    selectedCatalog.getParent().replaceCatalog(selectedCatalog, cat);
                    CatalogTree.this.setQueryResult((QueryResult)CatalogTree.this._rootCatDir);
                    CatalogTree.this.setSelectedCatalog(cat, false);
                } else if (o instanceof Exception) {
                    DialogUtil.error((Exception)((Exception)o));
                }
            }
        }.start();
    }

    private void _moveNode(boolean up) {
        Catalog selectedNode = this.getSelectedCatalog();
        if (selectedNode == null) {
            return;
        }
        this._rootCatDir.moveCatalog(selectedNode, up);
        this._rootCatDir.save();
        this._updateTreeModel();
    }

    private void _moveNodeToEnd(boolean up) {
        Catalog selectedNode = this.getSelectedCatalog();
        if (selectedNode == null) {
            return;
        }
        this._rootCatDir.moveCatalogToEnd(selectedNode, up);
        this._rootCatDir.save();
        this._updateTreeModel();
    }

    public AbstractAction getCutAction() {
        return this._cutAction;
    }

    public AbstractAction getCopyAction() {
        return this._copyAction;
    }

    public AbstractAction getPasteAction() {
        return this._pasteAction;
    }

    public AbstractAction getMoveUpAction() {
        return this._moveUpAction;
    }

    public AbstractAction getMoveDownAction() {
        return this._moveDownAction;
    }

    public AbstractAction getToTopAction() {
        return this._toTopAction;
    }

    public AbstractAction getToBottomAction() {
        return this._toBottomAction;
    }

    public AbstractAction getConfigureCatalogDirectoriesAction() {
        return this._configureCatalogDirectoriesAction;
    }

    @Override
    public void treeNodesChanged(TreeModelEvent e) {
        this.setQueryResult((QueryResult)CatalogNavigator.getCatalogDirectory(false));
    }

    @Override
    public void treeNodesInserted(TreeModelEvent e) {
        this.setQueryResult((QueryResult)CatalogNavigator.getCatalogDirectory(false));
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent e) {
        this.setQueryResult((QueryResult)CatalogNavigator.getCatalogDirectory(false));
    }

    @Override
    public void treeStructureChanged(TreeModelEvent e) {
        this.setQueryResult((QueryResult)CatalogNavigator.getCatalogDirectory(false));
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame("CatalogTree");
                CatalogTree catTree = new CatalogTree();
                frame.getContentPane().add((Component)catTree, "Center");
                frame.pack();
                frame.setVisible(true);
                frame.addWindowListener((WindowListener)new BasicWindowMonitor());
            }
        });
    }

    private class CatalogLoader
    extends SwingWorker {
        private Catalog _node;
        private URL _url;

        public CatalogLoader(Catalog node, URL url) {
            this._node = node;
            this._url = url;
            CatalogTree.this._progressPanel.start();
        }

        public Object construct() {
            try {
                return CatalogTree.this.getQueryResult(this._url);
            }
            catch (Exception e) {
                return e;
            }
        }

        public void finished() {
            CatalogTree.this._progressPanel.stop();
            CatalogTree.this._loader = null;
            Object result = this.getValue();
            if (result instanceof Exception) {
                DialogUtil.error((Exception)((Exception)result));
                return;
            }
            if (result == null || !(result instanceof QueryResult)) {
                DialogUtil.error((String)(_I18N.getString("urlLoadError") + ": " + this._url.toString()));
                return;
            }
            if (result instanceof CatalogDirectory) {
                CatalogTree.this._displayQueryResult(this._node, (CatalogDirectory)result);
            } else if (CatalogTree.this._queryResultDisplay != null) {
                CatalogTree.this._queryResultDisplay.setQueryResult((QueryResult)new URLQueryResult(this._url));
            }
        }
    }
}

