/*
 * Decompiled with CFR 0.152.
 */
package jsky.interop;

import java.util.Map;
import java.util.logging.Logger;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.astrogrid.samp.Client;
import org.astrogrid.samp.Response;
import org.astrogrid.samp.client.HubConnection;
import org.astrogrid.samp.client.ResponseHandler;
import org.astrogrid.samp.client.SampException;
import org.astrogrid.samp.gui.GuiHubConnector;
import org.astrogrid.samp.gui.SubscribedClientListModel;

public class SendManager {
    private final GuiHubConnector connector_;
    private final SendComboBoxModel comboBoxModel_;
    private final String mtype_;
    private String tag_;
    private static final Object BROADCAST = "All Clients";
    private static final Logger logger_ = Logger.getLogger(SendManager.class.getName());

    public SendManager(GuiHubConnector connector, String mtype) {
        this.connector_ = connector;
        this.mtype_ = mtype;
        this.comboBoxModel_ = new SendComboBoxModel((ListModel)new SubscribedClientListModel(connector, mtype));
    }

    public ComboBoxModel getComboBoxModel() {
        return this.comboBoxModel_;
    }

    public void notify(Map message) throws SampException {
        HubConnection connection = this.connector_.getConnection();
        if (connection != null) {
            Client client = this.comboBoxModel_.getClient();
            if (client == null) {
                connection.notifyAll(message);
            } else {
                connection.notify(client.getId(), message);
            }
        }
    }

    public void call(Map message) throws SampException {
        HubConnection connection = this.connector_.getConnection();
        if (connection != null) {
            Client client = this.comboBoxModel_.getClient();
            if (client == null) {
                connection.callAll(this.getTag(), message);
            } else {
                connection.call(client.getId(), this.getTag(), message);
            }
        }
    }

    private synchronized String getTag() {
        if (this.tag_ == null) {
            final String tag = this.connector_.createTag((Object)this);
            ResponseHandler handler = new ResponseHandler(){

                public boolean ownsTag(String msgTag) {
                    return tag.equals(msgTag);
                }

                public void receiveResponse(HubConnection connection, String responderId, String msgTag, Response response) {
                    if (response.isOK()) {
                        logger_.info("Success response for " + SendManager.this.mtype_ + " from " + responderId);
                    } else {
                        logger_.warning("Error response for " + SendManager.this.mtype_ + " from " + responderId + ": " + response.getStatus());
                    }
                }
            };
            this.connector_.addResponseHandler(handler);
            this.tag_ = tag;
        }
        return this.tag_;
    }

    private static class SendComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        private final ListModel clientListModel_;
        private Object selectedItem_ = SendManager.access$200();

        SendComboBoxModel(ListModel clientListModel) {
            this.clientListModel_ = clientListModel;
            this.clientListModel_.addListDataListener(new ListDataListener(){

                @Override
                public void contentsChanged(ListDataEvent evt) {
                    this.fireContentsChanged(evt.getSource(), this.adjustIndex(evt.getIndex0()), this.adjustIndex(evt.getIndex1()));
                }

                @Override
                public void intervalAdded(ListDataEvent evt) {
                    this.fireIntervalAdded(evt.getSource(), this.adjustIndex(evt.getIndex0()), this.adjustIndex(evt.getIndex1()));
                }

                @Override
                public void intervalRemoved(ListDataEvent evt) {
                    this.fireIntervalRemoved(evt.getSource(), this.adjustIndex(evt.getIndex0()), this.adjustIndex(evt.getIndex1()));
                }

                private int adjustIndex(int index) {
                    return index >= 0 ? index + 1 : index;
                }
            });
        }

        @Override
        public int getSize() {
            return this.clientListModel_.getSize() + 1;
        }

        @Override
        public Object getElementAt(int index) {
            return index == 0 ? BROADCAST : this.clientListModel_.getElementAt(index - 1);
        }

        @Override
        public Object getSelectedItem() {
            return this.selectedItem_;
        }

        @Override
        public void setSelectedItem(Object item) {
            this.selectedItem_ = item;
        }

        public Client getClient() {
            return this.selectedItem_ instanceof Client ? (Client)this.selectedItem_ : null;
        }
    }
}

