/*
 * Decompiled with CFR 0.152.
 */
package jsky.image.fits.codec;

import com.sun.media.jai.codec.ForwardSeekableStream;
import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codec.ImageDecodeParam;
import com.sun.media.jai.codec.ImageDecoder;
import com.sun.media.jai.codec.ImageEncodeParam;
import com.sun.media.jai.codec.ImageEncoder;
import com.sun.media.jai.codec.SeekableStream;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.InputStream;
import java.io.OutputStream;
import jsky.image.fits.codec.FITSDecoder;
import jsky.image.fits.codec.FITSEncodeParam;
import jsky.image.fits.codec.FITSEncoder;

public final class FITSCodec
extends ImageCodec {
    public String getFormatName() {
        return "fits";
    }

    public Class getDecodeParamClass() {
        return Object.class;
    }

    public Class getEncodeParamClass() {
        return null;
    }

    public boolean canEncodeImage(RenderedImage im, ImageEncodeParam param) {
        SampleModel sampleModel = im.getSampleModel();
        int numBands = sampleModel.getNumBands();
        return numBands == 1;
    }

    protected ImageEncoder createImageEncoder(OutputStream dst, ImageEncodeParam param) {
        FITSEncodeParam p = null;
        if (param != null) {
            p = (FITSEncodeParam)param;
        }
        return new FITSEncoder(dst, p);
    }

    protected ImageDecoder createImageDecoder(InputStream src, ImageDecodeParam param) {
        try {
            return new FITSDecoder((SeekableStream)new ForwardSeekableStream(src), param);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected ImageDecoder createImageDecoder(SeekableStream src, ImageDecodeParam param) {
        try {
            return new FITSDecoder(src, param);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public int getNumHeaderBytes() {
        return 6;
    }

    public boolean isFormatRecognized(byte[] header) {
        return header[0] == 83 && header[1] == 73 && header[2] == 77 && header[3] == 80 && header[4] == 76 && header[5] == 69;
    }
}

