/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.UCD;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.util.MapGroup;

public class ValueInfoMapGroup
extends MapGroup {
    public static final String INDEX_KEY = "Index";
    public static final String NAME_KEY = "Name";
    public static final String VALUE_KEY = "Value";
    public static final String CLASS_KEY = "Class";
    public static final String SHAPE_KEY = "Shape";
    public static final String UNITS_KEY = "Units";
    public static final String DESCRIPTION_KEY = "Description";
    public static final String UCD_KEY = "UCD";
    public static final String UCD_DESCRIPTION_KEY = "UCD description";
    public static final String NULLABLE_KEY = "Nullable";
    private static final List keyOrder = Arrays.asList("Index", "Name", "Class", "Shape", "Value", "Units", "Description", "UCD", "UCD description", "Nullable");
    private static final int MAX_STRING_LENGTH = 1024;

    public ValueInfoMapGroup() {
        this.setKeyOrder(keyOrder);
    }

    public ValueInfoMapGroup(StarTable startab) {
        this();
        this.addTableColumns(startab);
    }

    public void addValueInfo(ValueInfo info) {
        this.addMap(ValueInfoMapGroup.makeMap(info));
    }

    public void addDescribedValue(DescribedValue dval) {
        this.addMap(ValueInfoMapGroup.makeMap(dval));
    }

    public void addTableColumns(StarTable startab) {
        this.addColumnAuxDataKeys(startab);
        int ncol = startab.getColumnCount();
        for (int i = 0; i < ncol; ++i) {
            ColumnInfo colinfo = startab.getColumnInfo(i);
            Map map = ValueInfoMapGroup.makeMap(colinfo);
            map.put(INDEX_KEY, new Integer(i + 1));
            this.addMap(map);
        }
    }

    public void addColumnAuxDataKeys(StarTable startab) {
        List order = this.getKeyOrder();
        Iterator it = startab.getColumnAuxDataInfos().iterator();
        while (it.hasNext()) {
            Object item = it.next();
            if (!(item instanceof ValueInfo)) continue;
            ValueInfo info = (ValueInfo)item;
            order.add(info.getName());
        }
        this.setKeyOrder(order);
    }

    public static Map makeMap(ColumnInfo colinfo) {
        Map map = ValueInfoMapGroup.makeMap((ValueInfo)colinfo);
        Iterator it = colinfo.getAuxData().iterator();
        while (it.hasNext()) {
            Object item = it.next();
            if (!(item instanceof DescribedValue)) continue;
            DescribedValue dval = (DescribedValue)item;
            map.put(dval.getInfo().getName(), dval.getValueAsString(1024));
        }
        return map;
    }

    public static Map makeMap(ValueInfo info) {
        String ucdname;
        String description;
        String units;
        HashMap<String, String> map = new HashMap<String, String>();
        String name = info.getName();
        if (name != null) {
            map.put(NAME_KEY, name);
        }
        map.put(CLASS_KEY, DefaultValueInfo.formatClass(info.getContentClass()));
        if (info.isArray()) {
            map.put(SHAPE_KEY, DefaultValueInfo.formatShape(info.getShape()));
        }
        if ((units = info.getUnitString()) != null) {
            map.put(UNITS_KEY, units);
        }
        if ((description = info.getDescription()) != null && description.length() > 0) {
            map.put(DESCRIPTION_KEY, description);
        }
        if ((ucdname = info.getUCD()) != null) {
            map.put(UCD_KEY, ucdname);
            UCD ucd = UCD.getUCD(ucdname);
            String ucdesc = ucd != null ? ucd.getDescription() : "<unknown UCD>";
            map.put(UCD_DESCRIPTION_KEY, ucdesc);
        }
        return map;
    }

    public static Map makeMap(DescribedValue dval) {
        Map map = ValueInfoMapGroup.makeMap(dval.getInfo());
        map.put(VALUE_KEY, dval.getValueAsString(1024));
        return map;
    }
}

