/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.gui;

import java.awt.Font;
import java.lang.reflect.Array;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class NumericCellRenderer
extends DefaultTableCellRenderer {
    public static final int MAX_SHOW_ELEMENTS = 10;
    private NumberFormat sciFormatDouble;
    private NumberFormat sciFormatFloat;
    private NumberFormat fixFormatDouble;
    private NumberFormat fixFormatFloat0;
    private NumberFormat fixFormatFloat1;
    private NumberFormat fixFormatFloat2;
    private NumberFormat fixFormatFloat3;
    private NumberFormat fixFormatFloat4;
    private NumberFormat fixFormatFloat5;
    private NumberFormat fixFormatFloat6;
    private NumberFormat intFormat;
    private NumberFormat longFormat;
    private char decimalPoint;
    private String decimalPointString;
    private boolean likeHeading;
    private String badText;
    private Object badValue = new Object();
    private Class clazz;
    private Font font;
    private static JTable dummyTable;
    static final /* synthetic */ boolean $assertionsDisabled;

    public NumericCellRenderer(Class clazz) {
        this.clazz = clazz;
        if (Number.class.isAssignableFrom(clazz)) {
            this.setHorizontalAlignment(4);
            this.font = new Font("Monospaced", 0, this.getFont().getSize());
        } else {
            this.setHorizontalAlignment(2);
        }
        this.intFormat = NumberFormat.getInstance();
        if (this.intFormat instanceof DecimalFormat) {
            ((DecimalFormat)this.intFormat).applyPattern(" #########0;-#########0");
        }
        this.badText = "";
    }

    public void setCellFont(Font font) {
        this.font = font;
    }

    public Font getCellFont() {
        return this.font;
    }

    protected void setValue(Object value) {
        Object obj;
        this.setText(null);
        if (this.isBadValue(value)) {
            this.setText(this.badText);
            return;
        }
        if (value == null) {
            return;
        }
        if (this.font != null) {
            this.setFont(this.font);
        }
        if (value.getClass().getComponentType() != null) {
            int nel = Array.getLength(value);
            if (nel == 0) {
                return;
            }
            if (nel > 1) {
                int limit = Math.min(nel, 10);
                StringBuffer sbuf = new StringBuffer(" (");
                for (int i = 0; i < limit; ++i) {
                    if (i > 0) {
                        sbuf.append(", ");
                    }
                    sbuf.append(Array.get(value, i));
                }
                sbuf.append(") ");
                this.setText(sbuf.toString());
                return;
            }
            if (!$assertionsDisabled && nel != 1) {
                throw new AssertionError();
            }
            obj = Array.get(value, 0);
        } else {
            obj = value;
        }
        if (obj == null) {
            return;
        }
        if (obj instanceof Double) {
            double dval = (Double)obj;
            double aval = Math.abs(dval);
            if (Double.isNaN(dval)) {
                return;
            }
            if (aval <= Double.MIN_VALUE) {
                this.setText(this.formatFixedDouble(0.0));
                return;
            }
            if (aval < 1.0E-4 || aval >= 100000.0) {
                this.setText(this.formatSciDouble(dval));
                return;
            }
            this.setText(this.formatFixedDouble(dval));
            return;
        }
        if (obj instanceof Float) {
            float fval = ((Float)obj).floatValue();
            float aval = Math.abs(fval);
            if (Float.isNaN(fval)) {
                return;
            }
            if (aval <= Float.MIN_VALUE) {
                boolean isNeg = (Float.floatToIntBits(fval) & Integer.MIN_VALUE) != 0;
                this.setText(this.formatFixedFloat(isNeg ? -0.0f : 0.0f));
                return;
            }
            if ((double)aval < 1.0E-4 || (double)aval >= 100000.0) {
                this.setText(this.formatSciFloat(fval));
                return;
            }
            this.setText(this.formatFixedFloat(fval));
            return;
        }
        if (!(obj instanceof Long)) {
            if (obj instanceof Integer || obj instanceof Short || obj instanceof Byte) {
                this.setText(this.intFormat.format(((Number)obj).intValue()) + ' ');
                return;
            }
            this.setText(' ' + obj.toString() + ' ');
            return;
        }
        this.setText(((Long)obj).toString() + " ");
    }

    public void setBadValue(Object badValue) {
        this.badValue = badValue;
    }

    public int getCellWidth() {
        if (this.clazz == null) {
            return this.widthFor("                ");
        }
        if (this.clazz.equals(Byte.class)) {
            return this.widthFor(new Byte(127));
        }
        if (this.clazz.equals(Short.class)) {
            return this.widthFor(new Short(Short.MAX_VALUE));
        }
        if (this.clazz.equals(Integer.class)) {
            return this.widthFor(new Integer(Integer.MAX_VALUE));
        }
        if (this.clazz.equals(Long.class)) {
            return this.widthFor(new Long(Long.MAX_VALUE));
        }
        if (this.clazz.equals(Float.class)) {
            return Math.max(this.widthFor(new Float(-3.4028235E38f)), this.widthFor(new Float(-99996.85840734642)));
        }
        if (this.clazz.equals(Double.class)) {
            return Math.max(this.widthFor(new Double(-1.7976931348623157E308)), this.widthFor(new Double(-99996.85840734642)));
        }
        return this.widthFor("                ");
    }

    private int widthFor(Object ob) {
        this.setValue(ob);
        return this.getPreferredSize().width + 2;
    }

    private boolean isBadValue(Object val) {
        if (this.badValue == null) {
            return val == null;
        }
        return this.badValue.equals(val);
    }

    private String formatFixedDouble(double dval) {
        if (this.fixFormatDouble == null) {
            this.fixFormatDouble = NumberFormat.getInstance();
            if (this.fixFormatDouble instanceof DecimalFormat) {
                DecimalFormat dformat = (DecimalFormat)this.fixFormatDouble;
                dformat.applyPattern(" #####0.#####;-#####0.#####");
                dformat.setDecimalSeparatorAlwaysShown(true);
                this.decimalPoint = dformat.getDecimalFormatSymbols().getDecimalSeparator();
                this.decimalPointString = "" + this.decimalPoint;
            }
        }
        StringBuffer buf = new StringBuffer(20);
        buf.append(this.fixFormatDouble.format(dval));
        int dotpos = buf.indexOf(this.decimalPointString);
        if (dotpos < 0) {
            dotpos = buf.length();
            buf.append(this.decimalPoint);
        }
        int pad = 7 - (buf.length() - dotpos);
        for (int i = 0; i < pad; ++i) {
            buf.append(' ');
        }
        return buf.toString();
    }

    private String formatFixedFloat(float fval) {
        if (this.fixFormatFloat0 == null) {
            this.fixFormatFloat0 = NumberFormat.getInstance();
            if (this.fixFormatFloat0 instanceof DecimalFormat) {
                DecimalFormat dformat0 = (DecimalFormat)this.fixFormatFloat0;
                dformat0.setDecimalSeparatorAlwaysShown(true);
                this.decimalPoint = dformat0.getDecimalFormatSymbols().getDecimalSeparator();
                this.decimalPointString = "" + this.decimalPoint;
            }
            this.fixFormatFloat1 = (NumberFormat)this.fixFormatFloat0.clone();
            this.fixFormatFloat2 = (NumberFormat)this.fixFormatFloat0.clone();
            this.fixFormatFloat3 = (NumberFormat)this.fixFormatFloat0.clone();
            this.fixFormatFloat4 = (NumberFormat)this.fixFormatFloat0.clone();
            this.fixFormatFloat5 = (NumberFormat)this.fixFormatFloat0.clone();
            this.fixFormatFloat6 = (NumberFormat)this.fixFormatFloat0.clone();
            if (this.fixFormatFloat0 instanceof DecimalFormat) {
                ((DecimalFormat)this.fixFormatFloat0).applyPattern(" 0.######;-0.######");
                ((DecimalFormat)this.fixFormatFloat1).applyPattern(" 0.#####;-0.#####");
                ((DecimalFormat)this.fixFormatFloat2).applyPattern("#0.####;-#0.####");
                ((DecimalFormat)this.fixFormatFloat3).applyPattern(" ##0.###;-##0.###");
                ((DecimalFormat)this.fixFormatFloat4).applyPattern(" ###0.##;-###0.##");
                ((DecimalFormat)this.fixFormatFloat5).applyPattern(" ####0.#;-####0.#");
                ((DecimalFormat)this.fixFormatFloat6).applyPattern(" #####0.;-#####0.");
            }
        }
        StringBuffer buf = new StringBuffer(20);
        float aval = Math.abs(fval);
        NumberFormat fmt = (double)aval < 1.0 ? this.fixFormatFloat0 : ((double)aval < 10.0 ? this.fixFormatFloat1 : ((double)aval < 100.0 ? this.fixFormatFloat2 : ((double)aval < 1000.0 ? this.fixFormatFloat3 : ((double)aval < 10000.0 ? this.fixFormatFloat4 : ((double)aval < 1.0E-5 ? this.fixFormatFloat5 : this.fixFormatFloat6)))));
        buf.append(fmt.format(fval));
        int dotpos = buf.indexOf(this.decimalPointString);
        if (dotpos < 0) {
            dotpos = buf.length();
            buf.append(this.decimalPoint);
        }
        int pad = 8 - (buf.length() - dotpos);
        for (int i = 0; i < pad; ++i) {
            buf.append(' ');
        }
        return buf.toString();
    }

    private String formatSciDouble(double dval) {
        if (this.sciFormatDouble == null) {
            this.sciFormatDouble = NumberFormat.getInstance();
            if (this.sciFormatDouble instanceof DecimalFormat) {
                ((DecimalFormat)this.sciFormatDouble).applyPattern(" 0.000000E0;-0.000000E0");
            }
        }
        StringBuffer buf = new StringBuffer(20);
        buf.append(this.sciFormatDouble.format(dval));
        int pad = 4 - (buf.length() - buf.indexOf("E"));
        for (int i = 0; i < pad; ++i) {
            buf.append(' ');
        }
        return buf.toString();
    }

    private String formatSciFloat(float fval) {
        if (this.sciFormatFloat == null) {
            this.sciFormatFloat = NumberFormat.getInstance();
            if (this.sciFormatFloat instanceof DecimalFormat) {
                ((DecimalFormat)this.sciFormatFloat).applyPattern(" 0.00000E0;-0.00000E0");
            }
        }
        StringBuffer buf = new StringBuffer(20);
        buf.append(this.sciFormatFloat.format(fval));
        int pad = 4 - (buf.length() - buf.indexOf("E"));
        for (int i = 0; i < pad; ++i) {
            buf.append(' ');
        }
        return buf.toString();
    }

    static {
        $assertionsDisabled = !NumericCellRenderer.class.desiredAssertionStatus();
    }
}

