/*
 * Decompiled with CFR 0.152.
 */
package alma.observatorycharacteristics.sbconfiguration;

import alma.hla.runtime.obsprep.util.Log;
import alma.observatorycharacteristics.configuration.OTConfiguration;
import alma.observatorycharacteristics.configuration.OTXMLConfigurationReader;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.xml.bind.JAXBException;

public class AlmaSBConfiguration {
    private static AlmaSBConfiguration almaSBConfigurationSingleton = null;
    private final String telescope;
    private List<Integer> tpAmpCalBands = new ArrayList<Integer>();

    private AlmaSBConfiguration() throws InvalidObsProgramParametersException {
        this.telescope = System.getProperty("Telescope", "Cycle8");
        try {
            OTConfiguration oTConfiguration = OTXMLConfigurationReader.getInstance().getOTConfiguration();
            OTConfiguration.ScheduleBlockConfiguration scheduleBlockConfiguration = oTConfiguration.getScheduleBlockConfiguration();
            if (scheduleBlockConfiguration != null) {
                this.tpAmpCalBands = scheduleBlockConfiguration.getTPAmpCalSBBands().getReceiverBand();
            }
        }
        catch (OTXMLConfigurationReader.InvalidOTCOnfigurationException | JAXBException throwable) {
            throw new RuntimeException("Unable to parse the " + this.telescope + "OTConfiguration.xml file " + throwable.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AlmaSBConfiguration getInstance() {
        if (almaSBConfigurationSingleton != null) return almaSBConfigurationSingleton;
        Class<AlmaSBConfiguration> clazz = AlmaSBConfiguration.class;
        synchronized (AlmaSBConfiguration.class) {
            if (almaSBConfigurationSingleton != null) return almaSBConfigurationSingleton;
            try {
                almaSBConfigurationSingleton = new AlmaSBConfiguration();
                Log.logger(AlmaSBConfiguration.class).config("Telescope = " + AlmaSBConfiguration.almaSBConfigurationSingleton.telescope);
            }
            catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
                Log.logger(AlmaSBConfiguration.class).log(Level.WARNING, invalidObsProgramParametersException.getMessage(), (Throwable)invalidObsProgramParametersException);
            }
            return almaSBConfigurationSingleton;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void refreshCapabilities() {
        if (almaSBConfigurationSingleton == null) return;
        Class<AlmaSBConfiguration> clazz = AlmaSBConfiguration.class;
        synchronized (AlmaSBConfiguration.class) {
            if (almaSBConfigurationSingleton == null) return;
            almaSBConfigurationSingleton = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public List<Integer> getTpAmpCalBands() {
        return this.tpAmpCalBands;
    }
}

