/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.obsproposal;

import alma.entity.xmlbinding.obsproposal.ProposalFeedbackT;
import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.bo.ValueUnitPair;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.enumerations.Array;
import alma.obsprep.bo.obsproject.PerformanceParameters;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproposal.ArrayDataRates;
import alma.obsprep.bo.obsproposal.ArrayTime;
import alma.obsprep.bo.obsproposal.ArrayTimeBreakdown;
import alma.obsprep.bo.obsproposal.DataRateBreakdown;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.bo.obsproposal.ReceiverTimeBreakdown;
import alma.obsprep.bo.obsproposal.TimeAllocationBreakdown;
import alma.obsprep.bo.obsproposal.data.ArrayTimeData;
import alma.obsprep.bo.obsproposal.data.ProposalFeedbackData;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.services.etc.Phase1DataRateCalculator;
import alma.obsprep.services.etc.SourceClusterDetector;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.valuetypes.DataRate;
import alma.valuetypes.StorageVolume;
import alma.valuetypes.Time;
import java.util.Collection;
import java.util.List;
import lombok.NonNull;

public class ProposalFeedback
extends ProposalFeedbackData {
    private final Log.Logger logger = Log.logger((Object)((Object)this));

    public ProposalFeedback(ProposalFeedbackT proposalFeedbackT) {
        super(proposalFeedbackT);
    }

    public ObsProposal getObsProposal() {
        return (ObsProposal)this.getParent();
    }

    protected void initAsNew() {
        super.initAsNew();
        this.setEstimatedTotalIntegrationTime(Time.createTime((double)-999.0, (String)Time.UNIT_H));
    }

    public void fill() throws InvalidObsProgramParametersException {
        this.setEstimatedTotalIntegrationTime(Time.createTime((double)-999.0, (String)Time.UNIT_H));
        this.fillDataRateBreakdown(this.getDataRateBreakdown());
        this.fillTimeAllocationBreakdown(this.getTimeAllocationBreakdown());
        this.fillReceiverTimeBreakdown(this.getReceiverTimeBreakdown());
        this.fillArrayTimeBreakdown(this.getArrayTimeBreakdown());
    }

    private boolean isArrayUsed(@NonNull ScienceGoal scienceGoal, @NonNull Array array) {
        if (scienceGoal == null) {
            throw new NullPointerException("sg is marked non-null but is null");
        }
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        PerformanceParameters performanceParameters = scienceGoal.getPerformanceParameters();
        switch (array) {
            case ARRAY_12M: {
                return !scienceGoal.isStandAloneACA();
            }
            case ARRAY_7M: {
                return performanceParameters.getUseACA();
            }
            case ARRAY_TP: {
                return performanceParameters.getUseACA() && performanceParameters.getUseTP();
            }
        }
        return false;
    }

    private void fillDataRateBreakdown(@NonNull DataRateBreakdown dataRateBreakdown) {
        if (dataRateBreakdown == null) {
            throw new NullPointerException("bo is marked non-null but is null");
        }
        List<String> list = List.of(ArrayDataRates.ARRAYNAME_TWELVE_M, ArrayDataRates.ARRAYNAME_SEVEN_M, ArrayDataRates.ARRAYNAME_TP_ARRAY);
        for (String string : list) {
            ArrayDataRates arrayDataRates = dataRateBreakdown.getArrayDataRates(string);
            DataRate dataRate = arrayDataRates.getEstimatedMaximumDataRate();
            Time time = Time.createTime();
            StorageVolume storageVolume = arrayDataRates.getEstimatedDataVolume();
            dataRate.setContent(0.0);
            arrayDataRates.getEstimatedAverageDataRate().setContent(0.0);
            storageVolume.setContent(0.0);
            Array array = Array.getArray(string);
            boolean bl = this.getObsProposal().isVLBIorPhasedArray();
            for (ScienceGoal scienceGoal : this.getObsProposal().getAbstractScienceGoalScienceGoal()) {
                Collection<ScienceGoal> collection;
                DataRate dataRate2 = DataRate.createDataRate((double)0.0, (String)DataRate.UNIT_MB_S);
                if (!this.isArrayUsed(scienceGoal, array)) continue;
                SourceClusterDetector sourceClusterDetector = new SourceClusterDetector(scienceGoal);
                try {
                    collection = sourceClusterDetector.splitScienceGoalIntoSourceClusters();
                }
                catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
                    throw new WizardSBGenerationException(invalidObsProgramParametersException);
                }
                for (ScienceGoal scienceGoal2 : collection) {
                    try {
                        DataRate dataRate3 = scienceGoal2.getDataRate(array);
                        if (dataRate.isLessThan((AbstractDoubleWithUnit)dataRate3)) {
                            dataRate.setContentAndUnit((ValueUnitPair)dataRate3);
                        }
                        Time time2 = bl ? scienceGoal2.getTotalRequestedTime(array) : scienceGoal2.getTotalRequestedTime(array, true);
                        time.aggregate(time2);
                        dataRate2 = scienceGoal2.getAverageDataRate(array);
                        storageVolume.aggregate(dataRate2.getStorageVolume(time2));
                    }
                    catch (Phase1DataRateCalculator.UnableToDetermineInstantaneousDataRateException | InvalidObsProgramParametersException exception) {
                        Log.logger((Object)((Object)this)).warning("Warning Data Rate calculation in Proposal Feedback : " + exception.getMessage());
                    }
                }
                double d = storageVolume.getContentInUnits(StorageVolume.UNIT_MB) / time.getContentInUnits(Time.UNIT_S);
                if (Double.isNaN(d) || Double.isInfinite(d)) {
                    d = 0.0;
                }
                if (Double.isNaN(storageVolume.getContent()) || Double.isInfinite(storageVolume.getContent())) {
                    storageVolume.setContent(0.0);
                }
                arrayDataRates.setEstimatedAverageDataRate(DataRate.createDataRate((double)d, (String)DataRate.UNIT_MB_S));
                Log.logger((Object)((Object)this)).info(arrayDataRates.toString());
            }
        }
    }

    private void fillTimeAllocationBreakdown(@NonNull TimeAllocationBreakdown timeAllocationBreakdown) {
        if (timeAllocationBreakdown == null) {
            throw new NullPointerException("bo is marked non-null but is null");
        }
        timeAllocationBreakdown.allocateTimeToExecutives();
    }

    private void fillReceiverTimeBreakdown(@NonNull ReceiverTimeBreakdown receiverTimeBreakdown) {
        if (receiverTimeBreakdown == null) {
            throw new NullPointerException("bo is marked non-null but is null");
        }
        receiverTimeBreakdown.clearReceiverTime();
        for (ScienceGoal scienceGoal : this.getObsProposal().getAbstractScienceGoalScienceGoal()) {
            Collection<ScienceGoal> collection;
            SourceClusterDetector sourceClusterDetector = new SourceClusterDetector(scienceGoal);
            try {
                collection = sourceClusterDetector.splitScienceGoalIntoSourceClusters();
            }
            catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
                throw new WizardSBGenerationException(invalidObsProgramParametersException);
            }
            for (ScienceGoal scienceGoal2 : collection) {
                ReceiverBand receiverBand;
                try {
                    receiverBand = scienceGoal2.getReceiverBand();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.logger.warning(illegalArgumentException.getMessage());
                    continue;
                }
                try {
                    Time time;
                    if (scienceGoal2.isStandAloneACA()) {
                        Time time2 = scienceGoal2.getTotalRequestedTime(Array.ARRAY_7M);
                        Time time3 = scienceGoal2.getTotalRequestedTime(Array.ARRAY_TP);
                        time = Time.max(time2, time3);
                    } else {
                        time = scienceGoal2.getTotalRequestedTime(Array.ARRAY_12M);
                    }
                    receiverTimeBreakdown.getReceiverTime(receiverBand).getTime().aggregate(time);
                }
                catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
                    this.logger.warning(invalidObsProgramParametersException.getMessage());
                }
            }
        }
    }

    private void fillArrayTimeBreakdown(@NonNull ArrayTimeBreakdown arrayTimeBreakdown) {
        if (arrayTimeBreakdown == null) {
            throw new NullPointerException("bo is marked non-null but is null");
        }
        arrayTimeBreakdown.clearArrayTime();
        ArrayTime[] arrayTimeArray = new ArrayTime[5];
        arrayTimeArray[3] = ArrayTime.createArrayTime(ArrayTimeData.ARRAYNAME_TWELVE_M);
        arrayTimeArray[1] = ArrayTime.createArrayTime(ArrayTimeData.ARRAYNAME_SEVEN_M);
        arrayTimeArray[2] = ArrayTime.createArrayTime(ArrayTimeData.ARRAYNAME_TP_ARRAY);
        arrayTimeArray[0] = ArrayTime.createArrayTime(ArrayTimeData.ARRAYNAME_ACA);
        arrayTimeArray[4] = ArrayTime.createArrayTime(ArrayTimeData.ARRAYNAME_ALMA);
        Array array = Array.getArray(ArrayTimeData.ARRAYNAME_TWELVE_M);
        Array array2 = Array.getArray(ArrayTimeData.ARRAYNAME_SEVEN_M);
        Array array3 = Array.getArray(ArrayTimeData.ARRAYNAME_TP_ARRAY);
        for (ScienceGoal scienceGoal : this.getObsProposal().getAbstractScienceGoalScienceGoal()) {
            Collection<ScienceGoal> collection;
            try {
                collection = new SourceClusterDetector(scienceGoal).splitScienceGoalIntoSourceClusters();
            }
            catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
                throw new WizardSBGenerationException(invalidObsProgramParametersException);
            }
            Log.logger((Object)((Object)this)).info("****************** Science Goal: " + scienceGoal.getNameOrDefault());
            for (ScienceGoal scienceGoal2 : collection) {
                try {
                    Time time = Time.createTime();
                    if (!scienceGoal2.isStandAloneACA()) {
                        time = scienceGoal2.getTotalRequestedTime(array);
                        Log.logger((Object)((Object)this)).info("12-m Time: " + String.valueOf(time));
                        Log.logger((Object)((Object)this)).warning("12-m time for " + scienceGoal2.getName() + " is " + time.getHours());
                    }
                    Time time2 = scienceGoal2.getTotalRequestedTime(array2);
                    Time time3 = this.isTotalPowerUsed(scienceGoal2) ? scienceGoal2.getTotalRequestedTime(array3) : Time.createTimeSec(0.0);
                    Time time4 = Time.max(time3, time2);
                    Time time5 = time3.isGreaterThan((AbstractDoubleWithUnit)time2) ? (Time)time3.plus((AbstractDoubleWithUnit)time) : (Time)time2.plus((AbstractDoubleWithUnit)time);
                    arrayTimeArray[3].getEstimatedTime().aggregate(time);
                    arrayTimeArray[1].getEstimatedTime().aggregate(time2);
                    arrayTimeArray[2].getEstimatedTime().aggregate(time3);
                    arrayTimeArray[4].getEstimatedTime().aggregate(time5);
                    arrayTimeArray[0].getEstimatedTime().aggregate(time4);
                }
                catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
                    Log.logger((Object)((Object)this)).warning(invalidObsProgramParametersException.getMessage());
                }
            }
        }
        arrayTimeBreakdown.setArrayTime(arrayTimeArray);
    }

    boolean isTotalPowerUsed(ScienceGoal scienceGoal) {
        return scienceGoal.getPerformanceParameters().gettrueUseTP();
    }
}

