/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.misc;

import alma.obsprep.guiutil.mvc.ContextSwitchInterface;
import alma.obsprep.guiutil.mvc.widgets.OTTextField;
import alma.obsprep.ot.gui.toplevel.ObservingToolController;
import alma.obsprep.ot.gui.toplevel.ObservingToolGui;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.DefaultCellEditor;
import lombok.NonNull;

public class OTTextCellEditor
extends DefaultCellEditor
implements ContextSwitchInterface {
    public OTTextCellEditor() {
        this(new OTTextField());
    }

    public OTTextCellEditor(@NonNull OTTextField oTTextField) {
        super(oTTextField);
        if (oTTextField == null) {
            throw new NullPointerException("textField is marked non-null but is null");
        }
        this.setAllTextSelector(oTTextField);
    }

    @Override
    public void finalizeUserEdits() {
        this.stopCellEditing();
    }

    protected void setAllTextSelector(final OTTextField oTTextField) {
        FocusListener focusListener = new FocusListener(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                OTTextCellEditor.this.stopCellEditing();
            }

            @Override
            public void focusGained(FocusEvent focusEvent) {
                ObservingToolController observingToolController = ObservingToolController.getMyInstance();
                if (observingToolController == null) {
                    return;
                }
                ObservingToolGui observingToolGui = observingToolController.getGui();
                if (observingToolGui == null) {
                    return;
                }
                if (observingToolGui.isFieldReplace()) {
                    oTTextField.setCaretPosition(0);
                    oTTextField.moveCaretPosition(oTTextField.getText().length());
                }
            }
        };
        oTTextField.addFocusListener(focusListener);
    }
}

