/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.spatialvisual;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;

public class ContourPlot {
    static final int N_CONTOURS = 10;
    static final double Z_MAX_MAX = 1.0E10;
    static final double Z_MIN_MIN = -1.0E10;
    int xSteps;
    int ySteps;
    double[][] z;
    Dimension d;
    double deltaX;
    double deltaY;
    int ncv = 10;
    int[] l1 = new int[4];
    int[] l2 = new int[4];
    int[] ij = new int[2];
    int[] i1 = new int[2];
    int[] i2 = new int[2];
    int[] i3 = new int[6];
    int ibkey;
    int icur;
    int jcur;
    int ii;
    int jj;
    int elle;
    int ix;
    int iedge;
    int iflag;
    int ni;
    int ks;
    int cntrIndex;
    int prevIndex;
    int idir;
    int nxidir;
    int k;
    double z1;
    double z2;
    double cval;
    double zMax;
    double zMin;
    double[] intersect = new double[4];
    double[] xy = new double[2];
    double[] prevXY = new double[2];
    double[] cv = new double[this.ncv];
    String[] labels;
    boolean jump;

    int sign(int n, int n2) {
        n = Math.abs(n);
        if (n2 < 0) {
            return -n;
        }
        return n;
    }

    void assignContourValues() {
        double d = (this.zMax - this.zMin) / (double)this.ncv;
        for (int i = 0; i < this.ncv; ++i) {
            this.cv[i] = this.zMin + (double)(i + 1) * d;
        }
    }

    void setMeasurements(Dimension dimension) {
        this.deltaX = (double)dimension.height / ((double)this.xSteps - 1.0);
        this.deltaY = (double)dimension.width / ((double)this.ySteps - 1.0);
    }

    void setColour(Graphics graphics) {
        Color color = new Color(255, 255, 255);
        graphics.setColor(color);
    }

    void drawKernel(Graphics graphics) {
        if (this.iflag == 1 || this.iflag == 4 || this.iflag == 5) {
            if (this.cntrIndex != this.prevIndex) {
                this.setColour(graphics);
                this.prevIndex = this.cntrIndex;
            }
            int n = (int)((this.prevXY[0] - 1.0) * this.deltaX);
            int n2 = (int)((this.prevXY[1] - 1.0) * this.deltaY);
            int n3 = (int)((this.xy[0] - 1.0) * this.deltaX);
            int n4 = (int)((this.xy[1] - 1.0) * this.deltaY);
            graphics.drawLine(n2, n, n4, n3);
            if (this.iflag == 4 || this.iflag == 5) {
                if (n3 == 0) {
                    n3 += 10;
                } else if (n4 == this.d.width) {
                    n4 -= 60;
                }
                graphics.drawString(this.labels[this.cntrIndex], n4, n3);
            }
        }
        this.prevXY[0] = this.xy[0];
        this.prevXY[1] = this.xy[1];
    }

    void detectBoundary() {
        this.ix = 1;
        if (this.ij[1 - this.elle] != 1) {
            this.ii = this.ij[0] - this.i1[1 - this.elle];
            this.jj = this.ij[1] - this.i1[this.elle];
            if (this.z[this.ii - 1][this.jj - 1] <= 1.0E10) {
                this.ii = this.ij[0] + this.i2[this.elle];
                this.jj = this.ij[1] + this.i2[1 - this.elle];
                if (this.z[this.ii - 1][this.jj - 1] < 1.0E10) {
                    this.ix = 0;
                }
            }
            if (this.ij[1 - this.elle] >= this.l1[1 - this.elle]) {
                this.ix += 2;
                return;
            }
        }
        this.ii = this.ij[0] + this.i1[1 - this.elle];
        this.jj = this.ij[1] + this.i1[this.elle];
        if (this.z[this.ii - 1][this.jj - 1] > 1.0E10) {
            this.ix += 2;
            return;
        }
        if (this.z[this.ij[0]][this.ij[1]] >= 1.0E10) {
            this.ix += 2;
        }
    }

    boolean routine_label_020() {
        this.l2[0] = this.ij[0];
        this.l2[1] = this.ij[1];
        this.l2[2] = -this.ij[0];
        this.l2[3] = -this.ij[1];
        this.idir = 0;
        this.nxidir = 1;
        this.k = 1;
        this.ij[0] = Math.abs(this.ij[0]);
        this.ij[1] = Math.abs(this.ij[1]);
        if (this.z[this.ij[0] - 1][this.ij[1] - 1] > 1.0E10) {
            this.elle = this.idir % 2;
            this.ij[this.elle] = this.sign(this.ij[this.elle], this.l1[this.k - 1]);
            return true;
        }
        this.elle = 0;
        return false;
    }

    boolean routine_label_050() {
        block2: {
            while (true) {
                if (this.ij[this.elle] >= this.l1[this.elle]) {
                    if (++this.elle <= 1) continue;
                    this.elle = this.idir % 2;
                    this.ij[this.elle] = this.sign(this.ij[this.elle], this.l1[this.k - 1]);
                    if (!this.routine_label_150()) continue;
                    return true;
                }
                this.ii = this.ij[0] + this.i1[this.elle];
                this.jj = this.ij[1] + this.i1[1 - this.elle];
                if (!(this.z[this.ii - 1][this.jj - 1] > 1.0E10)) break block2;
                if (++this.elle <= 1) continue;
                this.elle = this.idir % 2;
                this.ij[this.elle] = this.sign(this.ij[this.elle], this.l1[this.k - 1]);
                if (this.routine_label_150()) break;
            }
            return true;
        }
        this.jump = false;
        return false;
    }

    boolean routine_label_150() {
        while (true) {
            if (this.ij[this.elle] < this.l1[this.k - 1]) {
                int n = this.elle;
                this.ij[n] = this.ij[n] + 1;
                if (this.ij[this.elle] > this.l2[this.k - 1]) {
                    this.l2[this.k - 1] = this.ij[this.elle];
                    this.idir = this.nxidir;
                    this.k = this.nxidir = this.idir + 1;
                    if (this.nxidir > 3) {
                        this.nxidir = 0;
                    }
                }
                this.ij[0] = Math.abs(this.ij[0]);
                this.ij[1] = Math.abs(this.ij[1]);
                if (this.z[this.ij[0] - 1][this.ij[1] - 1] > 1.0E10) {
                    this.elle = this.idir % 2;
                    this.ij[this.elle] = this.sign(this.ij[this.elle], this.l1[this.k - 1]);
                    continue;
                }
                this.elle = 0;
                return false;
            }
            if (this.idir != this.nxidir) {
                this.ij[this.elle] = this.l1[this.k - 1];
                this.k = ++this.nxidir;
                this.elle = 1 - this.elle;
                this.ij[this.elle] = this.l2[this.k - 1];
                if (this.nxidir <= 3) continue;
                this.nxidir = 0;
                continue;
            }
            if (this.ibkey != 0) {
                return true;
            }
            this.ibkey = 1;
            this.ij[0] = this.icur;
            this.ij[1] = this.jcur;
            if (!this.routine_label_020()) break;
        }
        return false;
    }

    short routine_label_200(Graphics graphics, boolean[] blArray) {
        while (true) {
            this.xy[this.elle] = 1.0 * (double)this.ij[this.elle] + this.intersect[this.iedge - 1];
            this.xy[1 - this.elle] = 1.0 * (double)this.ij[1 - this.elle];
            blArray[2 * (this.xSteps * (this.ySteps * this.cntrIndex + this.ij[1] - 1) + this.ij[0] - 1) + this.elle] = true;
            this.drawKernel(graphics);
            if (this.iflag >= 4) {
                this.icur = this.ij[0];
                this.jcur = this.ij[1];
                return 1;
            }
            this.continueContour();
            if (!blArray[2 * (this.xSteps * (this.ySteps * this.cntrIndex + this.ij[1] - 1) + this.ij[0] - 1) + this.elle]) {
                return 2;
            }
            this.iflag = 5;
            this.iedge = this.ks + 2;
            if (this.iedge > 4) {
                this.iedge -= 4;
            }
            this.intersect[this.iedge - 1] = this.intersect[this.ks - 1];
        }
    }

    boolean crossedByContour(boolean[] blArray) {
        this.ii = this.ij[0] + this.i1[this.elle];
        this.jj = this.ij[1] + this.i1[1 - this.elle];
        this.z1 = this.z[this.ij[0] - 1][this.ij[1] - 1];
        this.z2 = this.z[this.ii - 1][this.jj - 1];
        this.cntrIndex = 0;
        while (this.cntrIndex < this.ncv) {
            double d;
            int n = 2 * (this.xSteps * (this.ySteps * this.cntrIndex + this.ij[1] - 1) + this.ij[0] - 1) + this.elle;
            if (!blArray[n] && (d = this.cv[this.cntrIndex]) > Math.min(this.z1, this.z2) && d <= Math.max(this.z1, this.z2)) {
                blArray[n] = true;
                return true;
            }
            ++this.cntrIndex;
        }
        return false;
    }

    void continueContour() {
        this.ni = 1;
        if (this.iedge >= 3) {
            this.ij[0] = this.ij[0] - this.i3[this.iedge - 1];
            this.ij[1] = this.ij[1] - this.i3[this.iedge + 1];
        }
        for (int n = 1; n < 5; n = (int)((short)(n + 1))) {
            if (n == this.iedge) continue;
            this.ii = this.ij[0] + this.i3[n - 1];
            this.jj = this.ij[1] + this.i3[n];
            this.z1 = this.z[this.ii - 1][this.jj - 1];
            this.ii = this.ij[0] + this.i3[n];
            this.jj = this.ij[1] + this.i3[n + 1];
            this.z2 = this.z[this.ii - 1][this.jj - 1];
            if (!(this.cval > Math.min(this.z1, this.z2)) || !(this.cval <= Math.max(this.z1, this.z2))) continue;
            if (n == 1 || n == 4) {
                double d = this.z2;
                this.z2 = this.z1;
                this.z1 = d;
            }
            this.intersect[n - 1] = (this.cval - this.z1) / (this.z2 - this.z1);
            ++this.ni;
            this.ks = n;
        }
        if (this.ni != 2) {
            this.ks = 5 - this.iedge;
            if (this.intersect[2] >= this.intersect[0]) {
                this.ks = 3 - this.iedge;
                if (this.ks <= 0) {
                    this.ks += 4;
                }
            }
        }
        this.elle = this.ks - 1;
        this.iflag = 1;
        this.jump = true;
        if (this.ks >= 3) {
            this.ij[0] = this.ij[0] + this.i3[this.ks - 1];
            this.ij[1] = this.ij[1] + this.i3[this.ks + 1];
            this.elle = this.ks - 3;
        }
    }

    void contourPlotKernel(Graphics graphics, boolean[] blArray) {
        this.l1[0] = this.xSteps;
        this.l1[1] = this.ySteps;
        this.l1[2] = -1;
        this.l1[3] = -1;
        this.i1[0] = 1;
        this.i1[1] = 0;
        this.i2[0] = 1;
        this.i2[1] = -1;
        this.i3[0] = 1;
        this.i3[1] = 0;
        this.i3[2] = 0;
        this.i3[3] = 1;
        this.i3[4] = 1;
        this.i3[5] = 0;
        this.prevXY[0] = 0.0;
        this.prevXY[1] = 0.0;
        this.xy[0] = 1.0;
        this.xy[1] = 1.0;
        this.cntrIndex = 0;
        this.prevIndex = -1;
        this.iflag = 6;
        this.drawKernel(graphics);
        this.icur = Math.max(1, Math.min((int)Math.floor(this.xy[0]), this.xSteps));
        this.jcur = Math.max(1, Math.min((int)Math.floor(this.xy[1]), this.ySteps));
        this.ibkey = 0;
        this.ij[0] = this.icur;
        this.ij[1] = this.jcur;
        if (this.routine_label_020() && this.routine_label_150()) {
            return;
        }
        if (this.routine_label_050()) {
            return;
        }
        while (true) {
            short s;
            this.detectBoundary();
            if (this.jump) {
                if (this.ix != 0) {
                    this.iflag = 4;
                }
                this.iedge = this.ks + 2;
                if (this.iedge > 4) {
                    this.iedge -= 4;
                }
                this.intersect[this.iedge - 1] = this.intersect[this.ks - 1];
                s = this.routine_label_200(graphics, blArray);
                if (s == 1) {
                    if (this.routine_label_020() && this.routine_label_150()) {
                        return;
                    }
                    if (!this.routine_label_050()) continue;
                    return;
                }
                if (s == 2) continue;
                return;
            }
            if (this.ix != 3 && this.ix + this.ibkey != 0 && this.crossedByContour(blArray)) {
                this.iedge = this.elle + 1;
                this.cval = this.cv[this.cntrIndex];
                if (this.ix != 1) {
                    this.iedge += 2;
                }
                this.iflag = 2 + this.ibkey;
                this.intersect[this.iedge - 1] = (this.cval - this.z1) / (this.z2 - this.z1);
                s = this.routine_label_200(graphics, blArray);
                if (s == 1) {
                    if (this.routine_label_020() && this.routine_label_150()) {
                        return;
                    }
                    if (!this.routine_label_050()) continue;
                    return;
                }
                if (s == 2) continue;
                return;
            }
            if (++this.elle > 1) {
                this.elle = this.idir % 2;
                this.ij[this.elle] = this.sign(this.ij[this.elle], this.l1[this.k - 1]);
                if (this.routine_label_150()) {
                    return;
                }
            }
            if (this.routine_label_050()) break;
        }
    }

    public void paint(Graphics graphics, Dimension dimension) {
        this.d = dimension;
        int n = 2 * this.xSteps * this.ySteps * this.ncv;
        this.setMeasurements(dimension);
        if (this.cv[0] != this.cv[1]) {
            boolean[] blArray = new boolean[n];
            this.contourPlotKernel(graphics, blArray);
        }
    }

    public void setData(double[][] dArray, double[] dArray2) {
        this.setData(dArray, dArray2, null);
    }

    public void setData(double[][] dArray, double[] dArray2, String[] stringArray) {
        this.z = dArray;
        this.setLevels(dArray2, stringArray);
        this.calcParams();
    }

    public void setLevels(double[] dArray, String[] stringArray) {
        this.cv = dArray;
        int n = this.ncv = dArray == null ? 0 : dArray.length;
        if (this.ncv == 0) {
            this.cv = new double[]{0.0, 0.0};
            return;
        }
        if (stringArray == null) {
            this.labels = new String[this.ncv];
            for (int i = 0; i < this.ncv; ++i) {
                this.labels[i] = Float.toString((float)this.cv[i]);
            }
        } else {
            this.labels = stringArray;
        }
    }

    private void calcParams() {
        this.xSteps = this.z.length;
        this.ySteps = this.z[0].length;
        this.zMax = this.z[0][0];
        this.zMin = this.z[0][0];
        for (int i = 0; i < this.z.length; ++i) {
            for (int j = 0; j < this.z[i].length; ++j) {
                this.zMax = Math.max(this.zMax, this.z[i][j]);
                this.zMin = Math.min(this.zMin, this.z[i][j]);
            }
        }
        if (this.zMax > 1.0E10) {
            this.zMax = 1.0E10;
        }
        if (this.zMin < -1.0E10) {
            this.zMin = -1.0E10;
        }
        if (this.cv == null) {
            this.ncv = 10;
            this.cv = new double[this.ncv];
            this.assignContourValues();
        }
    }
}

