/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.spectralvisual;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.bo.IBusinessObject;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.annotations.BaseBand;
import alma.obsprep.bo.annotations.BaseBandHolder;
import alma.obsprep.bo.annotations.SpectralSpecDocument;
import alma.obsprep.bo.annotations.SpectralWindowI;
import alma.obsprep.bo.enumerations.SideBandUse;
import alma.obsprep.bo.schedblock.AbstractBaseBandConfig;
import alma.obsprep.bo.schedblock.AbstractSpectralWindow;
import alma.obsprep.bo.schedblock.BaseBandSpecification;
import alma.obsprep.bo.schedblock.ChannelAverageRegion;
import alma.obsprep.bo.schedblock.Range;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.ot.boEditors.PanelUtilities;
import alma.obsprep.ot.editors.spectralvisual.BBCLevelManager;
import alma.obsprep.ot.editors.spectralvisual.ObservedAndTargetPanel;
import alma.obsprep.ot.editors.spectralvisual.SpectralRangeRepresentation;
import alma.obsprep.ot.gui.dnd.ConstrainedXDNDDescriptor;
import alma.obsprep.ot.gui.dnd.DNDDescriptor;
import alma.obsprep.ot.gui.dnd.DefaultDNDDescriptor;
import alma.obsprep.ot.gui.dnd.DomainPoint;
import alma.obsprep.ot.gui.dnd.MousePoint;
import alma.obsprep.ot.gui.resources.ColorPalette;
import alma.obsprep.ot.gui.resources.Colors;
import alma.obsprep.ot.models.schedblock.SpectralSpecModel;
import alma.obsprep.util.UnitMapConfigurator;
import alma.valuetypes.Frequency;
import alma.valuetypes.Speed;
import alma.valuetypes.Velocity;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import lombok.NonNull;

public class SchedBlockSpectralPanel
extends ObservedAndTargetPanel {
    public static final double zoomThreshold = 100.0;
    public static final int BasebandDepth = 3;
    public static final double SW_OFFSET_GHZ = 2.0;
    private boolean isDrawReceiverBands;
    private boolean isDrawCentreFrequencies;
    private boolean isDrawBasebands;
    private boolean isDrawSideBands;
    private int selectedBBC;
    private boolean isBBCTrackSelection;
    private boolean isFoldBasebands;
    private boolean isSpectralWindowsFolded;
    private boolean isACASpectralSpec;
    private boolean isDraggingLo = false;
    private boolean isDraggingLine = false;
    private boolean isAllowDragLO;
    private boolean isAllowDragLines;
    private static final int DRAG_LINE = 1;
    private static final int DRAG_RANGE = 2;
    private static final int DRAG_LO = 3;

    @Override
    public DNDDescriptor createDescriptor(MousePoint mousePoint) {
        DefaultDNDDescriptor defaultDNDDescriptor = null;
        SpectralSpec spectralSpec = (SpectralSpec)this.model.getDocument();
        double d = this.unscaleObservedFrequency(mousePoint.getX());
        double d2 = -1000.0;
        int n = -1000;
        double d3 = -1000.0;
        int n2 = -1000;
        if (spectralSpec != null) {
            d2 = spectralSpec.getFrequencySetup().getRestFrequency().getContentInGHz();
            n = this.scaleRestFrequency(d2);
            if (this.isDrawSideBands) {
                d3 = spectralSpec.getLO1Frequency().getContentInGHz();
                n2 = this.scaleOF(d3);
            }
        }
        if (mousePoint.getY() <= this.yObservedAxis() || mousePoint.getY() >= this.yTargetAxis()) {
            DomainPoint domainPoint = new DomainPoint(d, 0.0);
            defaultDNDDescriptor = new DefaultDNDDescriptor(2, mousePoint, domainPoint);
        } else if (spectralSpec != null) {
            if ((double)Math.abs(mousePoint.getX() - n2) < 10.0 && this.isLODragAllowed()) {
                MousePoint mousePoint2 = new MousePoint(n2, mousePoint.getY());
                DomainPoint domainPoint = new DomainPoint(d3, 0.0);
                ReceiverBand receiverBand = spectralSpec.getReceiverBand();
                defaultDNDDescriptor = new ConstrainedXDNDDescriptor(3, mousePoint2, domainPoint, new Range(receiverBand.getLOMin(), receiverBand.getLOMax()));
            } else if ((double)Math.abs(mousePoint.getX() - n) < 10.0 && this.isLinesDragAllowed()) {
                MousePoint mousePoint3 = new MousePoint(n, mousePoint.getY());
                DomainPoint domainPoint = new DomainPoint(d2, 0.0);
                defaultDNDDescriptor = new ConstrainedXDNDDescriptor(1, mousePoint3, domainPoint, new Range(this.getAbsoluteMin(), this.getAbsoluteMax()));
            }
        }
        this.setDragging(defaultDNDDescriptor != null);
        return defaultDNDDescriptor;
    }

    @Override
    public void drag(DNDDescriptor dNDDescriptor, MousePoint mousePoint) {
        SpectralSpec spectralSpec = (SpectralSpec)this.model.getDocument();
        DomainPoint domainPoint = new DomainPoint(this.unscaleObservedFrequency(mousePoint.getX()), 0.0);
        if (mousePoint.getX() <= 0) {
            double d = -1.0 * (double)mousePoint.getX() / (double)this.getWidth();
            this.panLeft(d);
        } else if (mousePoint.getX() > this.getWidth()) {
            double d = 1.0 * (double)(mousePoint.getX() - this.getWidth()) / (double)this.getWidth();
            this.panRight(d);
        }
        domainPoint = dNDDescriptor.getConstrained(domainPoint);
        switch (dNDDescriptor.getType()) {
            case 2: {
                break;
            }
            case 1: {
                domainPoint = new DomainPoint(this.unscaleRestFrequency(mousePoint.getX()), 0.0);
                domainPoint = dNDDescriptor.getConstrained(domainPoint);
                Frequency frequency = spectralSpec.getFrequencySetup().getRestFrequency();
                String string = frequency.getUnit();
                frequency.setContentInGHz(domainPoint.getX());
                frequency.convertToUnit(string);
                break;
            }
            case 3: {
                Frequency frequency = spectralSpec.getLO1Frequency();
                String string = frequency.getUnit();
                frequency.setContentInGHz(domainPoint.getX());
                frequency.convertToUnit(string);
                break;
            }
        }
    }

    @Override
    public void abandon(DNDDescriptor dNDDescriptor) {
        SpectralSpec spectralSpec = (SpectralSpec)this.model.getDocument();
        DomainPoint domainPoint = dNDDescriptor.getOriginalDomainPosition();
        switch (dNDDescriptor.getType()) {
            case 2: {
                break;
            }
            case 1: {
                Frequency frequency = spectralSpec.getFrequencySetup().getRestFrequency();
                String string = frequency.getUnit();
                frequency.setContentInGHz(domainPoint.getX());
                frequency.convertToUnit(string);
                break;
            }
            case 3: {
                Frequency frequency = spectralSpec.getLO1Frequency();
                String string = frequency.getUnit();
                frequency.setContentInGHz(domainPoint.getX());
                frequency.convertToUnit(string);
                break;
            }
        }
        this.setDragging(false);
    }

    @Override
    public void drop(DNDDescriptor dNDDescriptor, MousePoint mousePoint) {
        this.setDragging(false);
    }

    @Override
    public void destroyDescriptor(DNDDescriptor dNDDescriptor) {
        this.setDragging(false);
    }

    public boolean isLODragAllowed() {
        return this.isAllowDragLO;
    }

    public void setAllowDragLO(boolean bl) {
        this.isAllowDragLO = bl;
    }

    public boolean isLinesDragAllowed() {
        return this.isAllowDragLines;
    }

    public void setAllowDragLines(boolean bl) {
        this.isAllowDragLines = bl;
    }

    @Override
    public void publish() {
        this.model.publish();
    }

    public void setModel(SpectralSpecModel spectralSpecModel) {
        ObservedAndTargetPanel.LocalDNDAdapter localDNDAdapter = new ObservedAndTargetPanel.LocalDNDAdapter(this, this);
        this.addMouseListener(localDNDAdapter);
        this.addMouseMotionListener(localDNDAdapter);
        super.setModel(spectralSpecModel);
    }

    @Override
    public SpectralSpecModel getModel() {
        return (SpectralSpecModel)super.getModel();
    }

    public SchedBlockSpectralPanel(ColorPalette colorPalette, double d, double d2) {
        super(d, d2);
        this.palette = colorPalette;
        this.graphicsHelper = new PanelUtilities(this);
        this.setDrawReceiverBands(true);
        this.setDrawCentreFrequencies(false);
        this.setDrawBasebands(true);
        this.setDrawSideBands(true);
        this.setDrawOtherLines(false);
        this.setDrawTransmission(true);
        this.setInitialFrequencyRange();
        this.setTrackBasebandSelection(false);
        this.setFoldBasebands(false);
        this.setSpectralWindowsFolded(false);
        this.setDrawReceiverBands(true);
        this.setAllowDragLO(true);
    }

    public void setTrackBasebandSelection(boolean bl) {
        this.isBBCTrackSelection = bl;
    }

    public boolean isTrackBasebandSelection() {
        return this.isBBCTrackSelection;
    }

    public boolean isSpectralWindowsFolded() {
        return this.isSpectralWindowsFolded;
    }

    public void setSpectralWindowsFolded(boolean bl) {
        this.isSpectralWindowsFolded = bl;
    }

    public boolean isACA() {
        return this.isACASpectralSpec;
    }

    public boolean isBL() {
        return !this.isACA();
    }

    public void setACA(boolean bl) {
        this.isACASpectralSpec = bl;
    }

    public void setSelectedBBC(int n) {
        this.selectedBBC = n;
        if (this.isTrackBasebandSelection()) {
            this.zoomToSelectedBaseband();
        }
        this.repaint();
    }

    @Override
    public void resetFrequencyRange() {
        this.minOF = this.absoluteMinOF;
        this.maxOF = this.absoluteMaxOF;
        this.setFrequencyRangeNoRound(this.minOF, this.maxOF);
    }

    public double getZoomRange() {
        return this.getMaxObservedFreq() - this.getMinObservedFreq();
    }

    public boolean isFullBasebandConfigurationToBeDisplayed() {
        return this.getZoomRange() < 100.0;
    }

    private int yBaseBandHeight() {
        return this.textHeight / 2;
    }

    @Override
    protected int yRxBandHeight() {
        return 2 * this.yBaseBandHeight();
    }

    @Override
    protected int yClearTarget() {
        return this.yTargetAxis();
    }

    @Override
    protected int yClearObserved() {
        return this.yObservedAxis() + 2 * this.textHeight;
    }

    private int yHeight(BBCLevelManager bBCLevelManager, int n) {
        return this.yClearObserved() + this.yClearHeight() * n / bBCLevelManager.numLevels();
    }

    private int yDepth(BBCLevelManager bBCLevelManager, int n) {
        return this.yClearHeight() * n / bBCLevelManager.numLevels();
    }

    private int observedLabelBase() {
        return this.yObservedAxis() + this.yRxBandHeight() + this.yLOBandHeight() + this.textHeight;
    }

    @Override
    protected int observedLabelHeight(int n) {
        return this.observedLabelBase() + n * this.textHeight;
    }

    @Override
    protected SpectralSpecDocument getContext() {
        SpectralSpecDocument spectralSpecDocument = null;
        if (this.model != null) {
            SpectralSpecModel spectralSpecModel = (SpectralSpecModel)this.model;
            spectralSpecDocument = spectralSpecModel.getContext();
        }
        return spectralSpecDocument;
    }

    @Override
    protected Velocity getSourceVelocity() {
        Velocity velocity = Velocity.createVelocity();
        if (this.model != null) {
            SpectralSpecModel spectralSpecModel = (SpectralSpecModel)this.model;
            velocity = spectralSpecModel.getSourceVelocity();
        }
        return velocity;
    }

    public void panToLine() {
        SpectralSpec spectralSpec = (SpectralSpec)this.model.getDocument();
        if (spectralSpec == null) {
            return;
        }
        Frequency frequency = spectralSpec.getSchedBlock().getSchedulingConstraints().getRepresentativeFrequency();
        this.panTo(frequency.getContentInGHz());
    }

    public void zoomToBand() {
        SpectralSpec spectralSpec = (SpectralSpec)this.model.getDocument();
        if (spectralSpec == null) {
            return;
        }
        ReceiverBand receiverBand = spectralSpec.getReceiverBand();
        if (receiverBand != null) {
            this.setFrequencyRange(receiverBand.getRFMin(), receiverBand.getRFMax());
        }
    }

    public void zoomToSelectedBaseband() {
        SpectralSpec spectralSpec = (SpectralSpec)this.model.getDocument();
        if (spectralSpec == null) {
            return;
        }
        int n = this.getSelectedBBC();
        if (n < 0) {
            return;
        }
        BaseBandHolder baseBandHolder = spectralSpec.getBaseBandHolder();
        if (n >= baseBandHolder.getBaseBandCount()) {
            return;
        }
        BaseBand baseBand = baseBandHolder.getBaseBand(n);
        double d = baseBand.getCenterFrequencySky().getContentInGHz();
        double d2 = baseBand.getBandwidth().getContentInGHz() / 2.0;
        this.setFrequencyRange(d - d2, d + d2);
    }

    public boolean canZoomToMirror() {
        SpectralSpec spectralSpec = (SpectralSpec)this.model.getDocument();
        if (spectralSpec == null) {
            return false;
        }
        if (!this.isImageSignalToBeDrawn()) {
            return false;
        }
        double d = spectralSpec.getLO1Frequency().getContentInGHz();
        double d2 = 2.0 * d - this.maxOF;
        double d3 = 2.0 * d - this.minOF;
        return this.absoluteMinOF <= d2 && d3 <= this.absoluteMaxOF;
    }

    public void zoomToMirror() {
        SpectralSpec spectralSpec = (SpectralSpec)this.model.getDocument();
        if (spectralSpec == null) {
            return;
        }
        double d = spectralSpec.getLO1Frequency().getContentInGHz();
        double d2 = 2.0 * d - this.maxOF;
        double d3 = 2.0 * d - this.minOF;
        this.setFrequencyRangeNoRound(d2, d3);
    }

    @Override
    public void corePaintComponent(@NonNull Graphics graphics) {
        if (graphics == null) {
            throw new NullPointerException("g is marked non-null but is null");
        }
        SpectralSpec spectralSpec = (SpectralSpec)this.model.getDocument();
        if (spectralSpec != null) {
            if (this.isFullBasebandConfigurationToBeDisplayed()) {
                this.paintFullyDetailedSpectralSpecBBC(graphics, spectralSpec);
            } else {
                this.paintSpectralSpec(graphics, spectralSpec);
            }
        } else {
            this.resetFrequencyRange();
            this.paintNoSpectralSpec(graphics);
        }
    }

    public void paintObservedAxisAndBands(@NonNull Graphics graphics) {
        if (graphics == null) {
            throw new NullPointerException("g is marked non-null but is null");
        }
        this.paintSkyAxis(graphics);
        boolean bl = true;
        if (this.isDrawReceiverBands()) {
            Color color;
            Color color2 = color = COLOUR_BANDLINES;
            for (int i = 0; i < this.names.length; ++i) {
                ReceiverBand receiverBand = ReceiverBand.getReceiverBand(this.names[i]);
                if (bl) {
                    this.paintBand(graphics, receiverBand, color, bl);
                } else {
                    this.paintBand(graphics, receiverBand, color2, bl);
                }
                bl = !bl;
            }
        }
    }

    private void paintSideBands(@NonNull Graphics graphics, @NonNull SpectralSpec spectralSpec) {
        if (graphics == null) {
            throw new NullPointerException("g is marked non-null but is null");
        }
        if (spectralSpec == null) {
            throw new NullPointerException("ss is marked non-null but is null");
        }
        ReceiverBand receiverBand = ReceiverBand.getReceiverBand(spectralSpec.getFrequencySetup().getReceiverBand());
        double d = spectralSpec.getLO1Frequency().getContentInGHz();
        Color color = Colors.transparentColor(this.palette.getSidebandsColor());
        Frequency frequency = null;
        Frequency frequency2 = null;
        Frequency frequency3 = null;
        Frequency frequency4 = null;
        for (int i = 0; i < spectralSpec.getBaseBandCount(); ++i) {
            Frequency frequency5;
            Frequency frequency6;
            BaseBandSpecification baseBandSpecification = spectralSpec.getBaseBandSpecification(i);
            boolean bl = false;
            if (baseBandSpecification.getBaseBandConfig() == null) continue;
            for (SpectralWindowI spectralWindowI : baseBandSpecification.getBaseBandConfig().getSpectralWindow()) {
                if (!spectralWindowI.getSideBandUse().usesUSB()) continue;
                bl = true;
                break;
            }
            if (bl) {
                frequency6 = (Frequency)spectralSpec.getLO1Frequency().plus((AbstractDoubleWithUnit)((Frequency)baseBandSpecification.getLO2Frequency().minus((AbstractDoubleWithUnit)Frequency.createFrequencyGHZ(2.0))));
                frequency5 = (Frequency)frequency6.minus((AbstractDoubleWithUnit)Frequency.createFrequencyGHZ(2.0));
                if (frequency == null || frequency6.isLessThan((AbstractDoubleWithUnit)frequency)) {
                    frequency = frequency6.deepCopy();
                }
                if (frequency2 != null && !frequency5.isGreaterThan((AbstractDoubleWithUnit)frequency2)) continue;
                frequency2 = frequency5.deepCopy();
                continue;
            }
            frequency6 = (Frequency)spectralSpec.getLO1Frequency().minus((AbstractDoubleWithUnit)((Frequency)baseBandSpecification.getLO2Frequency().minus((AbstractDoubleWithUnit)Frequency.createFrequencyGHZ(2.0))));
            frequency5 = (Frequency)frequency6.plus((AbstractDoubleWithUnit)Frequency.createFrequencyGHZ(2.0));
            if (frequency3 == null || frequency6.isLessThan((AbstractDoubleWithUnit)frequency3)) {
                frequency3 = frequency6.deepCopy();
            }
            if (frequency4 != null && !frequency5.isGreaterThan((AbstractDoubleWithUnit)frequency4)) continue;
            frequency4 = frequency5.deepCopy();
        }
        if (receiverBand.isLowerSidebandPresent()) {
            double d2 = d - receiverBand.getIFMax();
            double d3 = d - receiverBand.getIFMin();
            if (frequency3 != null && frequency3.isLessThan((AbstractDoubleWithUnit)Frequency.createFrequencyGHZ(d2))) {
                d2 = frequency3.getContentInGHz();
            }
            if (frequency4 != null && frequency4.isGreaterThan((AbstractDoubleWithUnit)Frequency.createFrequencyGHZ(d3))) {
                d3 = frequency4.getContentInGHz();
            }
            Range range = new Range(d2, d3);
            this.paintSideBand(graphics, range, color, false);
        }
        if (receiverBand.isUpperSidebandPresent()) {
            double d4 = d + receiverBand.getIFMin();
            double d5 = d + receiverBand.getIFMax();
            if (frequency != null && frequency.isLessThan((AbstractDoubleWithUnit)Frequency.createFrequencyGHZ(d4))) {
                d4 = frequency.getContentInGHz();
            }
            if (frequency2 != null && frequency2.isGreaterThan((AbstractDoubleWithUnit)Frequency.createFrequencyGHZ(d5))) {
                d5 = frequency2.getContentInGHz();
            }
            Range range = new Range(d4, d5);
            this.paintSideBand(graphics, range, color, false);
        }
        this.paintObservedSpectralLine(graphics, d, "LO1", this.palette.getSidebandsColor(), 1, false);
    }

    private void drawBasebandLine(Graphics graphics, String string, Color color, int n, int n2, int n3, int n4) {
        graphics.setColor(color);
        graphics.drawLine(n3, n, n2, n);
        graphics.drawLine(n3, n - 5, n3, n + 5);
        graphics.drawLine(n2, n - 5, n2, n + 5);
        if (string != null) {
            if (this.isDrawCentreFrequencies()) {
                graphics.fillOval(n4 - 2, n - 2, 4, 4);
            } else {
                this.graphicsHelper.labelCentre(graphics, n4, n, string);
            }
        }
    }

    private boolean isImageSignalToBeDrawn() {
        SpectralSpec spectralSpec = this.getModel().getSpectralSpec();
        String string = spectralSpec.getReceiverBand().getType();
        return string.equals(SpectralSpec.RECEIVERTYPE_DSB) && spectralSpec.getCorrelatorConfiguration().getEnable90DegreeWalshFunction();
    }

    private void paintBasebandConfigurationLines(Graphics graphics, SpectralSpec spectralSpec) {
        Color color = this.palette.getCentreFrequencyColor();
        Color color2 = Colors.transparentColor(color);
        double d = spectralSpec.getLO1Frequency().getContentInGHz();
        boolean bl = this.isImageSignalToBeDrawn();
        for (int i = 0; i < spectralSpec.getBaseBandCount(); ++i) {
            BaseBandSpecification baseBandSpecification = spectralSpec.getBaseBandSpecification(i);
            double d2 = baseBandSpecification.getActualBaseBandCenterFrequencySky().getContentInGHz();
            double d3 = 2.0 * d - d2;
            String string = baseBandSpecification.getBaseBandName();
            if (this.isDrawCentreFrequencies()) {
                this.paintObservedSpectralLine(graphics, d2, string, color, i, true);
                if (bl) {
                    this.paintObservedSpectralLine(graphics, d3, null, color2, i, true);
                }
            }
            if (!this.isDrawBasebands()) continue;
            Frequency frequency = baseBandSpecification.getBandwidth();
            double d4 = frequency.getContentInGHz() / 2.0;
            int n = this.observedLabelHeight(i);
            int n2 = this.scaleOF(d2 + d4);
            int n3 = this.scaleOF(d2 - d4);
            int n4 = this.scaleOF(d2);
            this.drawBasebandLine(graphics, string, color, n, n2, n3, n4);
            if (!bl) continue;
            n2 = this.scaleOF(d3 + d4);
            n3 = this.scaleOF(d3 - d4);
            n4 = this.scaleOF(d3);
            this.drawBasebandLine(graphics, null, color2, n, n2, n3, n4);
        }
    }

    private void drawBasebandCentreFrequencies(Graphics graphics, SpectralSpec spectralSpec) {
        Color color = this.palette.getCentreFrequencyColor();
        double d = spectralSpec.getLO1Frequency().getContentInGHz();
        for (int i = 0; i < spectralSpec.getBaseBandCount(); ++i) {
            BaseBandSpecification baseBandSpecification = spectralSpec.getBaseBandSpecification(i);
            double d2 = baseBandSpecification.getActualBaseBandCenterFrequencySky().getContentInGHz();
            double d3 = 2.0 * d - d2;
            String string = null;
            if (!this.isFullBasebandConfigurationToBeDisplayed()) {
                string = baseBandSpecification.getBaseBandName();
            }
            this.paintObservedSpectralLine(graphics, d2, string, color, i, true);
            if (!this.isImageSignalToBeDrawn()) continue;
            Color color2 = Colors.transparentColor(color);
            this.paintObservedSpectralLine(graphics, d3, null, color2, i, true);
        }
    }

    private void paintRepresentativeFrequency(Graphics graphics, SpectralSpec spectralSpec) {
        Object object;
        Object object2;
        Frequency frequency = spectralSpec.getSchedBlock().getSchedulingConstraints().getRepresentativeFrequency();
        try {
            object2 = (SchedBlock)spectralSpec.getParent();
            object = object2.getSchedulingConstraints().getRepresentativeTarget();
            Velocity velocity = object.getFieldSource().getSourceVelocityInReferenceFrame();
            frequency = frequency.inverseDopplerShifted(velocity);
        }
        catch (Exception exception) {
            return;
        }
        this.paintTargetSpectralLine(graphics, frequency.getContentInGHz(), "SB Representative", this.palette.getRestFrequencyColor(), 0);
        object2 = spectralSpec.getFrequencySetup().getReceiverBand();
        object = ReceiverBand.getReceiverBand((String)object2);
        this.paintBand(graphics, (ReceiverBand)object, this.palette.getRestFrequencyColor());
    }

    public void paintNoSpectralSpec(Graphics graphics) {
        this.textHeight = this.graphicsHelper.calculateTextHeight(graphics);
        this.paintBackground(graphics);
        if (this.getDrawOtherLines()) {
            this.paintKnownSpectralLinesLines(graphics, this.minTF, this.maxTF);
        }
    }

    private void paintSpectralSpec(Graphics graphics, SpectralSpec spectralSpec) {
        this.paintNoSpectralSpec(graphics);
        if (this.isDrawSideBands()) {
            this.paintSideBands(graphics, spectralSpec);
        }
        if (this.getDrawOtherLines()) {
            this.paintKnownSpectralLinesLines(graphics, this.minTF, this.maxTF);
        }
        if (this.isDrawCentreFrequencies() || this.isDrawBasebands()) {
            this.paintBasebandConfigurationLines(graphics, spectralSpec);
        }
        this.paintRepresentativeFrequency(graphics, spectralSpec);
    }

    private void paintBackground(Graphics graphics) {
        this.paintObservedAxisAndBands(graphics);
        this.paintRestAxis(graphics);
    }

    protected void paintReceiverBand(Graphics graphics, SpectralSpec spectralSpec) {
        ReceiverBand receiverBand = spectralSpec.getReceiverBand();
        int n = this.scaleOF(receiverBand.getRFMin());
        int n2 = this.scaleOF(receiverBand.getRFMax());
        if (n2 <= 0 || n >= this.getWidth()) {
            return;
        }
        int n3 = this.scaleOF(receiverBand.getLOMin());
        int n4 = this.scaleOF(receiverBand.getLOMax());
        n = this.clipXToVisible(n);
        n3 = this.clipXToVisible(n3);
        n4 = this.clipXToVisible(n4);
        n2 = this.clipXToVisible(n2);
        graphics.setColor(this.palette.getRestFrequencyColor());
        graphics.drawRect(n, this.yObservedAxis(), n2 - n, this.yRxBandHeight());
        this.graphicsHelper.hatch(graphics, n, this.yObservedAxis(), n2 - n, this.yRxBandHeight(), true);
    }

    private void paintSimpleChannelAverageRegion(Graphics graphics, double d, double d2, int n, int n2, String string, Color color) {
        int n3 = this.scaleOF(d);
        int n4 = this.scaleOF(d2);
        if (n4 <= 0 || n3 >= this.getWidth()) {
            return;
        }
        n3 = this.clipXToVisible(n3);
        n4 = this.clipXToVisible(n4);
        graphics.setColor(Colors.transparentColor(color, 150));
        graphics.fillRect(n3, n + 1, n4 - n3, n2 - 2);
    }

    private void paintSimpleBaseband(Graphics graphics, double d, double d2, int n, int n2, String string, Color color) {
        int n3 = this.scaleOF(d);
        int n4 = this.scaleOF(d2);
        if (n4 <= 0 || n3 >= this.getWidth()) {
            return;
        }
        int n5 = (n3 + n4) / 2;
        int n6 = n2 / 3;
        n3 = this.clipXToVisible(n3);
        n4 = this.clipXToVisible(n4);
        graphics.setColor(color);
        graphics.drawRect(n3, n, n4 - n3, n2);
        graphics.fillRect(n3, n, n4 - n3, 2 * n6);
        if (string != null) {
            graphics.setColor(COLOUR_BANDLABEL);
            Rectangle2D.Float float_ = (Rectangle2D.Float)graphics.getFontMetrics().getStringBounds(string, graphics);
            int n7 = (int)((float)(n + n6) + float_.height / 2.0f);
            graphics.drawString(string, (int)((float)n5 - float_.width / 2.0f), n7);
        }
    }

    private void paintSimpleSpectralWindow(Graphics graphics, double d, double d2, int n, int n2, int n3, int n4, String string, Color color) {
        int n5 = this.scaleOF(d);
        int n6 = this.scaleOF(d2);
        if (n6 <= 0 || n5 >= this.getWidth()) {
            return;
        }
        n5 = this.clipXToVisible(n5);
        n6 = this.clipXToVisible(n6);
        graphics.setColor(color);
        this.graphicsHelper.bigH(graphics, n5, n, n6 - n5, n2);
        graphics.setColor(Colors.transparentColor(color, 63));
        graphics.fillRect(n5, n3, n6 - n5, n4);
    }

    protected void paintSRRSpectralWindow(Graphics graphics, Collection<SpectralRangeRepresentation> collection, BBCLevelManager bBCLevelManager) {
        if (collection == null) {
            return;
        }
        for (SpectralRangeRepresentation spectralRangeRepresentation : collection) {
            if (spectralRangeRepresentation.getType() == SpectralRangeRepresentation.RangeType.Secondary && !this.isImageSignalToBeDrawn()) continue;
            Color color = switch (spectralRangeRepresentation.getType()) {
                case SpectralRangeRepresentation.RangeType.Primary -> this.palette.getSpectralWindowColor();
                case SpectralRangeRepresentation.RangeType.Secondary -> this.palette.getSpectralWindowColor().darker();
                case SpectralRangeRepresentation.RangeType.Suppressed -> this.palette.getSuppressedColor();
                default -> {
                    Log.logger((Object)this).warning(String.format("Unexpected SRR type (%s) in redraw - using orange", new Object[]{spectralRangeRepresentation.getType()}));
                    yield Color.ORANGE;
                }
            };
            if (spectralRangeRepresentation.isError()) {
                color = this.palette.getErrorColor();
            }
            if (spectralRangeRepresentation.isHighlighted()) {
                color = color.brighter();
            }
            int n = this.yDepth(bBCLevelManager, spectralRangeRepresentation.getParent().getDepth());
            int n2 = n / 3;
            int n3 = this.yHeight(bBCLevelManager, spectralRangeRepresentation.getParent().getLevel());
            int n4 = this.yHeight(bBCLevelManager, spectralRangeRepresentation.getLevel());
            int n5 = this.yDepth(bBCLevelManager, spectralRangeRepresentation.getDepth());
            this.paintSimpleSpectralWindow(graphics, spectralRangeRepresentation.getMinFrequencyGHz(), spectralRangeRepresentation.getMaxFrequencyGHz(), n4, n5, n3 + n - n2, n2, spectralRangeRepresentation.getLabel(), color);
            for (SpectralRangeRepresentation spectralRangeRepresentation2 : spectralRangeRepresentation.getChildren()) {
                color = this.palette.getAveragingRegionColor();
                if (spectralRangeRepresentation2.isError()) {
                    color = this.palette.getErrorColor();
                }
                if (spectralRangeRepresentation2.isHighlighted()) {
                    color = color.brighter();
                }
                this.paintSimpleChannelAverageRegion(graphics, spectralRangeRepresentation2.getMinFrequencyGHz(), spectralRangeRepresentation2.getMaxFrequencyGHz(), n4, n5, spectralRangeRepresentation2.getLabel(), color);
            }
        }
    }

    protected void paintSRRBaseband(Graphics graphics, Collection<SpectralRangeRepresentation> collection, BBCLevelManager bBCLevelManager) {
        if (collection == null) {
            return;
        }
        for (SpectralRangeRepresentation spectralRangeRepresentation : collection) {
            if (spectralRangeRepresentation.getType() == SpectralRangeRepresentation.RangeType.Secondary && !this.isImageSignalToBeDrawn()) continue;
            Color color = switch (spectralRangeRepresentation.getType()) {
                case SpectralRangeRepresentation.RangeType.Primary -> this.palette.getBasebandColor();
                case SpectralRangeRepresentation.RangeType.Secondary -> this.palette.getBasebandColor().darker();
                default -> {
                    Log.logger((Object)this).warning(String.format("Unexpected SRR type (%s) in redraw - using orange", new Object[]{spectralRangeRepresentation.getType()}));
                    yield Color.ORANGE;
                }
            };
            if (spectralRangeRepresentation.isError()) {
                color = this.palette.getErrorColor();
            }
            if (spectralRangeRepresentation.isHighlighted()) {
                color = color.brighter();
            }
            this.paintSimpleBaseband(graphics, spectralRangeRepresentation.getMinFrequencyGHz(), spectralRangeRepresentation.getMaxFrequencyGHz(), this.yHeight(bBCLevelManager, spectralRangeRepresentation.getLevel()), this.yDepth(bBCLevelManager, spectralRangeRepresentation.getDepth()), spectralRangeRepresentation.getLabel(), color);
        }
    }

    protected void paintBasebands(Graphics graphics, SpectralSpec spectralSpec, Map<IBusinessObject, Collection<SpectralRangeRepresentation>> map, BBCLevelManager bBCLevelManager) {
        BaseBandHolder baseBandHolder = spectralSpec.getBaseBandHolder();
        for (BaseBand baseBand : baseBandHolder.getBaseBand()) {
            this.paintSRRBaseband(graphics, map.get(baseBand), bBCLevelManager);
            for (AbstractSpectralWindow abstractSpectralWindow : baseBand.getSingleSpectralWindow()) {
                this.paintSRRSpectralWindow(graphics, map.get(abstractSpectralWindow), bBCLevelManager);
            }
        }
    }

    private SpectralRangeRepresentation addCARtoSW(SpectralRangeRepresentation spectralRangeRepresentation, double d, double d2, ChannelAverageRegion channelAverageRegion, SideBandUse sideBandUse, double d3, SpectralRangeRepresentation.RangeType rangeType, Map<IBusinessObject, Collection<SpectralRangeRepresentation>> map) {
        double d4;
        double d5;
        int n = channelAverageRegion.getStartChannel();
        int n2 = channelAverageRegion.getNumberChannels();
        switch (sideBandUse) {
            case SIDEBANDUSE_LSB: {
                d5 = d2 - (double)n * d3;
                d4 = d5 - (double)n2 * d3;
                break;
            }
            case SIDEBANDUSE_USB: {
                d4 = d + (double)n * d3;
                d5 = d4 + (double)n2 * d3;
                break;
            }
            default: {
                Log.logger((Object)this).warning(String.format("unexpected sideband use %s (ignoring averaging region %s in redraw)", new Object[]{sideBandUse, channelAverageRegion}));
                return null;
            }
        }
        SpectralRangeRepresentation spectralRangeRepresentation2 = new SpectralRangeRepresentation(d4, d5, sideBandUse, rangeType);
        map.get(channelAverageRegion).add(spectralRangeRepresentation2);
        spectralRangeRepresentation2.setParent(spectralRangeRepresentation);
        return spectralRangeRepresentation2;
    }

    private SpectralRangeRepresentation addSWtoBBC(SpectralRangeRepresentation spectralRangeRepresentation, AbstractSpectralWindow abstractSpectralWindow, SideBandUse sideBandUse, SpectralRangeRepresentation.RangeType rangeType, Map<IBusinessObject, Collection<SpectralRangeRepresentation>> map) {
        double d = abstractSpectralWindow.getCenterFrequency().getContentInGHz() - 2.0;
        double d2 = abstractSpectralWindow.getEffectiveBandwidth().getContentInGHz();
        double d3 = 0.0;
        double d4 = 0.0;
        switch (sideBandUse) {
            case SIDEBANDUSE_LSB: {
                d4 = spectralRangeRepresentation.getMaxFrequencyGHz() - d + d2 / 2.0;
                d3 = d4 - d2;
                break;
            }
            case SIDEBANDUSE_USB: {
                d4 = spectralRangeRepresentation.getMinFrequencyGHz() + d + d2 / 2.0;
                d3 = d4 - d2;
                break;
            }
            default: {
                Log.logger((Object)this).warning(String.format("unexpected sideband use %s (ignoring spectral window %s in redraw)", new Object[]{sideBandUse, abstractSpectralWindow.getSpectralWindowName()}));
                return null;
            }
        }
        SpectralRangeRepresentation spectralRangeRepresentation2 = new SpectralRangeRepresentation(d3, d4, sideBandUse, rangeType);
        map.get(abstractSpectralWindow).add(spectralRangeRepresentation2);
        spectralRangeRepresentation2.setParent(spectralRangeRepresentation);
        double d5 = d2 / (double)abstractSpectralWindow.getEffectiveNumberOfChannels();
        for (ChannelAverageRegion channelAverageRegion : abstractSpectralWindow.getChannelAverageRegion()) {
            this.addCARtoSW(spectralRangeRepresentation2, d3, d4, channelAverageRegion, sideBandUse, d5, rangeType, map);
        }
        return spectralRangeRepresentation2;
    }

    private void addSingleSidebandRanges(BaseBand baseBand, SideBandUse sideBandUse, Map<IBusinessObject, Collection<SpectralRangeRepresentation>> map) {
        double d = baseBand.getBaseBandSpecification().getActualBaseBandCenterFrequencySky().getContentInGHz();
        double d2 = baseBand.getBandwidth().getContentInGHz() / 2.0;
        double d3 = d - d2;
        double d4 = d + d2;
        SpectralRangeRepresentation spectralRangeRepresentation = new SpectralRangeRepresentation(d3, d4, sideBandUse, SpectralRangeRepresentation.RangeType.Primary);
        spectralRangeRepresentation.setHighlighted(baseBand.getBaseBandIndex() == this.getSelectedBBC());
        spectralRangeRepresentation.setLabel(String.format("%s(%s)", baseBand.getBaseBandName(), sideBandUse == SideBandUse.SIDEBANDUSE_USB ? "U" : "L"));
        spectralRangeRepresentation.setDepth(3);
        map.get(baseBand).add(spectralRangeRepresentation);
        for (AbstractSpectralWindow abstractSpectralWindow : baseBand.getSingleSpectralWindow()) {
            this.addSWtoBBC(spectralRangeRepresentation, abstractSpectralWindow, sideBandUse, SpectralRangeRepresentation.RangeType.Primary, map);
        }
    }

    private void addBothSidebandRanges(BaseBand baseBand, SideBandUse sideBandUse, Frequency frequency, Map<IBusinessObject, Collection<SpectralRangeRepresentation>> map) {
        SpectralRangeRepresentation.RangeType rangeType;
        SpectralRangeRepresentation.RangeType rangeType2;
        SpectralRangeRepresentation spectralRangeRepresentation;
        SpectralRangeRepresentation spectralRangeRepresentation2;
        double d = baseBand.getBaseBandSpecification().getActualBaseBandCenterFrequencySky().getContentInGHz();
        double d2 = baseBand.getBandwidth().getContentInGHz() / 2.0;
        double d3 = d - d2;
        double d4 = d + d2;
        SpectralRangeRepresentation spectralRangeRepresentation3 = new SpectralRangeRepresentation(d3, d4, sideBandUse, SpectralRangeRepresentation.RangeType.Primary);
        double d5 = ((Frequency)((Frequency)frequency.multiply(2.0)).minus((AbstractDoubleWithUnit)baseBand.getCenterFrequencySky())).getContentInGHz();
        SpectralRangeRepresentation spectralRangeRepresentation4 = new SpectralRangeRepresentation(d5 - d2, d5 + d2, sideBandUse.switchSideBand(), SpectralRangeRepresentation.RangeType.Secondary);
        spectralRangeRepresentation3.setMirror(spectralRangeRepresentation4);
        spectralRangeRepresentation3.setHighlighted(baseBand.getBaseBandIndex() == this.getSelectedBBC());
        spectralRangeRepresentation4.setHighlighted(baseBand.getBaseBandIndex() == this.getSelectedBBC());
        spectralRangeRepresentation3.setDepth(3);
        spectralRangeRepresentation4.setDepth(3);
        map.get(baseBand).add(spectralRangeRepresentation3);
        map.get(baseBand).add(spectralRangeRepresentation4);
        switch (sideBandUse) {
            case SIDEBANDUSE_LSB: {
                spectralRangeRepresentation2 = spectralRangeRepresentation3;
                spectralRangeRepresentation = spectralRangeRepresentation4;
                rangeType2 = SpectralRangeRepresentation.RangeType.Primary;
                rangeType = SpectralRangeRepresentation.RangeType.Secondary;
                break;
            }
            case SIDEBANDUSE_USB: {
                spectralRangeRepresentation2 = spectralRangeRepresentation4;
                spectralRangeRepresentation = spectralRangeRepresentation3;
                rangeType2 = SpectralRangeRepresentation.RangeType.Secondary;
                rangeType = SpectralRangeRepresentation.RangeType.Primary;
                break;
            }
            default: {
                Log.logger((Object)this).warning(String.format("Unexpected sideband use (%s) in baseband %s", new Object[]{sideBandUse, baseBand.getBaseBandName()}));
                return;
            }
        }
        spectralRangeRepresentation2.setLabel(String.format("%s(L)", baseBand.getBaseBandName()));
        spectralRangeRepresentation.setLabel(String.format("%s(U)", baseBand.getBaseBandName()));
        for (SpectralWindowI spectralWindowI : baseBand.getSpectralWindow()) {
            SpectralRangeRepresentation spectralRangeRepresentation5 = null;
            SpectralRangeRepresentation spectralRangeRepresentation6 = null;
            spectralRangeRepresentation5 = this.addSWtoBBC(spectralRangeRepresentation2, spectralWindowI.getLSB(), SideBandUse.SIDEBANDUSE_LSB, rangeType2, map);
            spectralRangeRepresentation6 = this.addSWtoBBC(spectralRangeRepresentation, spectralWindowI.getUSB(), SideBandUse.SIDEBANDUSE_USB, rangeType, map);
            if (spectralRangeRepresentation5 == null || spectralRangeRepresentation6 == null) continue;
            spectralRangeRepresentation5.setMirror(spectralRangeRepresentation6);
        }
    }

    private void addMultipleSidebandRanges(@NonNull BaseBand baseBand, @NonNull SideBandUse sideBandUse, @NonNull Frequency frequency, @NonNull SpectralRangeRepresentation.DSBType dSBType, @NonNull Map<IBusinessObject, Collection<SpectralRangeRepresentation>> map) {
        SpectralRangeRepresentation.RangeType rangeType;
        SpectralRangeRepresentation.RangeType rangeType2;
        SpectralRangeRepresentation spectralRangeRepresentation;
        SpectralRangeRepresentation spectralRangeRepresentation2;
        if (baseBand == null) {
            throw new NullPointerException("bb is marked non-null but is null");
        }
        if (sideBandUse == null) {
            throw new NullPointerException("sidebandType is marked non-null but is null");
        }
        if (frequency == null) {
            throw new NullPointerException("lo1 is marked non-null but is null");
        }
        if (dSBType == null) {
            throw new NullPointerException("behaviour is marked non-null but is null");
        }
        if (map == null) {
            throw new NullPointerException("result is marked non-null but is null");
        }
        double d = baseBand.getBaseBandSpecification().getActualBaseBandCenterFrequencySky().getContentInGHz();
        double d2 = baseBand.getBandwidth().getContentInGHz() / 2.0;
        double d3 = d - d2;
        double d4 = d + d2;
        SpectralRangeRepresentation spectralRangeRepresentation3 = new SpectralRangeRepresentation(d3, d4, sideBandUse, SpectralRangeRepresentation.RangeType.Primary);
        double d5 = ((Frequency)((Frequency)frequency.multiply(2.0)).minus((AbstractDoubleWithUnit)baseBand.getCenterFrequencySky())).getContentInGHz();
        SpectralRangeRepresentation spectralRangeRepresentation4 = new SpectralRangeRepresentation(d5 - d2, d5 + d2, sideBandUse.switchSideBand(), SpectralRangeRepresentation.RangeType.Secondary);
        spectralRangeRepresentation3.setMirror(spectralRangeRepresentation4);
        spectralRangeRepresentation3.setHighlighted(baseBand.getBaseBandIndex() == this.getSelectedBBC());
        spectralRangeRepresentation4.setHighlighted(baseBand.getBaseBandIndex() == this.getSelectedBBC());
        spectralRangeRepresentation3.setDepth(3);
        spectralRangeRepresentation4.setDepth(3);
        map.get(baseBand).add(spectralRangeRepresentation3);
        map.get(baseBand).add(spectralRangeRepresentation4);
        switch (sideBandUse) {
            case SIDEBANDUSE_LSB: {
                spectralRangeRepresentation2 = spectralRangeRepresentation3;
                spectralRangeRepresentation = spectralRangeRepresentation4;
                rangeType2 = SpectralRangeRepresentation.RangeType.Primary;
                rangeType = SpectralRangeRepresentation.RangeType.Secondary;
                break;
            }
            case SIDEBANDUSE_USB: {
                spectralRangeRepresentation2 = spectralRangeRepresentation4;
                spectralRangeRepresentation = spectralRangeRepresentation3;
                rangeType2 = SpectralRangeRepresentation.RangeType.Secondary;
                rangeType = SpectralRangeRepresentation.RangeType.Primary;
                break;
            }
            default: {
                Log.logger((Object)this).warning(String.format("Unexpected sideband use (%s) in baseband %s", new Object[]{sideBandUse, baseBand.getBaseBandName()}));
                return;
            }
        }
        spectralRangeRepresentation2.setLabel(String.format("%s(L)", baseBand.getBaseBandName()));
        spectralRangeRepresentation.setLabel(String.format("%s(U)", baseBand.getBaseBandName()));
        baseBand.getBaseBandConfig().refreshPairList();
        for (SpectralWindowI spectralWindowI : baseBand.getSpectralWindow()) {
            boolean bl = true;
            boolean bl2 = true;
            if (dSBType == SpectralRangeRepresentation.DSBType.Separation) {
                switch (spectralWindowI.getSideBandUse()) {
                    case SIDEBANDUSE_BOTH: {
                        break;
                    }
                    case SIDEBANDUSE_LSB: {
                        bl2 = false;
                        break;
                    }
                    case SIDEBANDUSE_USB: {
                        bl = false;
                        break;
                    }
                    default: {
                        bl = false;
                        bl2 = false;
                        Log.logger((Object)this).warning(String.format("Unexpected SpectralWindow sideband use (%s) in baseband %s", new Object[]{spectralWindowI.getSideBandUse(), baseBand.getBaseBandName()}));
                    }
                }
            }
            SpectralRangeRepresentation spectralRangeRepresentation5 = this.addSWtoBBC(spectralRangeRepresentation2, spectralWindowI.getLSB(), SideBandUse.SIDEBANDUSE_LSB, bl ? rangeType2 : SpectralRangeRepresentation.RangeType.Suppressed, map);
            SpectralRangeRepresentation spectralRangeRepresentation6 = this.addSWtoBBC(spectralRangeRepresentation, spectralWindowI.getUSB(), SideBandUse.SIDEBANDUSE_USB, bl2 ? rangeType : SpectralRangeRepresentation.RangeType.Suppressed, map);
            if (spectralRangeRepresentation5 == null || spectralRangeRepresentation6 == null) continue;
            spectralRangeRepresentation5.setMirror(spectralRangeRepresentation6);
        }
    }

    private void addRanges(BaseBand baseBand, String string, Frequency frequency, Map<IBusinessObject, Collection<SpectralRangeRepresentation>> map) {
        SideBandUse sideBandUse;
        double d = baseBand.getBaseBandSpecification().getActualBaseBandCenterFrequencySky().getContentInGHz();
        SideBandUse sideBandUse2 = sideBandUse = d < frequency.getContentInGHz() ? SideBandUse.SIDEBANDUSE_LSB : SideBandUse.SIDEBANDUSE_USB;
        if (string.equals(SpectralSpec.RECEIVERTYPE_SSB) || string.equals(SpectralSpec.RECEIVERTYPE_TSB)) {
            this.addSingleSidebandRanges(baseBand, sideBandUse, map);
        } else if (string.equals(SpectralSpec.RECEIVERTYPE_DSB)) {
            if (baseBand.getBaseBandConfig() == null) {
                SpectralRangeRepresentation.DSBType dSBType = SpectralRangeRepresentation.DSBType.Both;
            } else {
                AbstractBaseBandConfig abstractBaseBandConfig = baseBand.getBaseBandConfig();
                if (abstractBaseBandConfig.getDataProducts().equals(AbstractBaseBandConfig.DATAPRODUCTS_AUTO_ONLY)) {
                    this.addBothSidebandRanges(abstractBaseBandConfig, sideBandUse, frequency, map);
                } else {
                    SpectralRangeRepresentation.DSBType dSBType = abstractBaseBandConfig.isRejectionMode() ? SpectralRangeRepresentation.DSBType.Rejection : SpectralRangeRepresentation.DSBType.Separation;
                    this.addMultipleSidebandRanges(abstractBaseBandConfig, sideBandUse, frequency, dSBType, map);
                }
            }
        } else if (string.equals(SpectralSpec.RECEIVERTYPE_NOSB)) {
            Log.logger((Object)this).warning(String.format("unsupported receiver type %s (ignoring baseband config %s in redraw)", string, baseBand.getBaseBandName()));
        } else {
            Log.logger((Object)this).warning(String.format("unknown receiver type %s (ignoring baseband config %s in redraw)", string, baseBand.getBaseBandName()));
        }
    }

    private Map<IBusinessObject, Collection<SpectralRangeRepresentation>> buildRanges(SpectralSpec spectralSpec) {
        HashMap<IBusinessObject, Collection<SpectralRangeRepresentation>> hashMap = new HashMap<IBusinessObject, Collection<SpectralRangeRepresentation>>();
        ReceiverBand receiverBand = spectralSpec.getReceiverBand();
        String string = receiverBand.getType();
        Frequency frequency = spectralSpec.getLO1Frequency();
        for (BaseBand baseBand : spectralSpec.getBaseBandHolder().getBaseBand()) {
            hashMap.put((IBusinessObject)baseBand, new HashSet());
            for (AbstractSpectralWindow abstractSpectralWindow : baseBand.getSingleSpectralWindow()) {
                hashMap.put((IBusinessObject)abstractSpectralWindow, new HashSet());
                for (ChannelAverageRegion channelAverageRegion : abstractSpectralWindow.getChannelAverageRegion()) {
                    hashMap.put((IBusinessObject)channelAverageRegion, new HashSet());
                }
            }
            this.addRanges(baseBand, string, frequency, hashMap);
        }
        return hashMap;
    }

    private void paintFullyDetailedSpectralSpecBBC(Graphics graphics, SpectralSpec spectralSpec) {
        Map<IBusinessObject, Collection<SpectralRangeRepresentation>> map = this.buildRanges(spectralSpec);
        this.paintBackground(graphics);
        if (this.getDrawOtherLines()) {
            this.paintKnownSpectralLinesLines(graphics, this.minTF, this.maxTF);
        }
        if (Log.logger((Object)this).finer()) {
            this.logBBCDebugInfo(spectralSpec, map);
        }
        BBCLevelManager bBCLevelManager = new BBCLevelManager(spectralSpec.getBaseBandHolder(), map, this.isFoldBasebands(), this.isSpectralWindowsFolded(), 3);
        this.paintBasebands(graphics, spectralSpec, map, bBCLevelManager);
        if (this.isDrawSideBands()) {
            this.paintSideBands(graphics, spectralSpec);
        }
        this.paintRepresentativeFrequency(graphics, spectralSpec);
        if (this.isDrawCentreFrequencies()) {
            this.drawBasebandCentreFrequencies(graphics, spectralSpec);
        }
    }

    private void logBBCDebugInfo(SpectralSpec spectralSpec, Map<IBusinessObject, Collection<SpectralRangeRepresentation>> map) {
        StringBuilder stringBuilder = new StringBuilder();
        Formatter formatter = new Formatter(stringBuilder);
        formatter.format("%s@%h.paintSpectralSpec(%s @ %h)%n", this.getClass().getSimpleName(), this.hashCode(), spectralSpec.getClass().getSimpleName(), spectralSpec.hashCode());
        spectralSpec.getBaseBandHolder().format(formatter, "\t");
        stringBuilder = new StringBuilder();
        formatter = new Formatter(stringBuilder);
        formatter.format("SpectralRangeRepresentations:%n", new Object[0]);
        for (BaseBand baseBand : spectralSpec.getBaseBandHolder().getBaseBand()) {
            formatter.format("\tBBC %s (#%d)%n", baseBand.getBaseBandName(), baseBand.getBaseBandIndex() + 1);
            for (SpectralRangeRepresentation spectralRangeRepresentation : map.get(baseBand)) {
                formatter.format("\t\t@%8h %7.3f - %7.3f GHz level:%2d %3s %10s %8h%n", new Object[]{spectralRangeRepresentation.hashCode(), spectralRangeRepresentation.getMinFrequencyGHz(), spectralRangeRepresentation.getMaxFrequencyGHz(), spectralRangeRepresentation.getLevel(), spectralRangeRepresentation.getSideband(), spectralRangeRepresentation.getType(), spectralRangeRepresentation.getMirror() == null ? 0 : spectralRangeRepresentation.getMirror().hashCode()});
            }
            for (AbstractSpectralWindow abstractSpectralWindow : baseBand.getSingleSpectralWindow()) {
                formatter.format("\t\t\tSW %h%n", abstractSpectralWindow.hashCode());
                for (SpectralRangeRepresentation spectralRangeRepresentation : map.get(abstractSpectralWindow)) {
                    formatter.format("\t\t\t\t@%8h %7.3f - %7.3f GHz level:%2d %3s %10s %8h%n", new Object[]{spectralRangeRepresentation.hashCode(), spectralRangeRepresentation.getMinFrequencyGHz(), spectralRangeRepresentation.getMaxFrequencyGHz(), spectralRangeRepresentation.getLevel(), spectralRangeRepresentation.getSideband(), spectralRangeRepresentation.getType(), spectralRangeRepresentation.getMirror() == null ? 0 : spectralRangeRepresentation.getMirror().hashCode()});
                }
                for (ChannelAverageRegion channelAverageRegion : abstractSpectralWindow.getChannelAverageRegion()) {
                    formatter.format("\t\t\t\tCAR %h%n", channelAverageRegion.hashCode());
                    for (SpectralRangeRepresentation spectralRangeRepresentation : map.get(channelAverageRegion)) {
                        formatter.format("\t\t\t\t\t@%8h %7.3f - %7.3f GHz level:%2d %3s %10s %8h%n", new Object[]{spectralRangeRepresentation.hashCode(), spectralRangeRepresentation.getMinFrequencyGHz(), spectralRangeRepresentation.getMaxFrequencyGHz(), spectralRangeRepresentation.getLevel(), spectralRangeRepresentation.getSideband(), spectralRangeRepresentation.getType(), spectralRangeRepresentation.getMirror() == null ? 0 : spectralRangeRepresentation.getMirror().hashCode()});
                    }
                }
            }
        }
        formatter.close();
    }

    public boolean mouseOnLo(@NonNull MouseEvent mouseEvent) {
        if (mouseEvent == null) {
            throw new NullPointerException("evt is marked non-null but is null");
        }
        SpectralSpec spectralSpec = (SpectralSpec)this.model.getDocument();
        double d = -1000.0;
        int n = -1000;
        if (spectralSpec != null && this.isDrawSideBands) {
            d = spectralSpec.getLO1Frequency().getContentInGHz();
            n = this.scaleOF(d);
        }
        return (double)Math.abs(mouseEvent.getX() - n) < 10.0;
    }

    public boolean mouseOnLine(MouseEvent mouseEvent) {
        SpectralSpec spectralSpec = (SpectralSpec)this.model.getDocument();
        double d = -1000.0;
        int n = -1000;
        if (spectralSpec != null) {
            d = spectralSpec.getFrequencySetup().getRestFrequency().getContentInGHz();
            n = this.scaleRestFrequency(d);
        }
        return (double)Math.abs(mouseEvent.getX() - n) < 10.0;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.pressedX = mouseEvent.getX();
        this.isDraggingLocally = this.mouseOnAxes(mouseEvent);
        this.isDraggingLo = this.mouseOnLo(mouseEvent) && this.isLODragAllowed();
        this.isDraggingLine = this.mouseOnLine(mouseEvent) && this.isLinesDragAllowed();
        this.pressedMinOF = this.minOF;
        this.pressedMaxOF = this.maxOF;
        if (this.isDraggingLocally || this.isDraggingLo || this.isDraggingLine) {
            this.setCursor(this.moveCursor);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (!(this.isDraggingLocally || this.isDraggingLo || this.isDraggingLine)) {
            if (mouseEvent.getButton() == 1) {
                this.zoomInAtCursor(3.0);
            } else if (mouseEvent.getButton() == 3) {
                this.zoomOutAtCursor(3.0);
            }
            this.repaint();
        }
        if (this.pressedX != mouseEvent.getX()) {
            return;
        }
        this.isDraggingLocally = false;
        this.isDraggingLo = false;
        this.isDraggingLine = false;
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.mouseOnAxes(mouseEvent) || this.mouseOnLo(mouseEvent) && this.isLODragAllowed() || this.mouseOnLine(mouseEvent) && this.isLinesDragAllowed()) {
            this.setCursor(this.handCursor);
        } else {
            this.setCursor(this.zoomCursor);
        }
        this.repaint();
    }

    public static void main(String[] stringArray) {
        double d;
        double d2;
        UnitMapConfigurator.configureUnitMaps();
        Velocity velocity = Velocity.createVelocity();
        Speed speed = Speed.createSpeed();
        Frequency[] frequencyArray = new Frequency[10];
        Frequency[] frequencyArray2 = new Frequency[frequencyArray.length];
        speed.setContent(2.8E8);
        speed.setUnit(Speed.UNIT_M_S);
        velocity.setCenterVelocity(speed);
        System.out.println("Before\t\tShifted\t\t\tChangeT\tChangeO\n");
        for (int i = 0; i < frequencyArray.length; ++i) {
            frequencyArray[i] = Frequency.createFrequencyGHZ(i * 100);
            frequencyArray2[i] = velocity.dopplerShift(frequencyArray[i]);
            System.out.print(String.valueOf((Object)frequencyArray[i]) + "\t" + String.valueOf((Object)frequencyArray2[i]));
            if (i > 0) {
                d2 = frequencyArray[i].getContentInGHz() - frequencyArray[i - 1].getContentInGHz();
                d = frequencyArray2[i].getContentInGHz() - frequencyArray2[i - 1].getContentInGHz();
                System.out.print("\t" + d2 + "\t" + d);
            }
            System.out.println();
        }
        Frequency frequency = Frequency.createFrequencyGHZ(230.53799);
        d2 = 0.0;
        double d3 = 2.0E8;
        Velocity velocity2 = Velocity.createVelocity();
        Velocity velocity3 = Velocity.createVelocity();
        Velocity velocity4 = Velocity.createVelocity();
        Speed speed2 = Speed.createSpeed();
        Speed speed3 = Speed.createSpeed();
        Speed speed4 = Speed.createSpeed();
        velocity2.setCenterVelocity(speed2);
        velocity3.setCenterVelocity(speed3);
        velocity4.setCenterVelocity(speed4);
        speed2.setUnit(Speed.UNIT_M_S);
        speed3.setUnit(Speed.UNIT_M_S);
        speed4.setUnit(Speed.UNIT_M_S);
        speed2.setContent(d2);
        speed4.setContent(d3);
        Frequency frequency2 = velocity4.dopplerShift(frequency);
        Frequency frequency3 = velocity2.dopplerShift(frequency);
        do {
            d = (d2 + d3) / 2.0;
            speed3.setContent(d);
            Frequency frequency4 = velocity3.dopplerShift(frequency);
            System.out.println("v: (" + String.valueOf((Object)speed2) + ":" + String.valueOf((Object)speed3) + ":" + String.valueOf((Object)speed4) + ") => f: (" + String.valueOf((Object)frequency2) + ":" + String.valueOf((Object)frequency4) + ":" + String.valueOf((Object)frequency3) + ")");
            double d4 = frequency4.getContentInGHz();
            if (d4 < 229.42) {
                d3 = d;
                speed4.setContent(speed3.getContent());
                frequency3.setContent(frequency4.getContent());
                continue;
            }
            d2 = d;
            speed2.setContent(speed3.getContent());
            frequency2.setContent(frequency4.getContent());
        } while (d3 - d2 > 1.0);
    }

    public void setDrawReceiverBands(boolean bl) {
        this.isDrawReceiverBands = bl;
    }

    public boolean isDrawReceiverBands() {
        return this.isDrawReceiverBands;
    }

    public void setDrawCentreFrequencies(boolean bl) {
        this.isDrawCentreFrequencies = bl;
    }

    public boolean isDrawCentreFrequencies() {
        return this.isDrawCentreFrequencies;
    }

    public boolean isDrawBasebands() {
        return this.isDrawBasebands;
    }

    public void setDrawBasebands(boolean bl) {
        this.isDrawBasebands = bl;
    }

    public void setDrawSideBands(boolean bl) {
        this.isDrawSideBands = bl;
    }

    public boolean isDrawSideBands() {
        return this.isDrawSideBands;
    }

    public int getSelectedBBC() {
        return this.selectedBBC;
    }

    public boolean isFoldBasebands() {
        return this.isFoldBasebands;
    }

    public void setFoldBasebands(boolean bl) {
        this.isFoldBasebands = bl;
    }
}

