/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.models.obsproject;

import alma.obsprep.bo.obsproject.Circle;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.ot.boEditors.FieldIDs;
import alma.obsprep.ot.models.valuetypes.SkyCoordsModel;
import alma.obsprep.ot.models.valuetypes.ValueUnitPairModel;
import alma.valuetypes.Angle;
import alma.valuetypes.SkyCoordinates;
import alma.valuetypes.UserAngle;

public class CircleModel
extends Model {
    private SkyCoordsModel centreModel = null;
    private ValueUnitPairModel radiusModel = null;
    private ValueUnitPairModel spacingModel = null;
    public final FieldID radiusValueFID = new FieldID("Circle.radius.value");
    public final FieldID radiusUnitFID = new FieldID("Circle.radius.unit");
    public final FieldID spacingValueFID = new FieldID("Circle.spacing.value");
    public final FieldID spacingUnitFID = new FieldID("Circle.spacing.unit");

    public CircleModel(Object object) {
        super(object);
        this.centreModel = new SkyCoordsModel(null);
        this.radiusModel = new ValueUnitPairModel(null, this.radiusValueFID, this.radiusUnitFID);
        this.spacingModel = new ValueUnitPairModel(null, this.spacingValueFID, this.spacingUnitFID);
    }

    private Circle getShape() {
        return (Circle)((Object)this.getDocument());
    }

    @Override
    public void publish() {
        Circle circle = this.getShape();
        if (circle != null) {
            this.getCentreModel().publish();
            this.getRadiusModel().publish();
            this.getSpacingModel().publish();
            this.publish(FieldIDs.nameFID, circle.getName());
        }
    }

    @Override
    public Object update(Editor editor, FieldID fieldID, Object object) {
        if (fieldID == FieldIDs.nameFID) {
            String string = (String)object;
            this.getShape().setName(string);
            return string;
        }
        return null;
    }

    @Override
    public void setDocument(Object object) {
        super.setDocument(object);
        Circle circle = this.getShape();
        SkyCoordinates skyCoordinates = circle.getCentre();
        this.getCentreModel().setDocument(skyCoordinates);
        Angle angle = circle.getRadius();
        this.getRadiusModel().setDocument((Object)angle);
        UserAngle userAngle = circle.getSpacing();
        this.getSpacingModel().setDocument(userAngle);
    }

    public SkyCoordsModel getCentreModel() {
        return this.centreModel;
    }

    public ValueUnitPairModel getRadiusModel() {
        return this.radiusModel;
    }

    public ValueUnitPairModel getSpacingModel() {
        return this.spacingModel;
    }
}

